---
UID: NN:commoncontrols.IImageList2
title: IImageList2 (commoncontrols.h)
description: Extends IImageList by providing additional methods for manipulating and interacting with image lists.
old-location: controls\IImageList2.htm
tech.root: Controls
ms.assetid: VS|Controls|~\controls\imagelist\ifaces\iimagelist2\iimagelist2.htm
ms.date: 12/05/2018
ms.keywords: IImageList2, IImageList2 interface [Windows Controls], IImageList2 interface [Windows Controls],described, _shell_IImageList2, _shell_IImageList2_cpp, commoncontrols/IImageList2, controls.IImageList2, controls._shell_IImageList2
f1_keywords:
- commoncontrols/IImageList2
dev_langs:
- c++
req.header: commoncontrols.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Commoncontrols.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Commoncontrols.h
api_name:
- IImageList2
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IImageList2 interface


## -description


Extends <a href="https://docs.microsoft.com/windows/desktop/api/commoncontrols/nn-commoncontrols-iimagelist">IImageList</a> by providing additional methods for manipulating and interacting with image lists.


## -inheritance

The <b xmlns:loc="http://microsoft.com/wdcml/l10n">IImageList2</b> interface inherits from <a href="https://docs.microsoft.com/windows/desktop/api/commoncontrols/nn-commoncontrols-iimagelist">IImageList</a>. <b>IImageList2</b> also has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul>

## -members

The <b>IImageList2</b> interface has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/commoncontrols/nf-commoncontrols-iimagelist2-discardimages">DiscardImages</a>
</td>
<td align="left" width="63%">
Discards images from list, as specified.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/commoncontrols/nf-commoncontrols-iimagelist2-forceimagepresent">ForceImagePresent</a>
</td>
<td align="left" width="63%">
Forces an image present, as specified.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/commoncontrols/nf-commoncontrols-iimagelist2-getcallback">GetCallback</a>
</td>
<td align="left" width="63%">
Gets an image list callback object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/commoncontrols/nf-commoncontrols-iimagelist2-getoriginalsize">GetOriginalSize</a>
</td>
<td align="left" width="63%">
Gets the original size of a specified image.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/commoncontrols/nf-commoncontrols-iimagelist2-getstatistics">GetStatistics</a>
</td>
<td align="left" width="63%">
Gets an image list statistics structure.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/commoncontrols/nf-commoncontrols-iimagelist2-initialize">Initialize</a>
</td>
<td align="left" width="63%">
Initializes an image list, as specified.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/commoncontrols/nf-commoncontrols-iimagelist2-preloadimages">PreloadImages</a>
</td>
<td align="left" width="63%">
Preloads images, as specified.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/commoncontrols/nf-commoncontrols-iimagelist2-replace2">Replace2</a>
</td>
<td align="left" width="63%">
Replaces an image in an image list.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/commoncontrols/nf-commoncontrols-iimagelist2-replacefromimagelist">ReplaceFromImageList</a>
</td>
<td align="left" width="63%">
Replaces an image in one image list with an image from another image list.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/commoncontrols/nf-commoncontrols-iimagelist2-resize">Resize</a>
</td>
<td align="left" width="63%">
Resizes the current image.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/commoncontrols/nf-commoncontrols-iimagelist2-setcallback">SetCallback</a>
</td>
<td align="left" width="63%">
Sets an image list callback.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/commoncontrols/nf-commoncontrols-iimagelist2-setoriginalsize">SetOriginalSize</a>
</td>
<td align="left" width="63%">
Sets the original size of a specified image.

</td>
</tr>
</table> 

