---
UID: NE:comsvcs.tagCOMPLUS_APPTYPE
title: COMPLUS_APPTYPE (comsvcs.h)
description: Represents types of applications tracked by the tracker server.
old-location: cos\complus_apptype.htm
tech.root: cossdk
ms.assetid: 121d287f-067b-4640-ac81-43904463ded4
ms.date: 12/05/2018
ms.keywords: APPTYPE_LIBRARY, APPTYPE_SERVER, APPTYPE_SWC, APPTYPE_UNKNOWN, COMPLUS_APPTYPE, COMPLUS_APPTYPE enumeration [COM+], comsvcs/APPTYPE_LIBRARY, comsvcs/APPTYPE_SERVER, comsvcs/APPTYPE_SWC, comsvcs/APPTYPE_UNKNOWN, comsvcs/COMPLUS_APPTYPE, cos.complus_apptype
f1_keywords:
- comsvcs/COMPLUS_APPTYPE
dev_langs:
- c++
req.header: comsvcs.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP with SP2 [desktop apps only]
req.target-min-winversvr: Windows Server 2003 with SP1 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- ComSvcs.h
api_name:
- COMPLUS_APPTYPE
targetos: Windows
req.typenames: COMPLUS_APPTYPE
req.redist: 
ms.custom: 19H1
---

# COMPLUS_APPTYPE enumeration


## -description


Represents types of applications tracked by the tracker server.


## -enum-fields




### -field APPTYPE_UNKNOWN

This value is not used.


### -field APPTYPE_SERVER

COM+ server application.


### -field APPTYPE_LIBRARY

COM+ library application.


### -field APPTYPE_SWC

COM+ services without components.



## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/comsvcs/ns-comsvcs-applicationprocesssummary">ApplicationProcessSummary</a>



<a href="https://docs.microsoft.com/windows/desktop/api/comsvcs/ns-comsvcs-applicationsummary">ApplicationSummary</a>
 

 

