---
UID: NF:control.IMediaEventEx.SetNotifyWindow
title: IMediaEventEx::SetNotifyWindow (control.h)
description: The SetNotifyWindow method registers a window to process event notifications.
old-location: dshow\imediaeventex_setnotifywindow.htm
tech.root: DirectShow
ms.assetid: 3e582c79-b8c7-40be-97fd-75d5b7965570
ms.date: 12/05/2018
ms.keywords: IMediaEventEx interface [DirectShow],SetNotifyWindow method, IMediaEventEx.SetNotifyWindow, IMediaEventEx::SetNotifyWindow, IMediaEventExSetNotifyWindow, SetNotifyWindow, SetNotifyWindow method [DirectShow], SetNotifyWindow method [DirectShow],IMediaEventEx interface, control/IMediaEventEx::SetNotifyWindow, dshow.imediaeventex_setnotifywindow
f1_keywords:
- control/IMediaEventEx.SetNotifyWindow
dev_langs:
- c++
req.header: control.h
req.include-header: Dshow.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Strmiids.lib
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Strmiids.lib
- Strmiids.dll
api_name:
- IMediaEventEx.SetNotifyWindow
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IMediaEventEx::SetNotifyWindow


## -description



The <code>SetNotifyWindow</code> method registers a window to process event notifications.




## -parameters




### -param hwnd [in]

Handle to the window, or <b>NULL</b> to stop receiving event messages.


### -param lMsg [in]

Window message to be passed as the notification.


### -param lInstanceData [in]

Value to be passed as the <i>lParam</i> parameter for the <i>lMsg</i> message.


## -returns



Returns S_OK if successful or E_INVALIDARG if the <i>hwnd</i> parameter is not a valid handle to a window.




## -remarks



This method designates a window that will process event notifications. Whenever the Filter Graph Manager puts an event in the event queue, it will also post a message to the designated window. The <i>hwnd</i> parameter specifies the window, and the <i>lMsg</i> parameter specifies the message. The application should define a private window message for this purpose. The message's <i>lParam</i> parameter is set to the value of <b>lInstanceData</b>, and the <i>wParam</i> parameter is set to zero.

When the window receives the message, it should call the <a href="https://docs.microsoft.com/windows/desktop/api/control/nf-control-imediaevent-getevent">IMediaEvent::GetEvent</a> method to retrieve the event. Events are asynchronous, so the queue might contain several events (or none). Call <b>GetEvent</b> repeatedly, until it returns an error code.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/DirectShow/error-and-success-codes">Error and Success Codes</a>



<a href="https://docs.microsoft.com/windows/desktop/api/control/nn-control-imediaeventex">IMediaEventEx Interface</a>
 

 

