---
UID: NF:cryptuiapi.CryptUIWizImport
title: CryptUIWizImport function (cryptuiapi.h)
description: Imports a certificate, a certificate trust list (CTL), a certificate revocation list (CRL), or a certificate store to a certificate store.
old-location: security\cryptuiwizimport.htm
tech.root: SecCrypto
ms.assetid: 6b2b9c89-229a-4626-a8b4-fe2b7cc0af86
ms.date: 12/05/2018
ms.keywords: CRYPTUI_WIZ_IGNORE_NO_UI_FLAG_FOR_CSPS, CRYPTUI_WIZ_IMPORT_ALLOW_CERT, CRYPTUI_WIZ_IMPORT_ALLOW_CRL, CRYPTUI_WIZ_IMPORT_ALLOW_CTL, CRYPTUI_WIZ_IMPORT_NO_CHANGE_DEST_STORE, CRYPTUI_WIZ_IMPORT_REMOTE_DEST_STORE, CRYPTUI_WIZ_IMPORT_TO_CURRENTUSER, CRYPTUI_WIZ_IMPORT_TO_LOCALMACHINE, CRYPTUI_WIZ_NO_UI, CRYPTUI_WIZ_NO_UI_EXCEPT_CSP, CryptUIWizImport, CryptUIWizImport function [Security], cryptuiapi/CryptUIWizImport, security.cryptuiwizimport
f1_keywords:
- cryptuiapi/CryptUIWizImport
dev_langs:
- c++
req.header: cryptuiapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Cryptui.lib
req.dll: Cryptui.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Cryptui.dll
api_name:
- CryptUIWizImport
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# CryptUIWizImport function


## -description


The  function imports a <a href="https://docs.microsoft.com/windows/desktop/SecGloss/c-gly">certificate</a>, a <a href="https://docs.microsoft.com/windows/desktop/SecGloss/c-gly">certificate trust list</a> (CTL), a <a href="https://docs.microsoft.com/windows/desktop/SecGloss/c-gly">certificate revocation list</a> (CRL), or a <a href="https://docs.microsoft.com/windows/desktop/SecGloss/c-gly">certificate store</a> to a certificate store. The import can be performed with or without user interaction.


## -parameters




### -param dwFlags [in]

 Contains flags that modify the behavior of the function. This can be zero or a combination of one or more of the following values.

<div class="alert"><b>Note</b>  Except for <b>CRYPTUI_WIZ_NO_UI</b>, none of the following constants are defined in a published header file. To use these constants, you must define them by using the specified values.</div>
<div> </div>
<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="CRYPTUI_WIZ_NO_UI"></a><a id="cryptui_wiz_no_ui"></a><dl>
<dt><b>CRYPTUI_WIZ_NO_UI</b></dt>
<dt>0x0001</dt>
</dl>
</td>
<td width="60%">
This function will perform the import based on the information in the <a href="https://docs.microsoft.com/windows/win32/api/cryptuiapi/ns-cryptuiapi-cryptui_wiz_import_src_info">CRYPTUI_WIZ_IMPORT_SRC_INFO</a> structure pointed to by <i>pImportSrc</i> into the store specified by <i>hDestCertStore</i> without displaying any user interface. If this flag is not specified, this function will display a wizard to guide the user through the import process.

Beginning with Windows 8 and Windows Server 2012, if you set this flag and are importing a certificate from a PFX BLOB that was protected to an Active Directory (AD) principal, and the current user, as part of that principal, has permission to decrypt the password embedded in the PFX packet, the importation will succeed without requiring that a password be set in the <a href="https://docs.microsoft.com/windows/win32/api/cryptuiapi/ns-cryptuiapi-cryptui_wiz_import_src_info">CRYPTUI_WIZ_IMPORT_SRC_INFO</a> structure. For more information about protecting PFX to an AD principal, see the <i>pvPara</i> parameter and the <b>PKCS12_PROTECT_TO_DOMAIN_SIDS</b> flag of the <a href="https://docs.microsoft.com/windows/desktop/api/wincrypt/nf-wincrypt-pfxexportcertstoreex">PFXExportCertStoreEx</a> function.

</td>
</tr>
<tr>
<td width="40%"><a id="CRYPTUI_WIZ_IGNORE_NO_UI_FLAG_FOR_CSPS"></a><a id="cryptui_wiz_ignore_no_ui_flag_for_csps"></a><dl>
<dt><b>CRYPTUI_WIZ_IGNORE_NO_UI_FLAG_FOR_CSPS</b></dt>
<dt>0x0002</dt>
</dl>
</td>
<td width="60%">
Suppress all user interfaces generated by <a href="https://docs.microsoft.com/windows/desktop/SecGloss/c-gly">cryptographic service providers</a> (CSPs). This option can be overridden by the <b>CRYPTUI_WIZ_NO_UI_EXCEPT_CSP</b> option.

</td>
</tr>
<tr>
<td width="40%"><a id="CRYPTUI_WIZ_NO_UI_EXCEPT_CSP"></a><a id="cryptui_wiz_no_ui_except_csp"></a><dl>
<dt><b>CRYPTUI_WIZ_NO_UI_EXCEPT_CSP</b></dt>
<dt>0x0003</dt>
</dl>
</td>
<td width="60%">
Suppress all user interfaces except those generated by CSPs. This option overrides the <b>CRYPTUI_WIZ_IGNORE_NO_UI_FLAG_FOR_CSPS</b> option.

</td>
</tr>
<tr>
<td width="40%"><a id="CRYPTUI_WIZ_IMPORT_ALLOW_CERT"></a><a id="cryptui_wiz_import_allow_cert"></a><dl>
<dt><b>CRYPTUI_WIZ_IMPORT_ALLOW_CERT</b></dt>
<dt>0x00020000</dt>
</dl>
</td>
<td width="60%">
Allow certificates to be imported.

</td>
</tr>
<tr>
<td width="40%"><a id="CRYPTUI_WIZ_IMPORT_ALLOW_CRL"></a><a id="cryptui_wiz_import_allow_crl"></a><dl>
<dt><b>CRYPTUI_WIZ_IMPORT_ALLOW_CRL</b></dt>
<dt>0x00040000</dt>
</dl>
</td>
<td width="60%">
Allow CRLs to be imported.

</td>
</tr>
<tr>
<td width="40%"><a id="CRYPTUI_WIZ_IMPORT_ALLOW_CTL"></a><a id="cryptui_wiz_import_allow_ctl"></a><dl>
<dt><b>CRYPTUI_WIZ_IMPORT_ALLOW_CTL</b></dt>
<dt>0x00080000</dt>
</dl>
</td>
<td width="60%">
Allow CTLs to be imported.

</td>
</tr>
<tr>
<td width="40%"><a id="CRYPTUI_WIZ_IMPORT_NO_CHANGE_DEST_STORE"></a><a id="cryptui_wiz_import_no_change_dest_store"></a><dl>
<dt><b>CRYPTUI_WIZ_IMPORT_NO_CHANGE_DEST_STORE</b></dt>
<dt>0x00010000</dt>
</dl>
</td>
<td width="60%">
Do not allow the user to change
the destination certificate store represented by the 
<i>hDestCertStore</i> parameter.

</td>
</tr>
<tr>
<td width="40%"><a id="CRYPTUI_WIZ_IMPORT_TO_LOCALMACHINE"></a><a id="cryptui_wiz_import_to_localmachine"></a><dl>
<dt><b>CRYPTUI_WIZ_IMPORT_TO_LOCALMACHINE</b></dt>
<dt>0x00100000</dt>
</dl>
</td>
<td width="60%">
Import the object to the certificate store for the local computer.
This  applies only to Personal Information Exchange (PFX) imports.

</td>
</tr>
<tr>
<td width="40%"><a id="CRYPTUI_WIZ_IMPORT_TO_CURRENTUSER"></a><a id="cryptui_wiz_import_to_currentuser"></a><dl>
<dt><b>CRYPTUI_WIZ_IMPORT_TO_CURRENTUSER</b></dt>
<dt>0x00200000</dt>
</dl>
</td>
<td width="60%">
Import the object to the certificate store for the current user.
This  applies only to PFX imports.

</td>
</tr>
<tr>
<td width="40%"><a id="CRYPTUI_WIZ_IMPORT_REMOTE_DEST_STORE"></a><a id="cryptui_wiz_import_remote_dest_store"></a><dl>
<dt><b>CRYPTUI_WIZ_IMPORT_REMOTE_DEST_STORE</b></dt>
<dt>0x00400000</dt>
</dl>
</td>
<td width="60%">
Import the object to a remote certificate store.  Set this flag if the <i>hDestCertStore</i> parameter represents a remote certificate store.

</td>
</tr>
</table>
 


### -param hwndParent [in]

The handle of the window to use as the parent of the dialog box that  this function creates. This parameter is ignored if the <b>CRYPTUI_WIZ_NO_UI</b> flag is set in <i>dwFlags</i>.


### -param pwszWizardTitle [in]

A pointer to a null-terminated Unicode string that contains the title to use in the dialog box that this function creates. This parameter is ignored if the <b>CRYPTUI_WIZ_NO_UI</b> flag is set in <i>dwFlags</i>.


### -param pImportSrc [in]

A pointer to a <a href="https://docs.microsoft.com/windows/win32/api/cryptuiapi/ns-cryptuiapi-cryptui_wiz_import_src_info">CRYPTUI_WIZ_IMPORT_SRC_INFO</a> structure that contains information about the object to import. This parameter is required if <b>CRYPTUI_WIZ_NO_UI</b> is set in <i>dwFlags</i> and is optional otherwise.


### -param hDestCertStore [in]

A handle to the certificate store to import to. If this parameter is <b>NULL</b> and the <b>CRYPTUI_WIZ_NO_UI</b> flag is not set in <i>dwFlags</i>, the wizard will prompt the user to select a certificate store.


## -returns



If the function succeeds, the function returns nonzero.

If the function fails, it returns zero. For extended error information, call 
the <a href="https://docs.microsoft.com/windows/desktop/api/errhandlingapi/nf-errhandlingapi-getlasterror">GetLastError</a> function.




## -remarks



If none of following three flags are set in <i>dwFlags</i>, import of any type of content is allowed:

<ul>
<li>CRYPTUI_WIZ_IMPORT_ALLOW_CERT</li>
<li>CRYPTUI_WIZ_IMPORT_ALLOW_CRL</li>
<li>CRYPTUI_WIZ_IMPORT_ALLOW_CTL</li>
</ul>
The <b>CRYPTUI_WIZ_IMPORT_TO_LOCALMACHINE</b> and <b>CRYPTUI_WIZ_IMPORT_TO_CURRENTUSER</b>flags are used to force the content of a PFX <a href="https://docs.microsoft.com/windows/desktop/SecGloss/b-gly">BLOB</a> into either the local machine store or the current user store.
If neither of these flags are set and <i>hDestCertStore</i> is <b>NULL</b>:

<ul>
<li>The private key in the PFX <a href="https://docs.microsoft.com/windows/desktop/SecGloss/b-gly">BLOB</a> will be forced to be imported into the current user store.</li>
<li>And if <b>CRYPTUI_WIZ_NO_UI</b> is not set, the wizard prompts the user to select a certificate 
store from among the current user certificate stores.</li>
</ul>



## -see-also




<a href="https://docs.microsoft.com/windows/win32/api/cryptuiapi/ns-cryptuiapi-cryptui_wiz_import_src_info">CRYPTUI_WIZ_IMPORT_SRC_INFO</a>



<a href="https://docs.microsoft.com/windows/desktop/api/cryptuiapi/nf-cryptuiapi-cryptuiwizexport">CryptUIWizExport</a>
 

 

