---
UID: NE:cscobj.tagOFFLINEFILES_EVENTS
title: OFFLINEFILES_EVENTS (cscobj.h)
description: Event identifier codes describing events to be received or excluded by an event sink.
old-location: of\offlinefiles_events.htm
tech.root: offlinefiles
ms.assetid: 4ab65756-5985-4240-805d-2221db3d1459
ms.date: 12/05/2018
ms.keywords: OFFLINEFILES_EVENTS, OFFLINEFILES_EVENTS enumeration [Offline Files], OFFLINEFILES_EVENT_BACKGROUNDSYNCBEGIN, OFFLINEFILES_EVENT_BACKGROUNDSYNCEND, OFFLINEFILES_EVENT_CACHEEVICTBEGIN, OFFLINEFILES_EVENT_CACHEEVICTEND, OFFLINEFILES_EVENT_CACHEISCORRUPTED, OFFLINEFILES_EVENT_CACHEISFULL, OFFLINEFILES_EVENT_CACHEMOVED, OFFLINEFILES_EVENT_DATALOST, OFFLINEFILES_EVENT_ENABLED, OFFLINEFILES_EVENT_ENCRYPTIONCHANGED, OFFLINEFILES_EVENT_ITEMADDEDTOCACHE, OFFLINEFILES_EVENT_ITEMAVAILABLEOFFLINE, OFFLINEFILES_EVENT_ITEMDELETEDFROMCACHE, OFFLINEFILES_EVENT_ITEMDISCONNECTED, OFFLINEFILES_EVENT_ITEMMODIFIED, OFFLINEFILES_EVENT_ITEMNOTAVAILABLEOFFLINE, OFFLINEFILES_EVENT_ITEMNOTPINNED, OFFLINEFILES_EVENT_ITEMPINNED, OFFLINEFILES_EVENT_ITEMRECONNECTBEGIN, OFFLINEFILES_EVENT_ITEMRECONNECTED, OFFLINEFILES_EVENT_ITEMRECONNECTEND, OFFLINEFILES_EVENT_ITEMRENAMED, OFFLINEFILES_EVENT_NETTRANSPORTARRIVED, OFFLINEFILES_EVENT_NONETTRANSPORTS, OFFLINEFILES_EVENT_PING, OFFLINEFILES_EVENT_POLICYCHANGEDETECTED, OFFLINEFILES_EVENT_PREFERENCECHANGEDETECTED, OFFLINEFILES_EVENT_PREFETCHFILEBEGIN, OFFLINEFILES_EVENT_PREFETCHFILEEND, OFFLINEFILES_EVENT_SETTINGSCHANGESAPPLIED, OFFLINEFILES_EVENT_SYNCBEGIN, OFFLINEFILES_EVENT_SYNCCONFLICTRECADDED, OFFLINEFILES_EVENT_SYNCCONFLICTRECREMOVED, OFFLINEFILES_EVENT_SYNCCONFLICTRECUPDATED, OFFLINEFILES_EVENT_SYNCEND, OFFLINEFILES_EVENT_SYNCFILERESULT, OFFLINEFILES_EVENT_TRANSPARENTCACHEITEMNOTIFY, cscobj/OFFLINEFILES_EVENTS, cscobj/OFFLINEFILES_EVENT_BACKGROUNDSYNCBEGIN, cscobj/OFFLINEFILES_EVENT_BACKGROUNDSYNCEND, cscobj/OFFLINEFILES_EVENT_CACHEEVICTBEGIN, cscobj/OFFLINEFILES_EVENT_CACHEEVICTEND, cscobj/OFFLINEFILES_EVENT_CACHEISCORRUPTED, cscobj/OFFLINEFILES_EVENT_CACHEISFULL, cscobj/OFFLINEFILES_EVENT_CACHEMOVED, cscobj/OFFLINEFILES_EVENT_DATALOST, cscobj/OFFLINEFILES_EVENT_ENABLED, cscobj/OFFLINEFILES_EVENT_ENCRYPTIONCHANGED, cscobj/OFFLINEFILES_EVENT_ITEMADDEDTOCACHE, cscobj/OFFLINEFILES_EVENT_ITEMAVAILABLEOFFLINE, cscobj/OFFLINEFILES_EVENT_ITEMDELETEDFROMCACHE, cscobj/OFFLINEFILES_EVENT_ITEMDISCONNECTED, cscobj/OFFLINEFILES_EVENT_ITEMMODIFIED, cscobj/OFFLINEFILES_EVENT_ITEMNOTAVAILABLEOFFLINE, cscobj/OFFLINEFILES_EVENT_ITEMNOTPINNED, cscobj/OFFLINEFILES_EVENT_ITEMPINNED, cscobj/OFFLINEFILES_EVENT_ITEMRECONNECTBEGIN, cscobj/OFFLINEFILES_EVENT_ITEMRECONNECTED, cscobj/OFFLINEFILES_EVENT_ITEMRECONNECTEND, cscobj/OFFLINEFILES_EVENT_ITEMRENAMED, cscobj/OFFLINEFILES_EVENT_NETTRANSPORTARRIVED, cscobj/OFFLINEFILES_EVENT_NONETTRANSPORTS, cscobj/OFFLINEFILES_EVENT_PING, cscobj/OFFLINEFILES_EVENT_POLICYCHANGEDETECTED, cscobj/OFFLINEFILES_EVENT_PREFERENCECHANGEDETECTED, cscobj/OFFLINEFILES_EVENT_PREFETCHFILEBEGIN, cscobj/OFFLINEFILES_EVENT_PREFETCHFILEEND, cscobj/OFFLINEFILES_EVENT_SETTINGSCHANGESAPPLIED, cscobj/OFFLINEFILES_EVENT_SYNCBEGIN, cscobj/OFFLINEFILES_EVENT_SYNCCONFLICTRECADDED, cscobj/OFFLINEFILES_EVENT_SYNCCONFLICTRECREMOVED, cscobj/OFFLINEFILES_EVENT_SYNCCONFLICTRECUPDATED, cscobj/OFFLINEFILES_EVENT_SYNCEND, cscobj/OFFLINEFILES_EVENT_SYNCFILERESULT, cscobj/OFFLINEFILES_EVENT_TRANSPARENTCACHEITEMNOTIFY, of.offlinefiles_events
f1_keywords:
- cscobj/OFFLINEFILES_EVENTS
dev_langs:
- c++
req.header: cscobj.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- CscObj.h
api_name:
- OFFLINEFILES_EVENTS
targetos: Windows
req.typenames: OFFLINEFILES_EVENTS
req.redist: 
ms.custom: 19H1
---

# OFFLINEFILES_EVENTS enumeration


## -description


Event identifier codes describing events to be received or excluded by an event sink. Used with the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefileseventsfilter-getincludedevents">IOfflineFilesEventsFilter::GetIncludedEvents</a> and <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefileseventsfilter-getexcludedevents">IOfflineFilesEventsFilter::GetExcludedEvents</a> methods.


## -enum-fields




### -field OFFLINEFILES_EVENT_CACHEMOVED

This value is reserved for future use.


### -field OFFLINEFILES_EVENT_CACHEISFULL

This value is reserved for future use.


### -field OFFLINEFILES_EVENT_CACHEISCORRUPTED

This value is reserved for future use.


### -field OFFLINEFILES_EVENT_ENABLED

This value is reserved for future use.


### -field OFFLINEFILES_EVENT_ENCRYPTIONCHANGED

This value is reserved for future use.


### -field OFFLINEFILES_EVENT_SYNCBEGIN

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents-syncbegin">IOfflineFilesEvents::SyncBegin</a> event method.


### -field OFFLINEFILES_EVENT_SYNCFILERESULT

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents-syncfileresult">IOfflineFilesEvents::SyncFileResult</a> event method.


### -field OFFLINEFILES_EVENT_SYNCCONFLICTRECADDED

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents-syncconflictrecadded">IOfflineFilesEvents::SyncConflictRecAdded</a> event method.


### -field OFFLINEFILES_EVENT_SYNCCONFLICTRECUPDATED

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents-syncconflictrecupdated">IOfflineFilesEvents::SyncConflictRecUpdated</a> event method.


### -field OFFLINEFILES_EVENT_SYNCCONFLICTRECREMOVED

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents-syncconflictrecremoved">IOfflineFilesEvents::SyncConflictRecRemoved</a> event method.


### -field OFFLINEFILES_EVENT_SYNCEND

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents-syncend">IOfflineFilesEvents::SyncEnd</a> event method.


### -field OFFLINEFILES_EVENT_BACKGROUNDSYNCBEGIN

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents2-backgroundsyncbegin">IOfflineFilesEvents2::BackgroundSyncBegin</a> event method.


### -field OFFLINEFILES_EVENT_BACKGROUNDSYNCEND

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents2-backgroundsyncend">IOfflineFilesEvents2::BackgroundSyncEnd</a> event method.


### -field OFFLINEFILES_EVENT_NETTRANSPORTARRIVED

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents-nettransportarrived">IOfflineFilesEvents::NetTransportArrived</a> event method.


### -field OFFLINEFILES_EVENT_NONETTRANSPORTS

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents-nonettransports">IOfflineFilesEvents::NoNetTransports</a> event method.


### -field OFFLINEFILES_EVENT_ITEMDISCONNECTED

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents-itemdisconnected">IOfflineFilesEvents::ItemDisconnected</a> event method.


### -field OFFLINEFILES_EVENT_ITEMRECONNECTED

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents-itemreconnected">IOfflineFilesEvents::ItemReconnected</a> event method.


### -field OFFLINEFILES_EVENT_ITEMAVAILABLEOFFLINE

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents-itemavailableoffline">IOfflineFilesEvents::ItemAvailableOffline</a> event method.


### -field OFFLINEFILES_EVENT_ITEMNOTAVAILABLEOFFLINE

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents-itemnotavailableoffline">IOfflineFilesEvents::ItemNotAvailableOffline</a> event method.


### -field OFFLINEFILES_EVENT_ITEMPINNED

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents-itempinned">IOfflineFilesEvents::ItemPinned</a> event method.


### -field OFFLINEFILES_EVENT_ITEMNOTPINNED

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents-itemnotpinned">IOfflineFilesEvents::ItemNotPinned</a> event method.


### -field OFFLINEFILES_EVENT_ITEMMODIFIED

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents-itemmodified">IOfflineFilesEvents::ItemModified</a> event method.


### -field OFFLINEFILES_EVENT_ITEMADDEDTOCACHE

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents-itemaddedtocache">IOfflineFilesEvents::ItemAddedToCache</a> event method.


### -field OFFLINEFILES_EVENT_ITEMDELETEDFROMCACHE

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents-itemdeletedfromcache">IOfflineFilesEvents::ItemDeletedFromCache</a> event method.


### -field OFFLINEFILES_EVENT_ITEMRENAMED

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents-itemrenamed">IOfflineFilesEvents::ItemRenamed</a> event method.


### -field OFFLINEFILES_EVENT_DATALOST

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents-datalost">IOfflineFilesEvents::DataLost</a> event method.


### -field OFFLINEFILES_EVENT_PING

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents-ping">IOfflineFilesEvents::Ping</a> event method.


### -field OFFLINEFILES_EVENT_ITEMRECONNECTBEGIN

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents2-itemreconnectbegin">IOfflineFilesEvents2::ItemReconnectBegin</a> event method.


### -field OFFLINEFILES_EVENT_ITEMRECONNECTEND

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents2-itemreconnectend">IOfflineFilesEvents2::ItemReconnectEnd</a> event method.


### -field OFFLINEFILES_EVENT_CACHEEVICTBEGIN

This value is reserved for future use.


### -field OFFLINEFILES_EVENT_CACHEEVICTEND

This value is reserved for future use.


### -field OFFLINEFILES_EVENT_POLICYCHANGEDETECTED

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents2-policychangedetected">IOfflineFilesEvents2::PolicyChangeDetected</a> event method.


### -field OFFLINEFILES_EVENT_PREFERENCECHANGEDETECTED

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents2-preferencechangedetected">IOfflineFilesEvents2::PreferenceChangeDetected</a> event method.


### -field OFFLINEFILES_EVENT_SETTINGSCHANGESAPPLIED

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents2-settingschangesapplied">IOfflineFilesEvents2::SettingsChangesApplied</a> event method.


### -field OFFLINEFILES_EVENT_TRANSPARENTCACHEITEMNOTIFY

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents3-transparentcacheitemnotify">IOfflineFilesEvents3::TransparentCacheItemNotify</a> event method.

<b>Windows Server 2008 and Windows Vista:  </b>This value is not supported before Windows Server 2008 R2 and Windows 7.


### -field OFFLINEFILES_EVENT_PREFETCHFILEBEGIN

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents3-prefetchfilebegin">IOfflineFilesEvents3::PrefetchFileBegin</a> event method.

<b>Windows Server 2008 and Windows Vista:  </b>This value is not supported before Windows Server 2008 R2 and Windows 7.


### -field OFFLINEFILES_EVENT_PREFETCHFILEEND

Represents the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilesevents3-prefetchfileend">IOfflineFilesEvents3::PrefetchFileEnd</a> event method.

<b>Windows Server 2008 and Windows Vista:  </b>This value is not supported before Windows Server 2008 R2 and Windows 7.


### -field OFFLINEFILES_EVENT_PREFETCHCLOSEHANDLEBEGIN


### -field OFFLINEFILES_EVENT_PREFETCHCLOSEHANDLEEND


### -field OFFLINEFILES_NUM_EVENTS




## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefileseventsfilter-getexcludedevents">IOfflineFilesEventsFilter::GetExcludedEvents</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefileseventsfilter-getincludedevents">IOfflineFilesEventsFilter::GetIncludedEvents</a>
 

 

