---
UID: NE:cscobj.tagOFFLINEFILES_SYNC_STATE
title: OFFLINEFILES_SYNC_STATE (cscobj.h)
description: Describes the sync state of an Offline Files item.
old-location: of\offlinefiles_sync_state.htm
tech.root: offlinefiles
ms.assetid: 05d1e03e-2db4-4f1e-8813-98c8cf6d03b6
ms.date: 12/05/2018
ms.keywords: OFFLINEFILES_SYNC_STATE, OFFLINEFILES_SYNC_STATE enumeration [Offline Files], OFFLINEFILES_SYNC_STATE_DeletedOnClient_DirChangedOnServer, OFFLINEFILES_SYNC_STATE_DeletedOnClient_DirOnServer, OFFLINEFILES_SYNC_STATE_DeletedOnClient_FileChangedOnServer, OFFLINEFILES_SYNC_STATE_DeletedOnClient_FileOnServer, OFFLINEFILES_SYNC_STATE_DirChangedOnClient, OFFLINEFILES_SYNC_STATE_DirChangedOnClient_ChangedOnServer, OFFLINEFILES_SYNC_STATE_DirChangedOnClient_DeletedOnServer, OFFLINEFILES_SYNC_STATE_DirChangedOnClient_FileChangedOnServer, OFFLINEFILES_SYNC_STATE_DirChangedOnClient_FileOnServer, OFFLINEFILES_SYNC_STATE_DirChangedOnServer, OFFLINEFILES_SYNC_STATE_DirCreatedOnClient_DeletedOnServer, OFFLINEFILES_SYNC_STATE_DirCreatedOnClient_DirChangedOnServer, OFFLINEFILES_SYNC_STATE_DirCreatedOnClient_DirOnServer, OFFLINEFILES_SYNC_STATE_DirCreatedOnClient_FileChangedOnServer, OFFLINEFILES_SYNC_STATE_DirCreatedOnClient_FileOnServer, OFFLINEFILES_SYNC_STATE_DirCreatedOnClient_NoServerCopy, OFFLINEFILES_SYNC_STATE_DirDeletedOnServer, OFFLINEFILES_SYNC_STATE_DirOnClient_FileChangedOnServer, OFFLINEFILES_SYNC_STATE_DirOnClient_FileOnServer, OFFLINEFILES_SYNC_STATE_DirOnClient_NoServerCopy, OFFLINEFILES_SYNC_STATE_DirRenamedOnClient, OFFLINEFILES_SYNC_STATE_DirRenamedOnServer, OFFLINEFILES_SYNC_STATE_DirSparseOnClient, OFFLINEFILES_SYNC_STATE_FileChangedOnClient, OFFLINEFILES_SYNC_STATE_FileChangedOnClient_ChangedOnServer, OFFLINEFILES_SYNC_STATE_FileChangedOnClient_DeletedOnServer, OFFLINEFILES_SYNC_STATE_FileChangedOnClient_DirChangedOnServer, OFFLINEFILES_SYNC_STATE_FileChangedOnClient_DirOnServer, OFFLINEFILES_SYNC_STATE_FileChangedOnServer, OFFLINEFILES_SYNC_STATE_FileCreatedOnClient_DeletedOnServer, OFFLINEFILES_SYNC_STATE_FileCreatedOnClient_DirChangedOnServer, OFFLINEFILES_SYNC_STATE_FileCreatedOnClient_DirOnServer, OFFLINEFILES_SYNC_STATE_FileCreatedOnClient_FileChangedOnServer, OFFLINEFILES_SYNC_STATE_FileCreatedOnClient_FileOnServer, OFFLINEFILES_SYNC_STATE_FileCreatedOnClient_NoServerCopy, OFFLINEFILES_SYNC_STATE_FileDeletedOnServer, OFFLINEFILES_SYNC_STATE_FileOnClient_DirOnServer, OFFLINEFILES_SYNC_STATE_FileOnClient_NoServerCopy, OFFLINEFILES_SYNC_STATE_FileRenamedOnClient, OFFLINEFILES_SYNC_STATE_FileRenamedOnServer, OFFLINEFILES_SYNC_STATE_FileReplacedAndDeletedOnClient_DirChangedOnServer, OFFLINEFILES_SYNC_STATE_FileReplacedAndDeletedOnClient_DirOnServer, OFFLINEFILES_SYNC_STATE_FileReplacedAndDeletedOnClient_FileChangedOnServer, OFFLINEFILES_SYNC_STATE_FileReplacedAndDeletedOnClient_FileOnServer, OFFLINEFILES_SYNC_STATE_FileSparseOnClient, OFFLINEFILES_SYNC_STATE_FileSparseOnClient_ChangedOnServer, OFFLINEFILES_SYNC_STATE_FileSparseOnClient_DeletedOnServer, OFFLINEFILES_SYNC_STATE_FileSparseOnClient_DirChangedOnServer, OFFLINEFILES_SYNC_STATE_FileSparseOnClient_DirOnServer, OFFLINEFILES_SYNC_STATE_NoClientCopy_DirChangedOnServer, OFFLINEFILES_SYNC_STATE_NoClientCopy_DirOnServer, OFFLINEFILES_SYNC_STATE_NoClientCopy_FileChangedOnServer, OFFLINEFILES_SYNC_STATE_NoClientCopy_FileOnServer, OFFLINEFILES_SYNC_STATE_Stable, cscobj/OFFLINEFILES_SYNC_STATE, cscobj/OFFLINEFILES_SYNC_STATE_DeletedOnClient_DirChangedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_DeletedOnClient_DirOnServer, cscobj/OFFLINEFILES_SYNC_STATE_DeletedOnClient_FileChangedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_DeletedOnClient_FileOnServer, cscobj/OFFLINEFILES_SYNC_STATE_DirChangedOnClient, cscobj/OFFLINEFILES_SYNC_STATE_DirChangedOnClient_ChangedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_DirChangedOnClient_DeletedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_DirChangedOnClient_FileChangedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_DirChangedOnClient_FileOnServer, cscobj/OFFLINEFILES_SYNC_STATE_DirChangedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_DirCreatedOnClient_DeletedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_DirCreatedOnClient_DirChangedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_DirCreatedOnClient_DirOnServer, cscobj/OFFLINEFILES_SYNC_STATE_DirCreatedOnClient_FileChangedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_DirCreatedOnClient_FileOnServer, cscobj/OFFLINEFILES_SYNC_STATE_DirCreatedOnClient_NoServerCopy, cscobj/OFFLINEFILES_SYNC_STATE_DirDeletedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_DirOnClient_FileChangedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_DirOnClient_FileOnServer, cscobj/OFFLINEFILES_SYNC_STATE_DirOnClient_NoServerCopy, cscobj/OFFLINEFILES_SYNC_STATE_DirRenamedOnClient, cscobj/OFFLINEFILES_SYNC_STATE_DirRenamedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_DirSparseOnClient, cscobj/OFFLINEFILES_SYNC_STATE_FileChangedOnClient, cscobj/OFFLINEFILES_SYNC_STATE_FileChangedOnClient_ChangedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_FileChangedOnClient_DeletedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_FileChangedOnClient_DirChangedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_FileChangedOnClient_DirOnServer, cscobj/OFFLINEFILES_SYNC_STATE_FileChangedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_FileCreatedOnClient_DeletedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_FileCreatedOnClient_DirChangedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_FileCreatedOnClient_DirOnServer, cscobj/OFFLINEFILES_SYNC_STATE_FileCreatedOnClient_FileChangedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_FileCreatedOnClient_FileOnServer, cscobj/OFFLINEFILES_SYNC_STATE_FileCreatedOnClient_NoServerCopy, cscobj/OFFLINEFILES_SYNC_STATE_FileDeletedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_FileOnClient_DirOnServer, cscobj/OFFLINEFILES_SYNC_STATE_FileOnClient_NoServerCopy, cscobj/OFFLINEFILES_SYNC_STATE_FileRenamedOnClient, cscobj/OFFLINEFILES_SYNC_STATE_FileRenamedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_FileReplacedAndDeletedOnClient_DirChangedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_FileReplacedAndDeletedOnClient_DirOnServer, cscobj/OFFLINEFILES_SYNC_STATE_FileReplacedAndDeletedOnClient_FileChangedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_FileReplacedAndDeletedOnClient_FileOnServer, cscobj/OFFLINEFILES_SYNC_STATE_FileSparseOnClient, cscobj/OFFLINEFILES_SYNC_STATE_FileSparseOnClient_ChangedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_FileSparseOnClient_DeletedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_FileSparseOnClient_DirChangedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_FileSparseOnClient_DirOnServer, cscobj/OFFLINEFILES_SYNC_STATE_NoClientCopy_DirChangedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_NoClientCopy_DirOnServer, cscobj/OFFLINEFILES_SYNC_STATE_NoClientCopy_FileChangedOnServer, cscobj/OFFLINEFILES_SYNC_STATE_NoClientCopy_FileOnServer, cscobj/OFFLINEFILES_SYNC_STATE_Stable, of.offlinefiles_sync_state
f1_keywords:
- cscobj/OFFLINEFILES_SYNC_STATE
dev_langs:
- c++
req.header: cscobj.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- CscObj.h
api_name:
- OFFLINEFILES_SYNC_STATE
targetos: Windows
req.typenames: OFFLINEFILES_SYNC_STATE
req.redist: 
ms.custom: 19H1
---

# OFFLINEFILES_SYNC_STATE enumeration


## -description


Describes the sync state of an Offline Files item.


## -enum-fields




### -field OFFLINEFILES_SYNC_STATE_Stable

The client and server copies of the file are in sync.


### -field OFFLINEFILES_SYNC_STATE_FileOnClient_DirOnServer

The file exists on the client. The directory exists on the server.


### -field OFFLINEFILES_SYNC_STATE_FileOnClient_NoServerCopy

The file exists only on the client.


### -field OFFLINEFILES_SYNC_STATE_DirOnClient_FileOnServer

The directory exists on the client. The file exists on the server.


### -field OFFLINEFILES_SYNC_STATE_DirOnClient_FileChangedOnServer

The directory exists on the client. The server copy of the file has changed.


### -field OFFLINEFILES_SYNC_STATE_DirOnClient_NoServerCopy

The directory exists only on the client.


### -field OFFLINEFILES_SYNC_STATE_FileCreatedOnClient_NoServerCopy

The file was created on the client. There is no server copy of the file.


### -field OFFLINEFILES_SYNC_STATE_FileCreatedOnClient_FileChangedOnServer

The file was created on the client. The server copy of the file has changed.


### -field OFFLINEFILES_SYNC_STATE_FileCreatedOnClient_DirChangedOnServer

The file was created on the client. The directory on the server has changed.


### -field OFFLINEFILES_SYNC_STATE_FileCreatedOnClient_FileOnServer

The file was created on the client. The server has a file with the same name.


### -field OFFLINEFILES_SYNC_STATE_FileCreatedOnClient_DirOnServer

The file was created on the client. A directory with the same name exists on the server.


### -field OFFLINEFILES_SYNC_STATE_FileCreatedOnClient_DeletedOnServer

The file was created on the client. The server copy of the file was deleted.


### -field OFFLINEFILES_SYNC_STATE_FileChangedOnClient_ChangedOnServer

The client copy of the file has changed. The server copy of the file has changed. This value represents the classic change/change sync conflict.


### -field OFFLINEFILES_SYNC_STATE_FileChangedOnClient_DirOnServer

The client copy of the file has changed. The directory exists on the server.


### -field OFFLINEFILES_SYNC_STATE_FileChangedOnClient_DirChangedOnServer

The client copy of the file has changed. The directory on the server has changed.


### -field OFFLINEFILES_SYNC_STATE_FileChangedOnClient_DeletedOnServer

The client copy of the file has changed. The server copy of the file has been deleted.


### -field OFFLINEFILES_SYNC_STATE_FileSparseOnClient_ChangedOnServer

The file is sparsely cached on the client. The server copy of the file has changed.


### -field OFFLINEFILES_SYNC_STATE_FileSparseOnClient_DeletedOnServer

The file is sparsely cached on the client. The server copy of the file has been deleted.


### -field OFFLINEFILES_SYNC_STATE_FileSparseOnClient_DirOnServer

The file is sparsely cached on the client. The directory exists on the server.


### -field OFFLINEFILES_SYNC_STATE_FileSparseOnClient_DirChangedOnServer

The file is sparsely cached on the client. The directory on the server has changed.


### -field OFFLINEFILES_SYNC_STATE_DirCreatedOnClient_NoServerCopy

The directory has been created on the client. There is no server copy of the directory.


### -field OFFLINEFILES_SYNC_STATE_DirCreatedOnClient_DirOnServer

The directory has been created on the client. A directory with the same name exists on the server.


### -field OFFLINEFILES_SYNC_STATE_DirCreatedOnClient_FileOnServer

The directory has been created on the client. A file with the same name exists on the server.


### -field OFFLINEFILES_SYNC_STATE_DirCreatedOnClient_FileChangedOnServer

The directory has been created on the client. The server copy of the file has changed.


### -field OFFLINEFILES_SYNC_STATE_DirCreatedOnClient_DirChangedOnServer

The directory has been created on the client. The directory on the server has changed.


### -field OFFLINEFILES_SYNC_STATE_DirCreatedOnClient_DeletedOnServer

The directory has been created on the client. The directory on the server has been deleted.


### -field OFFLINEFILES_SYNC_STATE_DirChangedOnClient_FileOnServer

The client directory has changed. The server has a copy of the file.


### -field OFFLINEFILES_SYNC_STATE_DirChangedOnClient_FileChangedOnServer

The client directory has changed. The server copy of the file has been changed.


### -field OFFLINEFILES_SYNC_STATE_DirChangedOnClient_ChangedOnServer

The client directory has changed. The server directory has also changed.


### -field OFFLINEFILES_SYNC_STATE_DirChangedOnClient_DeletedOnServer

The client directory has changed. The directory on the server has been deleted.


### -field OFFLINEFILES_SYNC_STATE_NoClientCopy_FileOnServer

The file exists only on the server.


### -field OFFLINEFILES_SYNC_STATE_NoClientCopy_DirOnServer

The directory exists only on the server.


### -field OFFLINEFILES_SYNC_STATE_NoClientCopy_FileChangedOnServer

The file exists only on the server, and the server copy of the file has changed.


### -field OFFLINEFILES_SYNC_STATE_NoClientCopy_DirChangedOnServer

The directory exists only on the server, and the server directory has changed.


### -field OFFLINEFILES_SYNC_STATE_DeletedOnClient_FileOnServer

The file exists only on the server, because the client copy of the file has been deleted.


### -field OFFLINEFILES_SYNC_STATE_DeletedOnClient_DirOnServer

The directory exists only on the server, because the client directory has been deleted.


### -field OFFLINEFILES_SYNC_STATE_DeletedOnClient_FileChangedOnServer

The client copy of the file has been deleted, and the server copy of the file has changed. This value represents the classic delete/change conflict.


### -field OFFLINEFILES_SYNC_STATE_DeletedOnClient_DirChangedOnServer

The client copy of the directory has been deleted, and the server copy of the directory has changed.


### -field OFFLINEFILES_SYNC_STATE_FileSparseOnClient

The file is sparsely cached on the client.


### -field OFFLINEFILES_SYNC_STATE_FileChangedOnClient

The file has been changed on the client.


### -field OFFLINEFILES_SYNC_STATE_FileRenamedOnClient

This value is reserved for future use.


### -field OFFLINEFILES_SYNC_STATE_DirSparseOnClient

The directory is sparsely cached on the client.


### -field OFFLINEFILES_SYNC_STATE_DirChangedOnClient

The directory has been changed on the client.


### -field OFFLINEFILES_SYNC_STATE_DirRenamedOnClient

This value is reserved for future use.


### -field OFFLINEFILES_SYNC_STATE_FileChangedOnServer

The server copy of the file has been changed.


### -field OFFLINEFILES_SYNC_STATE_FileRenamedOnServer

This value is reserved for future use.


### -field OFFLINEFILES_SYNC_STATE_FileDeletedOnServer

The server copy of the file has been deleted.


### -field OFFLINEFILES_SYNC_STATE_DirChangedOnServer

The server directory has been changed.


### -field OFFLINEFILES_SYNC_STATE_DirRenamedOnServer

This value is reserved for future use.


### -field OFFLINEFILES_SYNC_STATE_DirDeletedOnServer

The server directory has been deleted.


### -field OFFLINEFILES_SYNC_STATE_FileReplacedAndDeletedOnClient_FileOnServer

The file has been replaced and deleted on the client. The server has a copy of the file.


### -field OFFLINEFILES_SYNC_STATE_FileReplacedAndDeletedOnClient_FileChangedOnServer

The file has been replaced and deleted on the client. The server copy of the file has changed.


### -field OFFLINEFILES_SYNC_STATE_FileReplacedAndDeletedOnClient_DirOnServer

The file has been replaced and deleted on the client. The directory exists on the server.


### -field OFFLINEFILES_SYNC_STATE_FileReplacedAndDeletedOnClient_DirChangedOnServer

The file has been replaced and deleted on the client. The directory has changed on the server.


### -field OFFLINEFILES_SYNC_STATE_NUMSTATES




## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/cscobj/nf-cscobj-iofflinefilessyncconflicthandler-resolveconflict">IOfflineFilesSyncConflictHandler::ResolveConflict</a>



<a href="https://docs.microsoft.com/windows/desktop/api/cscobj/ne-cscobj-offlinefiles_sync_conflict_resolve">OFFLINEFILES_SYNC_CONFLICT_RESOLVE</a>
 

 

