---
UID: NE:ctfutb.__MIDL___MIDL_itf_ctfutb_0000_0010_0001
title: TfLBIClick (ctfutb.h)
description: Elements of the TfLBIClick enumeration specify which mouse button was used to click a toolbar item.
old-location: tsf\tflbiclick.htm
tech.root: TSF
ms.assetid: 7fd151dd-e4be-4ec8-b373-2115717d5ef4
ms.date: 12/05/2018
ms.keywords: TF_LBI_CLK_LEFT, TF_LBI_CLK_RIGHT, TfLBIClick, TfLBIClick enumeration [Text Services Framework], _tsf_tflbiclick_ref, ctfutb/TF_LBI_CLK_LEFT, ctfutb/TF_LBI_CLK_RIGHT, ctfutb/TfLBIClick, tsf.tflbiclick
f1_keywords:
- ctfutb/TfLBIClick
dev_langs:
- c++
req.header: ctfutb.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Ctfutb.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Ctfutb.h
api_name:
- TfLBIClick
targetos: Windows
req.typenames: TfLBIClick
req.redist: TSF 1.0 on Windows 2000 Professional
ms.custom: 19H1
---

# TfLBIClick enumeration


## -description


Elements of the <b>TfLBIClick</b> enumeration specify which mouse button was used to click a toolbar item.


## -enum-fields




### -field TF_LBI_CLK_RIGHT

The user right-clicked the button.


### -field TF_LBI_CLK_LEFT

The user left-clicked the button.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/ctfutb/nf-ctfutb-itflangbaritemballoon-onclick">ITfLangBarItemBalloon::OnClick
      </a>



<a href="https://docs.microsoft.com/windows/desktop/api/ctfutb/nf-ctfutb-itflangbaritembitmap-onclick">ITfLangBarItemBitmap::OnClick
      </a>



<a href="https://docs.microsoft.com/windows/desktop/api/ctfutb/nf-ctfutb-itflangbaritembitmapbutton-onclick">ITfLangBarItemBitmapButton::OnClick
      </a>



<a href="https://docs.microsoft.com/windows/desktop/api/ctfutb/nf-ctfutb-itflangbaritembutton-onclick">ITfLangBarItemButton::OnClick
      </a>
 

 

