---
UID: NS:d2d1.D2D1_ELLIPSE
title: D2D1_ELLIPSE (d2d1.h)
description: Contains the center point, x-radius, and y-radius of an ellipse.
old-location: direct2d\D2D1_ELLIPSE.htm
tech.root: Direct2D
ms.assetid: 6fed6c49-ba83-4c2b-af8a-04156ee317f0
ms.date: 12/05/2018
ms.keywords: D2D1_ELLIPSE, D2D1_ELLIPSE structure [Direct2D], d2d1/D2D1_ELLIPSE, direct2d.D2D1_ELLIPSE
f1_keywords:
- d2d1/D2D1_ELLIPSE
dev_langs:
- c++
req.header: d2d1.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7, Windows Vista with SP2 and Platform Update for Windows Vista [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2008 R2, Windows Server 2008 with SP2 and Platform Update for Windows Server 2008 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- d2d1.h
api_name:
- D2D1_ELLIPSE
targetos: Windows
req.typenames: D2D1_ELLIPSE
req.redist: 
ms.custom: 19H1
---

# D2D1_ELLIPSE structure


## -description


Contains the center point, x-radius, and y-radius of an ellipse.


## -struct-fields




### -field point

Type: <b><a href="https://docs.microsoft.com/windows/desktop/Direct2D/d2d1-point-2f">D2D1_POINT_2F</a></b>

The center point of the ellipse.


### -field radiusX

Type: <b>FLOAT</b>

The X-radius of the ellipse.


### -field radiusY

Type: <b>FLOAT</b>

The Y-radius of the ellipse.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/Direct2D/how-to-draw-an-ellipse">How to Draw and Fill a Basic Shape</a>
 

 

