---
UID: NS:d2d1.D2D1_FACTORY_OPTIONS
title: D2D1_FACTORY_OPTIONS (d2d1.h)
description: Contains the debugging level of an ID2D1Factory object.
old-location: direct2d\D2D1_FACTORY_OPTIONS.htm
tech.root: Direct2D
ms.assetid: 2765d34e-978c-4121-82c9-2780d54e2850
ms.date: 12/05/2018
ms.keywords: D2D1_FACTORY_OPTIONS, D2D1_FACTORY_OPTIONS structure [Direct2D], d2d1/D2D1_FACTORY_OPTIONS, direct2d.D2D1_FACTORY_OPTIONS
f1_keywords:
- d2d1/D2D1_FACTORY_OPTIONS
dev_langs:
- c++
req.header: d2d1.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7, Windows Vista with SP2 and Platform Update for Windows Vista [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2008 R2, Windows Server 2008 with SP2 and Platform Update for Windows Server 2008 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- d2d1.h
api_name:
- D2D1_FACTORY_OPTIONS
targetos: Windows
req.typenames: D2D1_FACTORY_OPTIONS
req.redist: 
ms.custom: 19H1
---

# D2D1_FACTORY_OPTIONS structure


## -description


Contains the debugging level of an <a href="https://docs.microsoft.com/windows/desktop/api/d2d1/nn-d2d1-id2d1factory">ID2D1Factory</a> object.


## -struct-fields




### -field debugLevel

Type: <b><a href="https://docs.microsoft.com/windows/desktop/api/d2d1/ne-d2d1-d2d1_debug_level">D2D1_DEBUG_LEVEL</a></b>

The debugging level of the <a href="https://docs.microsoft.com/windows/desktop/api/d2d1/nn-d2d1-id2d1factory">ID2D1Factory</a> object.


## -remarks



To enable debugging, you must install the <a href="https://docs.microsoft.com/windows/desktop/Direct2D/direct2ddebuglayer-overview">Direct2D Debug Layer</a>.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/Direct2D/direct2ddebuglayer-overview">Direct2D Debug Layer</a>
 

 

