---
UID: NF:d2d1_1.ID2D1DeviceContext.SetRenderingControls(const D2D1_RENDERING_CONTROLS)
title: ID2D1DeviceContext::SetRenderingControls (d2d1_1.h)
description: Sets the rendering controls for the given device context.
old-location: direct2d\id2d1devicecontext_setrenderingcontrols.htm
tech.root: Direct2D
ms.assetid: 6a066126-89d0-4372-bc01-6b6fa1d65440
ms.date: 12/05/2018
ms.keywords: ID2D1DeviceContext interface [Direct2D],SetRenderingControls method, ID2D1DeviceContext.SetRenderingControls, ID2D1DeviceContext::SetRenderingControls, SetRenderingControls, SetRenderingControls method [Direct2D], SetRenderingControls method [Direct2D],ID2D1DeviceContext interface, d2d1_1/ID2D1DeviceContext::SetRenderingControls, direct2d.id2d1devicecontext_setrenderingcontrols
f1_keywords:
- d2d1_1/ID2D1DeviceContext.SetRenderingControls
dev_langs:
- c++
req.header: d2d1_1.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 and Platform Update for Windows 7 [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2012 and Platform Update for Windows Server 2008 R2 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: D2d1.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- D2d1.dll
api_name:
- ID2D1DeviceContext.SetRenderingControls
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# ID2D1DeviceContext::SetRenderingControls


## -description


Sets the rendering controls for the given device context. 


## -parameters




### -param renderingControls [in]

Type: <b>const <a href="https://docs.microsoft.com/windows/desktop/api/d2d1_1/ns-d2d1_1-d2d1_rendering_controls">D2D1_RENDERING_CONTROLS</a>*</b>

The rendering controls to be applied.


## -returns



This method does not return a value.




## -remarks



The rendering controls allow the  application to tune the precision, performance, and resource usage of rendering operations.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/d2d1_1/ns-d2d1_1-d2d1_rendering_controls">D2D1_RENDERING_CONTROLS</a>



<a href="https://docs.microsoft.com/windows/desktop/api/d2d1_1/nn-d2d1_1-id2d1devicecontext">ID2D1DeviceContext</a>
 

 

