---
UID: NN:d2d1_1.ID2D1ColorContext
title: ID2D1ColorContext (d2d1_1.h)
description: Represents a color context that can be used with an ID2D1Bitmap1 object.
old-location: direct2d\id2d1colorcontext.htm
tech.root: Direct2D
ms.assetid: acdda11e-eb3f-4258-b24e-daa3b7a23fd6
ms.date: 12/05/2018
ms.keywords: ID2D1ColorContext, ID2D1ColorContext interface [Direct2D], ID2D1ColorContext interface [Direct2D],described, d2d1_1/ID2D1ColorContext, direct2d.id2d1colorcontext
f1_keywords:
- d2d1_1/ID2D1ColorContext
dev_langs:
- c++
req.header: d2d1_1.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 and Platform Update for Windows 7 [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2012 and Platform Update for Windows Server 2008 R2 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: D2d1.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- D2d1.dll
api_name:
- ID2D1ColorContext
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# ID2D1ColorContext interface


## -description


Represents a color context that can be used with an <a href="https://docs.microsoft.com/windows/desktop/api/d2d1_1/nn-d2d1_1-id2d1bitmap1">ID2D1Bitmap1</a> object.


## -inheritance

The <b xmlns:loc="http://microsoft.com/wdcml/l10n">ID2D1ColorContext</b> interface inherits from <a href="https://docs.microsoft.com/windows/desktop/api/d2d1/nn-d2d1-id2d1resource">ID2D1Resource</a>. <b>ID2D1ColorContext</b> also has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul>

## -members

The <b>ID2D1ColorContext</b> interface has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/d2d1_1/nf-d2d1_1-id2d1colorcontext-getcolorspace">GetColorSpace</a>
</td>
<td align="left" width="63%">
Gets the color space  of the color context.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/d2d1_1/nf-d2d1_1-id2d1colorcontext-getprofile">GetProfile</a>
</td>
<td align="left" width="63%">
Gets the color profile bytes for an <b>ID2D1ColorContext</b>. 

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/d2d1_1/nf-d2d1_1-id2d1colorcontext-getprofilesize">GetProfileSize</a>
</td>
<td align="left" width="63%">
Gets the size of the color profile associated with the bitmap. 	

</td>
</tr>
</table> 


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/d2d1_1/nn-d2d1_1-id2d1bitmap1">ID2D1Bitmap1</a>



<a href="https://docs.microsoft.com/windows/desktop/api/d2d1/nn-d2d1-id2d1resource">ID2D1Resource</a>
 

 

