---
UID: NF:d2d1helper.Matrix3x2F.ReinterpretBaseType(D2D1_MATRIX_3X2_F)
title: Matrix3x2F::ReinterpretBaseType(D2D1_MATRIX_3X2_F) (d2d1helper.h)
description: Converts the specified D2D1_MATRIX_3X2_F matrix to a Matrix3x2F without making a copy.
old-location: direct2d\matrix3x2f_reinterpretbasetype_d2d1_matrix_3x2_f_.htm
tech.root: Direct2D
ms.assetid: b78e2d9a-c5a8-4c2b-9e45-c1e95ff3be06
ms.date: 12/05/2018
ms.keywords: D2D1.Matrix3x2F.ReinterpretBaseType, D2D1::Matrix3x2F::ReinterpretBaseType, Matrix3x2F interface [Direct2D],ReinterpretBaseType method, Matrix3x2F.ReinterpretBaseType, Matrix3x2F.ReinterpretBaseType(D2D1_MATRIX_3X2_F), Matrix3x2F::ReinterpretBaseType, Matrix3x2F::ReinterpretBaseType(D2D1_MATRIX_3X2_F), Matrix3x2F::ReinterpretBaseType(D2D1_MATRIX_3X2_F*), ReinterpretBaseType, ReinterpretBaseType method [Direct2D], ReinterpretBaseType method [Direct2D],Matrix3x2F interface, d2d1helper/Matrix3x2F::ReinterpretBaseType, direct2d.matrix3x2f_reinterpretbasetype_d2d1_matrix_3x2_f_
f1_keywords:
- d2d1helper/Matrix3x2F.ReinterpretBaseType
dev_langs:
- c++
req.header: d2d1helper.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7, Windows Vista with SP2 and Platform Update for Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2, Windows Server 2008 with SP2 and Platform Update for Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: D2D1
req.assembly: 
req.type-library: 
req.lib: D2d1.lib
req.dll: D2d1.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- D2d1.dll
api_name:
- Matrix3x2F.ReinterpretBaseType
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# Matrix3x2F::ReinterpretBaseType(D2D1_MATRIX_3X2_F)


## -description


Converts the specified <a href="https://docs.microsoft.com/windows/desktop/Direct2D/d2d1-matrix-3x2-f">D2D1_MATRIX_3X2_F</a> matrix to a <a href="https://docs.microsoft.com/windows/desktop/api/d2d1helper/nl-d2d1helper-matrix3x2f">Matrix3x2F</a> without making a copy.


## -parameters




### -param pMatrix

Type: <b><a href="https://docs.microsoft.com/windows/desktop/Direct2D/d2d1-matrix-3x2-f">D2D1_MATRIX_3X2_F</a>*</b>

The matrix to convert.


## -returns



Type: <b><a href="https://docs.microsoft.com/windows/desktop/api/d2d1helper/nl-d2d1helper-matrix3x2f">Matrix3x2F</a>*</b>

The converted matrix.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/d2d1helper/nl-d2d1helper-matrix3x2f">Matrix3x2F</a>
 

 

