---
UID: NE:d3d10.D3D10_COUNTER
title: D3D10_COUNTER (d3d10.h)
description: Performance counter types.
old-location: direct3d10\d3d10_counter.htm
tech.root: direct3d10
ms.assetid: VS|directx_sdk|~\d3d10_counter.htm
ms.date: 12/05/2018
ms.keywords: 2adb613c-1c3a-59ec-1bc9-5a9d3d5c9a28, D3D10_COUNTER, D3D10_COUNTER enumeration [Direct3D 10], D3D10_COUNTER_DEVICE_DEPENDENT_0, D3D10_COUNTER_FILLRATE_THROUGHPUT_UTILIZATION, D3D10_COUNTER_GEOMETRY_PROCESSING, D3D10_COUNTER_GPU_IDLE, D3D10_COUNTER_GS_COMPUTATION_LIMITED, D3D10_COUNTER_GS_MEMORY_LIMITED, D3D10_COUNTER_HOST_ADAPTER_BANDWIDTH_UTILIZATION, D3D10_COUNTER_LOCAL_VIDMEM_BANDWIDTH_UTILIZATION, D3D10_COUNTER_OTHER_GPU_PROCESSING, D3D10_COUNTER_PIXEL_PROCESSING, D3D10_COUNTER_POST_TRANSFORM_CACHE_HIT_RATE, D3D10_COUNTER_PS_COMPUTATION_LIMITED, D3D10_COUNTER_PS_MEMORY_LIMITED, D3D10_COUNTER_TEXTURE_CACHE_HIT_RATE, D3D10_COUNTER_TRIANGLE_SETUP_THROUGHPUT_UTILIZATION, D3D10_COUNTER_VERTEX_PROCESSING, D3D10_COUNTER_VERTEX_THROUGHPUT_UTILIZATION, D3D10_COUNTER_VS_COMPUTATION_LIMITED, D3D10_COUNTER_VS_MEMORY_LIMITED, d3d10/D3D10_COUNTER, d3d10/D3D10_COUNTER_DEVICE_DEPENDENT_0, d3d10/D3D10_COUNTER_FILLRATE_THROUGHPUT_UTILIZATION, d3d10/D3D10_COUNTER_GEOMETRY_PROCESSING, d3d10/D3D10_COUNTER_GPU_IDLE, d3d10/D3D10_COUNTER_GS_COMPUTATION_LIMITED, d3d10/D3D10_COUNTER_GS_MEMORY_LIMITED, d3d10/D3D10_COUNTER_HOST_ADAPTER_BANDWIDTH_UTILIZATION, d3d10/D3D10_COUNTER_LOCAL_VIDMEM_BANDWIDTH_UTILIZATION, d3d10/D3D10_COUNTER_OTHER_GPU_PROCESSING, d3d10/D3D10_COUNTER_PIXEL_PROCESSING, d3d10/D3D10_COUNTER_POST_TRANSFORM_CACHE_HIT_RATE, d3d10/D3D10_COUNTER_PS_COMPUTATION_LIMITED, d3d10/D3D10_COUNTER_PS_MEMORY_LIMITED, d3d10/D3D10_COUNTER_TEXTURE_CACHE_HIT_RATE, d3d10/D3D10_COUNTER_TRIANGLE_SETUP_THROUGHPUT_UTILIZATION, d3d10/D3D10_COUNTER_VERTEX_PROCESSING, d3d10/D3D10_COUNTER_VERTEX_THROUGHPUT_UTILIZATION, d3d10/D3D10_COUNTER_VS_COMPUTATION_LIMITED, d3d10/D3D10_COUNTER_VS_MEMORY_LIMITED, direct3d10.d3d10_counter
f1_keywords:
- d3d10/D3D10_COUNTER
dev_langs:
- c++
req.header: d3d10.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- D3D10.h
api_name:
- D3D10_COUNTER
targetos: Windows
req.typenames: D3D10_COUNTER
req.redist: 
ms.custom: 19H1
---

# D3D10_COUNTER enumeration


## -description


Performance counter types.


## -enum-fields




### -field D3D10_COUNTER_GPU_IDLE

Percentage of the time that the GPU is idle.


### -field D3D10_COUNTER_VERTEX_PROCESSING

Percentage of the time that the GPU does vertex processing.


### -field D3D10_COUNTER_GEOMETRY_PROCESSING

Percentage of the time that the GPU does geometry processing.


### -field D3D10_COUNTER_PIXEL_PROCESSING

Percentage of the time that the GPU does pixel processing.


### -field D3D10_COUNTER_OTHER_GPU_PROCESSING

Percentage of the time that the GPU does other processing (not vertex, geometry, or pixel processing).


### -field D3D10_COUNTER_HOST_ADAPTER_BANDWIDTH_UTILIZATION

Percentage of bandwidth used on a host adapter. Value returned by <a href="https://docs.microsoft.com/windows/desktop/api/d3d10/nf-d3d10-id3d10asynchronous-getdata">ID3D10Asynchronous::GetData</a> between 0.0 and 1.0 when using this counter.


### -field D3D10_COUNTER_LOCAL_VIDMEM_BANDWIDTH_UTILIZATION

Percentage of bandwidth used by the local video memory. Value returned by <a href="https://docs.microsoft.com/windows/desktop/api/d3d10/nf-d3d10-id3d10asynchronous-getdata">ID3D10Asynchronous::GetData</a> between 0.0 and 1.0 when using this counter


### -field D3D10_COUNTER_VERTEX_THROUGHPUT_UTILIZATION

Percentage of throughput used for vertices. Value returned by <a href="https://docs.microsoft.com/windows/desktop/api/d3d10/nf-d3d10-id3d10asynchronous-getdata">ID3D10Asynchronous::GetData</a> between 0.0 and 1.0 when using this counter


### -field D3D10_COUNTER_TRIANGLE_SETUP_THROUGHPUT_UTILIZATION

Percentage of throughput used for triangle setup. Value returned by <a href="https://docs.microsoft.com/windows/desktop/api/d3d10/nf-d3d10-id3d10asynchronous-getdata">ID3D10Asynchronous::GetData</a> between 0.0 and 1.0 when using this counter


### -field D3D10_COUNTER_FILLRATE_THROUGHPUT_UTILIZATION

Percentage of throughput used for the fillrate. Value returned by <a href="https://docs.microsoft.com/windows/desktop/api/d3d10/nf-d3d10-id3d10asynchronous-getdata">ID3D10Asynchronous::GetData</a> between 0.0 and 1.0 when using this counter.


### -field D3D10_COUNTER_VS_MEMORY_LIMITED

Percentage of time that a vertex shader spends sampling resources.


### -field D3D10_COUNTER_VS_COMPUTATION_LIMITED

Percentage of time that a vertex shader spends doing computations.


### -field D3D10_COUNTER_GS_MEMORY_LIMITED

Percentage of time that a geometry shader spends sampling resources.


### -field D3D10_COUNTER_GS_COMPUTATION_LIMITED

Percentage of time that a geometry shader spends doing computations.


### -field D3D10_COUNTER_PS_MEMORY_LIMITED

Percentage of time that a pixel shader spends sampling resources.


### -field D3D10_COUNTER_PS_COMPUTATION_LIMITED

Percentage of time that a pixel shader spends doing computations.


### -field D3D10_COUNTER_POST_TRANSFORM_CACHE_HIT_RATE

Percentage of vertex data that was read from the vertex cache. For example, if 6 vertices were added to the cache and 3 of them were read from the cache, then the hit rate would be 0.5.


### -field D3D10_COUNTER_TEXTURE_CACHE_HIT_RATE

Percentage of texel data that was read from the vertex cache. For example, if 6 texels were added to the cache and 3 of them were read from the cache, then the hit rate would be 0.5.


### -field D3D10_COUNTER_DEVICE_DEPENDENT_0

Start of the device-dependent counters. See remarks.


## -remarks



In addition to these performance counters, independent hardware vendors may define their own set of performance counters for their devices. The enum values for these counters would start after D3D10_COUNTER_DEVICE_DEPENDENT_0 and would be defined by those hardware vendors.

A device can support one or more of these performance counters, but it is not required to support any of them.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d10/d3d10-graphics-reference-d3d10-core-enums">Core Enumerations</a>
 

 

