---
UID: NE:d3d10effect._D3D10_DEVICE_STATE_TYPES
title: D3D10_DEVICE_STATE_TYPES (d3d10effect.h)
description: Effect device-state types.
old-location: direct3d10\d3d10_device_state_types.htm
tech.root: direct3d10
ms.assetid: VS|directx_sdk|~\d3d10_device_state_types.htm
ms.date: 12/05/2018
ms.keywords: D3D10_DEVICE_STATE_TYPES, D3D10_DEVICE_STATE_TYPES enumeration [Direct3D 10], D3D10_DST_GS, D3D10_DST_GS_CONSTANT_BUFFERS, D3D10_DST_GS_SAMPLERS, D3D10_DST_GS_SHADER_RESOURCES, D3D10_DST_IA_INDEX_BUFFER, D3D10_DST_IA_INPUT_LAYOUT, D3D10_DST_IA_PRIMITIVE_TOPOLOGY, D3D10_DST_IA_VERTEX_BUFFERS, D3D10_DST_OM_BLEND_STATE, D3D10_DST_OM_DEPTH_STENCIL_STATE, D3D10_DST_OM_RENDER_TARGETS, D3D10_DST_PREDICATION, D3D10_DST_PS, D3D10_DST_PS_CONSTANT_BUFFERS, D3D10_DST_PS_SAMPLERS, D3D10_DST_PS_SHADER_RESOURCES, D3D10_DST_RS_RASTERIZER_STATE, D3D10_DST_RS_SCISSOR_RECTS, D3D10_DST_RS_VIEWPORTS, D3D10_DST_SO_BUFFERS, D3D10_DST_VS, D3D10_DST_VS_CONSTANT_BUFFERS, D3D10_DST_VS_SAMPLERS, D3D10_DST_VS_SHADER_RESOURCES, c62471d5-c132-390b-67ea-4e1491105ee0, d3d10effect/D3D10_DEVICE_STATE_TYPES, d3d10effect/D3D10_DST_GS, d3d10effect/D3D10_DST_GS_CONSTANT_BUFFERS, d3d10effect/D3D10_DST_GS_SAMPLERS, d3d10effect/D3D10_DST_GS_SHADER_RESOURCES, d3d10effect/D3D10_DST_IA_INDEX_BUFFER, d3d10effect/D3D10_DST_IA_INPUT_LAYOUT, d3d10effect/D3D10_DST_IA_PRIMITIVE_TOPOLOGY, d3d10effect/D3D10_DST_IA_VERTEX_BUFFERS, d3d10effect/D3D10_DST_OM_BLEND_STATE, d3d10effect/D3D10_DST_OM_DEPTH_STENCIL_STATE, d3d10effect/D3D10_DST_OM_RENDER_TARGETS, d3d10effect/D3D10_DST_PREDICATION, d3d10effect/D3D10_DST_PS, d3d10effect/D3D10_DST_PS_CONSTANT_BUFFERS, d3d10effect/D3D10_DST_PS_SAMPLERS, d3d10effect/D3D10_DST_PS_SHADER_RESOURCES, d3d10effect/D3D10_DST_RS_RASTERIZER_STATE, d3d10effect/D3D10_DST_RS_SCISSOR_RECTS, d3d10effect/D3D10_DST_RS_VIEWPORTS, d3d10effect/D3D10_DST_SO_BUFFERS, d3d10effect/D3D10_DST_VS, d3d10effect/D3D10_DST_VS_CONSTANT_BUFFERS, d3d10effect/D3D10_DST_VS_SAMPLERS, d3d10effect/D3D10_DST_VS_SHADER_RESOURCES, direct3d10.d3d10_device_state_types
f1_keywords:
- d3d10effect/D3D10_DEVICE_STATE_TYPES
dev_langs:
- c++
req.header: d3d10effect.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- D3D10Effect.h
api_name:
- D3D10_DEVICE_STATE_TYPES
targetos: Windows
req.typenames: D3D10_DEVICE_STATE_TYPES
req.redist: 
ms.custom: 19H1
---

# D3D10_DEVICE_STATE_TYPES enumeration


## -description


Effect device-state types.


## -enum-fields




### -field D3D10_DST_SO_BUFFERS

Stream-output buffer.


### -field D3D10_DST_OM_RENDER_TARGETS

Render target.


### -field D3D10_DST_OM_DEPTH_STENCIL_STATE

Depth-stencil state.


### -field D3D10_DST_OM_BLEND_STATE

Blend state.


### -field D3D10_DST_VS

Vertex shader.


### -field D3D10_DST_VS_SAMPLERS

Vertex shader sampler.


### -field D3D10_DST_VS_SHADER_RESOURCES

Vertex shader resource.


### -field D3D10_DST_VS_CONSTANT_BUFFERS

Vertex shader constant buffer.


### -field D3D10_DST_GS

Geometry shader.


### -field D3D10_DST_GS_SAMPLERS

Geometry shader sampler.


### -field D3D10_DST_GS_SHADER_RESOURCES

Geometry shader resource.


### -field D3D10_DST_GS_CONSTANT_BUFFERS

Geometry shader constant buffer.


### -field D3D10_DST_PS

Pixel shader.


### -field D3D10_DST_PS_SAMPLERS

Pixel shader sampler.


### -field D3D10_DST_PS_SHADER_RESOURCES

Pixel shader resource.


### -field D3D10_DST_PS_CONSTANT_BUFFERS

Pixel shader constant buffer.


### -field D3D10_DST_IA_VERTEX_BUFFERS

Input-assembler vertex buffer.


### -field D3D10_DST_IA_INDEX_BUFFER

Input-assembler index buffer.


### -field D3D10_DST_IA_INPUT_LAYOUT

Input-assembler input layout.


### -field D3D10_DST_IA_PRIMITIVE_TOPOLOGY

Input-assembler primitive topology.


### -field D3D10_DST_RS_VIEWPORTS

Viewport.


### -field D3D10_DST_RS_SCISSOR_RECTS

Scissor rectangle.


### -field D3D10_DST_RS_RASTERIZER_STATE

Rasterizer state.


### -field D3D10_DST_PREDICATION

Predication state.


## -remarks



This enumeration is used by <a href="https://docs.microsoft.com/windows/desktop/api/d3d10effect/nf-d3d10effect-d3d10stateblockmaskdisablecapture">D3D10StateBlockMaskDisableCapture</a>, <a href="https://docs.microsoft.com/windows/desktop/api/d3d10effect/nf-d3d10effect-d3d10stateblockmaskenablecapture">D3D10StateBlockMaskEnableCapture</a>, and <a href="https://docs.microsoft.com/windows/desktop/api/d3d10effect/nf-d3d10effect-d3d10stateblockmaskgetsetting">D3D10StateBlockMaskGetSetting</a>.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d10/d3d10-graphics-reference-d3d10-core-enums">Core Enumerations</a>
 

 

