---
UID: NF:d3d10effect.D3D10StateBlockMaskDisableAll
title: D3D10StateBlockMaskDisableAll function (d3d10effect.h)
description: Disable all state capturing with a state-block mask.
old-location: direct3d10\d3d10stateblockmaskdisableall.htm
tech.root: direct3d10
ms.assetid: VS|directx_sdk|~\d3d10stateblockmaskdisableall.htm
ms.date: 12/05/2018
ms.keywords: D3D10StateBlockMaskDisableAll, D3D10StateBlockMaskDisableAll function [Direct3D 10], c2d0b2ea-1ff1-14e9-f16f-1c7623539483, d3d10effect/D3D10StateBlockMaskDisableAll, direct3d10.d3d10stateblockmaskdisableall
f1_keywords:
- d3d10effect/D3D10StateBlockMaskDisableAll
dev_langs:
- c++
req.header: d3d10effect.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: D3D10.lib
req.dll: D3D10.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- D3D10.dll
api_name:
- D3D10StateBlockMaskDisableAll
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# D3D10StateBlockMaskDisableAll function


## -description


Disable all state capturing with a state-block mask.


## -parameters




### -param pMask [out]

Type: <b><a href="https://docs.microsoft.com/windows/desktop/api/d3d10effect/ns-d3d10effect-d3d10_state_block_mask">D3D10_STATE_BLOCK_MASK</a>*</b>

A mask filled with all zeroes (see <a href="https://docs.microsoft.com/windows/desktop/api/d3d10effect/ns-d3d10effect-d3d10_state_block_mask">D3D10_STATE_BLOCK_MASK</a>).


## -returns



Type: <b><a href="/windows/win32/com/structure-of-com-error-codes">HRESULT</a></b>

This method returns one of the following <a href="https://docs.microsoft.com/windows/desktop/direct3d10/d3d10-graphics-reference-returnvalues">Direct3D 10 Return Codes</a>.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d10/d3d10-graphics-reference-d3d10-core-functions">Core Functions</a>



<a href="https://docs.microsoft.com/windows/desktop/direct3d10/d3d10-graphics-reference-effect-functions">Effect Functions</a>
 

 

