---
UID: NF:d3d10shader.D3D10GetShaderDebugInfo
title: D3D10GetShaderDebugInfo function (d3d10shader.h)
description: Get shader debug info. Debug info is generated by D3D10CompileShader and is embedded in the body of the shader.
old-location: direct3d10\d3d10getshaderdebuginfo.htm
tech.root: direct3d10
ms.assetid: VS|directx_sdk|~\d3d10getshaderdebuginfo.htm
ms.date: 12/05/2018
ms.keywords: 8d9f638d-18e5-edcf-f803-bb2b87bf911a, D3D10GetShaderDebugInfo, D3D10GetShaderDebugInfo function [Direct3D 10], d3d10shader/D3D10GetShaderDebugInfo, direct3d10.d3d10getshaderdebuginfo
f1_keywords:
- d3d10shader/D3D10GetShaderDebugInfo
dev_langs:
- c++
req.header: d3d10shader.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: D3D10.lib
req.dll: D3D10.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- D3D10.dll
api_name:
- D3D10GetShaderDebugInfo
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# D3D10GetShaderDebugInfo function


## -description


Get shader debug info. Debug info is generated by <a href="https://docs.microsoft.com/windows/desktop/api/d3d10shader/nf-d3d10shader-d3d10compileshader">D3D10CompileShader</a> and is embedded in the body of the shader.


## -parameters




### -param pShaderBytecode

Type: <b>const void*</b>

A pointer to the compiled shader. To get this pointer see <a href="https://docs.microsoft.com/windows/desktop/direct3dhlsl/dx-graphics-hlsl-using-shaders-10">Getting a Pointer to a Compiled Shader</a>.


### -param BytecodeLength

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">SIZE_T</a></b>

Length of the shader bytecode buffer.


### -param ppDebugInfo

Type: <b><a href="https://docs.microsoft.com/windows/desktop/api/d3dcommon/nn-d3dcommon-id3d10blob">ID3D10Blob</a>**</b>

Pointer to an <a href="https://docs.microsoft.com/windows/win32/api/d3d10_1shader/ns-d3d10_1shader-d3d10_shader_debug_info">ID3D10Blob Interface</a> used to return debug info.  For information about the layout of this buffer, see <a href="https://docs.microsoft.com/windows/desktop/api/d3d10_1shader/ns-d3d10_1shader-d3d10_shader_debug_info">D3D10_SHADER_DEBUG_INFO</a>.


## -returns



Type: <b><a href="/windows/win32/com/structure-of-com-error-codes">HRESULT</a></b>

Returns one of the following <a href="https://docs.microsoft.com/windows/desktop/direct3d10/d3d10-graphics-reference-returnvalues">Direct3D 10 Return Codes</a>.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d10/d3d10-graphics-reference-d3d10-shader-functions">Shader Functions</a>
 

 

