---
UID: NE:d3d11.D3D11_BUFFEREX_SRV_FLAG
title: D3D11_BUFFEREX_SRV_FLAG (d3d11.h)
description: Identifies how to view a buffer resource.
old-location: direct3d11\d3d11_bufferex_srv_flag.htm
tech.root: direct3d11
ms.assetid: 11ded487-af4a-4357-b781-bd6b0f3c5a75
ms.date: 12/05/2018
ms.keywords: 966a7d54-75bc-7a4e-7188-3703ad332b5b, D3D11_BUFFEREX_SRV_FLAG, D3D11_BUFFEREX_SRV_FLAG enumeration [Direct3D 11], D3D11_BUFFEREX_SRV_FLAG_RAW, d3d11/D3D11_BUFFEREX_SRV_FLAG, d3d11/D3D11_BUFFEREX_SRV_FLAG_RAW, direct3d11.d3d11_bufferex_srv_flag
f1_keywords:
- d3d11/D3D11_BUFFEREX_SRV_FLAG
dev_langs:
- c++
req.header: d3d11.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- D3D11.h
api_name:
- D3D11_BUFFEREX_SRV_FLAG
targetos: Windows
req.typenames: D3D11_BUFFEREX_SRV_FLAG
req.redist: 
ms.custom: 19H1
---

# D3D11_BUFFEREX_SRV_FLAG enumeration


## -description


Identifies how to view a buffer resource.


## -enum-fields




### -field D3D11_BUFFEREX_SRV_FLAG_RAW

View the buffer as raw. For more info about raw viewing of buffers, see <a href="https://docs.microsoft.com/windows/desktop/direct3d11/overviews-direct3d-11-resources-intro">Raw Views of Buffers</a>.


## -remarks



This enumeration is used by <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_bufferex_srv">D3D11_BUFFEREX_SRV</a>





## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d11/d3d11-graphics-reference-resource-enums">Resource Enumerations</a>
 

 

