---
UID: NE:d3d11.D3D11_CONSERVATIVE_RASTERIZATION_TIER
title: D3D11_CONSERVATIVE_RASTERIZATION_TIER (d3d11.h)
description: Specifies if the hardware and driver support conservative rasterization and at what tier level.
old-location: direct3d11\d3d11_conservative_rasterization_tier.htm
tech.root: direct3d11
ms.assetid: 1409ACE8-960C-4297-80D9-DAD3CD1886AD
ms.date: 12/05/2018
ms.keywords: D3D11_CONSERVATIVE_RASTERIZATION_NOT_SUPPORTED, D3D11_CONSERVATIVE_RASTERIZATION_TIER, D3D11_CONSERVATIVE_RASTERIZATION_TIER enumeration [Direct3D 11], D3D11_CONSERVATIVE_RASTERIZATION_TIER_1, D3D11_CONSERVATIVE_RASTERIZATION_TIER_2, D3D11_CONSERVATIVE_RASTERIZATION_TIER_3, d3d11/D3D11_CONSERVATIVE_RASTERIZATION_NOT_SUPPORTED, d3d11/D3D11_CONSERVATIVE_RASTERIZATION_TIER, d3d11/D3D11_CONSERVATIVE_RASTERIZATION_TIER_1, d3d11/D3D11_CONSERVATIVE_RASTERIZATION_TIER_2, d3d11/D3D11_CONSERVATIVE_RASTERIZATION_TIER_3, direct3d11.d3d11_conservative_rasterization_tier
f1_keywords:
- d3d11/D3D11_CONSERVATIVE_RASTERIZATION_TIER
dev_langs:
- c++
req.header: d3d11.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 10 [desktop apps only]
req.target-min-winversvr: Windows Server 2016 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- D3D11.h
api_name:
- D3D11_CONSERVATIVE_RASTERIZATION_TIER
targetos: Windows
req.typenames: D3D11_CONSERVATIVE_RASTERIZATION_TIER
req.redist: 
ms.custom: 19H1
---

# D3D11_CONSERVATIVE_RASTERIZATION_TIER enumeration


## -description


Specifies if the hardware and driver support conservative rasterization and at what tier level.


## -enum-fields




### -field D3D11_CONSERVATIVE_RASTERIZATION_NOT_SUPPORTED

Conservative rasterization isn't supported.


### -field D3D11_CONSERVATIVE_RASTERIZATION_TIER_1

Tier_1 conservative rasterization is supported.


### -field D3D11_CONSERVATIVE_RASTERIZATION_TIER_2

Tier_2 conservative rasterization is supported.


### -field D3D11_CONSERVATIVE_RASTERIZATION_TIER_3

Tier_3 conservative rasterization is supported.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d11/d3d11-graphics-reference-d3d11-core-enums">Core Enumerations</a>
 

 

