---
UID: NE:d3d11.D3D11_COUNTER_TYPE
title: D3D11_COUNTER_TYPE (d3d11.h)
description: Data type of a performance counter.
old-location: direct3d11\d3d11_counter_type.htm
tech.root: direct3d11
ms.assetid: c39ecf5c-f4c5-4caf-bcd6-2f1ea924ec64
ms.date: 12/05/2018
ms.keywords: D3D11_COUNTER_TYPE, D3D11_COUNTER_TYPE enumeration [Direct3D 11], D3D11_COUNTER_TYPE_FLOAT32, D3D11_COUNTER_TYPE_UINT16, D3D11_COUNTER_TYPE_UINT32, D3D11_COUNTER_TYPE_UINT64, d3d11/D3D11_COUNTER_TYPE, d3d11/D3D11_COUNTER_TYPE_FLOAT32, d3d11/D3D11_COUNTER_TYPE_UINT16, d3d11/D3D11_COUNTER_TYPE_UINT32, d3d11/D3D11_COUNTER_TYPE_UINT64, direct3d11.d3d11_counter_type, e65eb816-2056-25d0-88d3-3d082588c48d
f1_keywords:
- d3d11/D3D11_COUNTER_TYPE
dev_langs:
- c++
req.header: d3d11.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- D3D11.h
api_name:
- D3D11_COUNTER_TYPE
targetos: Windows
req.typenames: D3D11_COUNTER_TYPE
req.redist: 
ms.custom: 19H1
---

# D3D11_COUNTER_TYPE enumeration


## -description


Data type of a performance counter.


## -enum-fields




### -field D3D11_COUNTER_TYPE_FLOAT32

32-bit floating point.


### -field D3D11_COUNTER_TYPE_UINT16

16-bit unsigned integer.


### -field D3D11_COUNTER_TYPE_UINT32

32-bit unsigned integer.


### -field D3D11_COUNTER_TYPE_UINT64

64-bit unsigned integer.


## -remarks



These flags are an output parameter in <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/nf-d3d11-id3d11device-checkcounter">ID3D11Device::CheckCounter</a>.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d11/d3d11-graphics-reference-d3d11-core-enums">Core Enumerations</a>
 

 

