---
UID: NE:d3d11.D3D11_FILTER
title: D3D11_FILTER (d3d11.h)
description: Filtering options during texture sampling.
old-location: direct3d11\d3d11_filter.htm
tech.root: direct3d11
ms.assetid: 873b7910-4686-4f0c-a674-2aa3585a9b36
ms.date: 12/05/2018
ms.keywords: 4c78df1d-3e91-618f-da36-38d58929399e, D3D11_FILTER, D3D11_FILTER enumeration [Direct3D 11], D3D11_FILTER_ANISOTROPIC, D3D11_FILTER_COMPARISON_ANISOTROPIC, D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_MIP_POINT, D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR, D3D11_FILTER_COMPARISON_MIN_MAG_LINEAR_MIP_POINT, D3D11_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR, D3D11_FILTER_COMPARISON_MIN_MAG_MIP_POINT, D3D11_FILTER_COMPARISON_MIN_MAG_POINT_MIP_LINEAR, D3D11_FILTER_COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT, D3D11_FILTER_COMPARISON_MIN_POINT_MAG_MIP_LINEAR, D3D11_FILTER_MAXIMUM_ANISOTROPIC, D3D11_FILTER_MAXIMUM_MIN_LINEAR_MAG_MIP_POINT, D3D11_FILTER_MAXIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR, D3D11_FILTER_MAXIMUM_MIN_MAG_LINEAR_MIP_POINT, D3D11_FILTER_MAXIMUM_MIN_MAG_MIP_LINEAR, D3D11_FILTER_MAXIMUM_MIN_MAG_MIP_POINT, D3D11_FILTER_MAXIMUM_MIN_MAG_POINT_MIP_LINEAR, D3D11_FILTER_MAXIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT, D3D11_FILTER_MAXIMUM_MIN_POINT_MAG_MIP_LINEAR, D3D11_FILTER_MINIMUM_ANISOTROPIC, D3D11_FILTER_MINIMUM_MIN_LINEAR_MAG_MIP_POINT, D3D11_FILTER_MINIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR, D3D11_FILTER_MINIMUM_MIN_MAG_LINEAR_MIP_POINT, D3D11_FILTER_MINIMUM_MIN_MAG_MIP_LINEAR, D3D11_FILTER_MINIMUM_MIN_MAG_MIP_POINT, D3D11_FILTER_MINIMUM_MIN_MAG_POINT_MIP_LINEAR, D3D11_FILTER_MINIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT, D3D11_FILTER_MINIMUM_MIN_POINT_MAG_MIP_LINEAR, D3D11_FILTER_MIN_LINEAR_MAG_MIP_POINT, D3D11_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR, D3D11_FILTER_MIN_MAG_LINEAR_MIP_POINT, D3D11_FILTER_MIN_MAG_MIP_LINEAR, D3D11_FILTER_MIN_MAG_MIP_POINT, D3D11_FILTER_MIN_MAG_POINT_MIP_LINEAR, D3D11_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT, D3D11_FILTER_MIN_POINT_MAG_MIP_LINEAR, d3d11/D3D11_FILTER, d3d11/D3D11_FILTER_ANISOTROPIC, d3d11/D3D11_FILTER_COMPARISON_ANISOTROPIC, d3d11/D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_MIP_POINT, d3d11/D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR, d3d11/D3D11_FILTER_COMPARISON_MIN_MAG_LINEAR_MIP_POINT, d3d11/D3D11_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR, d3d11/D3D11_FILTER_COMPARISON_MIN_MAG_MIP_POINT, d3d11/D3D11_FILTER_COMPARISON_MIN_MAG_POINT_MIP_LINEAR, d3d11/D3D11_FILTER_COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT, d3d11/D3D11_FILTER_COMPARISON_MIN_POINT_MAG_MIP_LINEAR, d3d11/D3D11_FILTER_MAXIMUM_ANISOTROPIC, d3d11/D3D11_FILTER_MAXIMUM_MIN_LINEAR_MAG_MIP_POINT, d3d11/D3D11_FILTER_MAXIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR, d3d11/D3D11_FILTER_MAXIMUM_MIN_MAG_LINEAR_MIP_POINT, d3d11/D3D11_FILTER_MAXIMUM_MIN_MAG_MIP_LINEAR, d3d11/D3D11_FILTER_MAXIMUM_MIN_MAG_MIP_POINT, d3d11/D3D11_FILTER_MAXIMUM_MIN_MAG_POINT_MIP_LINEAR, d3d11/D3D11_FILTER_MAXIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT, d3d11/D3D11_FILTER_MAXIMUM_MIN_POINT_MAG_MIP_LINEAR, d3d11/D3D11_FILTER_MINIMUM_ANISOTROPIC, d3d11/D3D11_FILTER_MINIMUM_MIN_LINEAR_MAG_MIP_POINT, d3d11/D3D11_FILTER_MINIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR, d3d11/D3D11_FILTER_MINIMUM_MIN_MAG_LINEAR_MIP_POINT, d3d11/D3D11_FILTER_MINIMUM_MIN_MAG_MIP_LINEAR, d3d11/D3D11_FILTER_MINIMUM_MIN_MAG_MIP_POINT, d3d11/D3D11_FILTER_MINIMUM_MIN_MAG_POINT_MIP_LINEAR, d3d11/D3D11_FILTER_MINIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT, d3d11/D3D11_FILTER_MINIMUM_MIN_POINT_MAG_MIP_LINEAR, d3d11/D3D11_FILTER_MIN_LINEAR_MAG_MIP_POINT, d3d11/D3D11_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR, d3d11/D3D11_FILTER_MIN_MAG_LINEAR_MIP_POINT, d3d11/D3D11_FILTER_MIN_MAG_MIP_LINEAR, d3d11/D3D11_FILTER_MIN_MAG_MIP_POINT, d3d11/D3D11_FILTER_MIN_MAG_POINT_MIP_LINEAR, d3d11/D3D11_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT, d3d11/D3D11_FILTER_MIN_POINT_MAG_MIP_LINEAR, direct3d11.d3d11_filter
f1_keywords:
- d3d11/D3D11_FILTER
dev_langs:
- c++
req.header: d3d11.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- D3D11.h
api_name:
- D3D11_FILTER
targetos: Windows
req.typenames: D3D11_FILTER
req.redist: 
ms.custom: 19H1
---

# D3D11_FILTER enumeration


## -description


Filtering options during texture sampling.


## -enum-fields




### -field D3D11_FILTER_MIN_MAG_MIP_POINT

Use point sampling for minification, magnification, and mip-level sampling.


### -field D3D11_FILTER_MIN_MAG_POINT_MIP_LINEAR

Use point sampling for minification and magnification; use linear interpolation for mip-level sampling.


### -field D3D11_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT

Use point sampling for minification; use linear interpolation for magnification; use point sampling for mip-level sampling.


### -field D3D11_FILTER_MIN_POINT_MAG_MIP_LINEAR

Use point sampling for minification; use linear interpolation for magnification and mip-level sampling.


### -field D3D11_FILTER_MIN_LINEAR_MAG_MIP_POINT

Use linear interpolation for minification; use point sampling for magnification and mip-level sampling.


### -field D3D11_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR

Use linear interpolation for minification; use point sampling for magnification; use linear interpolation for mip-level sampling.


### -field D3D11_FILTER_MIN_MAG_LINEAR_MIP_POINT

Use linear interpolation for minification and magnification; use point sampling for mip-level sampling.


### -field D3D11_FILTER_MIN_MAG_MIP_LINEAR

Use linear interpolation for minification, magnification, and mip-level sampling.


### -field D3D11_FILTER_ANISOTROPIC

Use anisotropic interpolation for minification, magnification, and mip-level sampling.


### -field D3D11_FILTER_COMPARISON_MIN_MAG_MIP_POINT

Use point sampling for minification, magnification, and mip-level sampling. Compare the result to the comparison value.


### -field D3D11_FILTER_COMPARISON_MIN_MAG_POINT_MIP_LINEAR

Use point sampling for minification and magnification; use linear interpolation for mip-level sampling. Compare the result to the comparison value.


### -field D3D11_FILTER_COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT

Use point sampling for minification; use linear interpolation for magnification; use point sampling for mip-level sampling. Compare the result to the comparison value.


### -field D3D11_FILTER_COMPARISON_MIN_POINT_MAG_MIP_LINEAR

Use point sampling for minification; use linear interpolation for magnification and mip-level sampling. Compare the result to the comparison value.


### -field D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_MIP_POINT

Use linear interpolation for minification; use point sampling for magnification and mip-level sampling. Compare the result to the comparison value.


### -field D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR

Use linear interpolation for minification; use point sampling for magnification; use linear interpolation for mip-level sampling. Compare the result to the comparison value.


### -field D3D11_FILTER_COMPARISON_MIN_MAG_LINEAR_MIP_POINT

Use linear interpolation for minification and magnification; use point sampling for mip-level sampling. Compare the result to the comparison value.


### -field D3D11_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR

Use linear interpolation for minification, magnification, and mip-level sampling. Compare the result to the comparison value.


### -field D3D11_FILTER_COMPARISON_ANISOTROPIC

Use anisotropic interpolation for minification, magnification, and mip-level sampling. Compare the result to the comparison value.


### -field D3D11_FILTER_MINIMUM_MIN_MAG_MIP_POINT

Fetch the same set of texels as <a href="https://docs.microsoft.com/">D3D11_FILTER_MIN_MAG_MIP_POINT</a> and instead of filtering them return the minimum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the minimum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D11_FILTER_MINIMUM_MIN_MAG_POINT_MIP_LINEAR

Fetch the same set of texels as <a href="https://docs.microsoft.com/">D3D11_FILTER_MIN_MAG_POINT_MIP_LINEAR</a> and instead of filtering them return the minimum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the minimum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D11_FILTER_MINIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT

Fetch the same set of texels as <a href="https://docs.microsoft.com/">D3D11_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT</a> and instead of filtering them return the minimum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the minimum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D11_FILTER_MINIMUM_MIN_POINT_MAG_MIP_LINEAR

Fetch the same set of texels as <a href="https://docs.microsoft.com/">D3D11_FILTER_MIN_POINT_MAG_MIP_LINEAR</a> and instead of filtering them return the minimum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the minimum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D11_FILTER_MINIMUM_MIN_LINEAR_MAG_MIP_POINT

Fetch the same set of texels as <a href="https://docs.microsoft.com/">D3D11_FILTER_MIN_LINEAR_MAG_MIP_POINT</a> and instead of filtering them return the minimum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the minimum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D11_FILTER_MINIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR

Fetch the same set of texels as <a href="https://docs.microsoft.com/">D3D11_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR</a> and instead of filtering them return the minimum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the minimum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D11_FILTER_MINIMUM_MIN_MAG_LINEAR_MIP_POINT

Fetch the same set of texels as <a href="https://docs.microsoft.com/">D3D11_FILTER_MIN_MAG_LINEAR_MIP_POINT</a> and instead of filtering them return the minimum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the minimum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D11_FILTER_MINIMUM_MIN_MAG_MIP_LINEAR

Fetch the same set of texels as <a href="https://docs.microsoft.com/">D3D11_FILTER_MIN_MAG_MIP_LINEAR</a> and instead of filtering them return the minimum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the minimum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D11_FILTER_MINIMUM_ANISOTROPIC

Fetch the same set of texels as <a href="https://docs.microsoft.com/">D3D11_FILTER_ANISOTROPIC</a> and instead of filtering them return the minimum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the minimum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D11_FILTER_MAXIMUM_MIN_MAG_MIP_POINT

Fetch the same set of texels as <a href="https://docs.microsoft.com/">D3D11_FILTER_MIN_MAG_MIP_POINT</a> and instead of filtering them return the maximum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the maximum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D11_FILTER_MAXIMUM_MIN_MAG_POINT_MIP_LINEAR

Fetch the same set of texels as <a href="https://docs.microsoft.com/">D3D11_FILTER_MIN_MAG_POINT_MIP_LINEAR</a> and instead of filtering them return the maximum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the maximum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D11_FILTER_MAXIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT

Fetch the same set of texels as <a href="https://docs.microsoft.com/">D3D11_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT</a> and instead of filtering them return the maximum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the maximum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D11_FILTER_MAXIMUM_MIN_POINT_MAG_MIP_LINEAR

Fetch the same set of texels as <a href="https://docs.microsoft.com/">D3D11_FILTER_MIN_POINT_MAG_MIP_LINEAR</a> and instead of filtering them return the maximum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the maximum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D11_FILTER_MAXIMUM_MIN_LINEAR_MAG_MIP_POINT

Fetch the same set of texels as <a href="https://docs.microsoft.com/">D3D11_FILTER_MIN_LINEAR_MAG_MIP_POINT</a> and instead of filtering them return the maximum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the maximum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D11_FILTER_MAXIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR

Fetch the same set of texels as <a href="https://docs.microsoft.com/">D3D11_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR</a> and instead of filtering them return the maximum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the maximum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D11_FILTER_MAXIMUM_MIN_MAG_LINEAR_MIP_POINT

Fetch the same set of texels as <a href="https://docs.microsoft.com/">D3D11_FILTER_MIN_MAG_LINEAR_MIP_POINT</a> and instead of filtering them return the maximum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the maximum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D11_FILTER_MAXIMUM_MIN_MAG_MIP_LINEAR

Fetch the same set of texels as <a href="https://docs.microsoft.com/">D3D11_FILTER_MIN_MAG_MIP_LINEAR</a> and instead of filtering them return the maximum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the maximum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D11_FILTER_MAXIMUM_ANISOTROPIC

Fetch the same set of texels as <a href="https://docs.microsoft.com/">D3D11_FILTER_ANISOTROPIC</a> and instead of filtering them return the maximum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the maximum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


## -remarks



<div class="alert"><b>Note</b>  If you use different filter types for min versus mag filter, undefined behavior occurs in certain cases where the choice between whether magnification or minification happens is ambiguous.  To prevent this undefined behavior, use filter modes that use similar filter operations for both min and mag (or use anisotropic filtering, which avoids the issue as well).</div>
<div> </div>
During texture sampling, one or more texels are read and combined (this is calling filtering) to produce a single value. Point sampling reads a single texel while linear sampling reads two texels (endpoints) and linearly interpolates a third value between the endpoints.

HLSL texture-sampling functions also support comparison filtering during texture sampling. Comparison filtering compares each sampled texel against a comparison value. The boolean result is blended the same way that normal texture filtering is blended.

You can use HLSL intrinsic texture-sampling functions that implement texture filtering only or companion functions that use texture filtering with comparison filtering.

<table>
<tr>
<th>Texture Sampling Function</th>
<th>Texture Sampling Function with Comparison Filtering</th>
</tr>
<tr>
<td>sample</td>
<td>samplecmp or samplecmplevelzero</td>
</tr>
</table>
 

Comparison filters only work with textures that have the following DXGI formats: R32_FLOAT_X8X24_TYPELESS, R32_FLOAT, R24_UNORM_X8_TYPELESS, R16_UNORM.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d11/d3d11-graphics-reference-d3d11-core-enums">Core Enumerations</a>
 

 

