---
UID: NE:d3d11.D3D11_SHADER_MIN_PRECISION_SUPPORT
title: D3D11_SHADER_MIN_PRECISION_SUPPORT (d3d11.h)
description: Values that specify minimum precision levels at shader stages.
old-location: direct3d11\d3d11_shader_min_precision_support.htm
tech.root: direct3d11
ms.assetid: 5D6C605C-079E-4487-8C58-78301520356F
ms.date: 12/05/2018
ms.keywords: D3D11_SHADER_MIN_PRECISION_10_BIT, D3D11_SHADER_MIN_PRECISION_16_BIT, D3D11_SHADER_MIN_PRECISION_SUPPORT, D3D11_SHADER_MIN_PRECISION_SUPPORT enumeration [Direct3D 11], d3d11/D3D11_SHADER_MIN_PRECISION_10_BIT, d3d11/D3D11_SHADER_MIN_PRECISION_16_BIT, d3d11/D3D11_SHADER_MIN_PRECISION_SUPPORT, direct3d11.d3d11_shader_min_precision_support
f1_keywords:
- d3d11/D3D11_SHADER_MIN_PRECISION_SUPPORT
dev_langs:
- c++
req.header: d3d11.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 and Platform Update for Windows 7 [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2012 and Platform Update for Windows Server 2008 R2 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- D3D11.h
api_name:
- D3D11_SHADER_MIN_PRECISION_SUPPORT
targetos: Windows
req.typenames: D3D11_SHADER_MIN_PRECISION_SUPPORT
req.redist: 
ms.custom: 19H1
---

# D3D11_SHADER_MIN_PRECISION_SUPPORT enumeration


## -description


<div class="alert"><b>Note</b>  This enumeration is supported by the Direct3D 11.1 runtime, which is available on Windows 8 and later operating systems.</div><div> </div>Values that specify minimum precision levels at shader stages.


## -enum-fields




### -field D3D11_SHADER_MIN_PRECISION_10_BIT

Minimum precision level is 10-bit.


### -field D3D11_SHADER_MIN_PRECISION_16_BIT

Minimum precision level is 16-bit.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d11/d3d11-graphics-reference-d3d11-core-enums">Core Enumerations</a>



<a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ne-d3d11-d3d11_feature">D3D11_FEATURE</a>



<a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_shader_min_precision_support">D3D11_FEATURE_DATA_SHADER_MIN_PRECISION_SUPPORT</a>
 

 

