---
UID: NE:d3d11.D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT
title: D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT (d3d11.h)
description: Specifies how a video format can be used for video processing.
old-location: mf\d3d11_video_processor_format_support.htm
tech.root: medfound
ms.assetid: A23C33B8-20D0-4F78-B21F-36FCD1506DC6
ms.date: 12/05/2018
ms.keywords: D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT, D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT enumeration [Media Foundation], D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT_INPUT, D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT_OUTPUT, d3d11/D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT, d3d11/D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT_INPUT, d3d11/D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT_OUTPUT, mf.d3d11_video_processor_format_support
f1_keywords:
- d3d11/D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT
dev_langs:
- c++
req.header: d3d11.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2012 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- d3d11.h
api_name:
- D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT
targetos: Windows
req.typenames: D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT
req.redist: 
ms.custom: 19H1
---

# D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT enumeration


## -description


Specifies how a video format can be used for video processing.


## -enum-fields




### -field D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT_INPUT

The format can be used as the input to the video processor.


### -field D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT_OUTPUT

The format can be used as the output from the video processor.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/medfound/direct3d-11-video-enumerations">Direct3D 11 Video Enumerations</a>



<a href="https://docs.microsoft.com/windows/desktop/api/d3d11/nf-d3d11-id3d11videoprocessorenumerator-checkvideoprocessorformat">ID3D11VideoProcessorEnumerator::CheckVideoProcessorFormat</a>
 

 

