---
UID: NE:d3d11.D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS
title: D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS (d3d11.h)
description: Specifies the inverse telecine (IVTC) capabilities of a video processor.
old-location: mf\d3d11_video_processor_itelecine_caps.htm
tech.root: medfound
ms.assetid: EE92F877-1B27-4A95-8BB7-01852253D112
ms.date: 12/05/2018
ms.keywords: D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS, D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS enumeration [Media Foundation], D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_22, D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_222222222223, D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_2224, D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_2332, D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_32, D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_32322, D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_55, D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_64, D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_87, D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_OTHER, d3d11/D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS, d3d11/D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_22, d3d11/D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_222222222223, d3d11/D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_2224, d3d11/D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_2332, d3d11/D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_32, d3d11/D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_32322, d3d11/D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_55, d3d11/D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_64, d3d11/D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_87, d3d11/D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_OTHER, mf.d3d11_video_processor_itelecine_caps
f1_keywords:
- d3d11/D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS
dev_langs:
- c++
req.header: d3d11.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2012 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- d3d11.h
api_name:
- D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS
targetos: Windows
req.typenames: D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS
req.redist: 
ms.custom: 19H1
---

# D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS enumeration


## -description


Specifies the inverse telecine (IVTC) capabilities of a video processor.




## -enum-fields




### -field D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_32

The video processor can reverse 3:2 pulldown.


### -field D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_22

The video processor can reverse 2:2 pulldown.


### -field D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_2224

The video processor can reverse 2:2:2:4 pulldown.


### -field D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_2332

The video processor can reverse 2:3:3:2 pulldown.


### -field D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_32322

The video processor can reverse 3:2:3:2:2 pulldown.


### -field D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_55

The video processor can reverse 5:5 pulldown.


### -field D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_64

The video processor can reverse 6:4 pulldown.


### -field D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_87

The video processor can reverse 8:7 pulldown.


### -field D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_222222222223

The video processor can reverse 2:2:2:2:2:2:2:2:2:2:2:3 pulldown.


### -field D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_OTHER

The video processor can reverse other telecine modes not listed here.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_video_processor_rate_conversion_caps">D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS</a>



<a href="https://docs.microsoft.com/windows/desktop/medfound/direct3d-11-video-enumerations">Direct3D 11 Video Enumerations</a>
 

 

