---
UID: NE:d3d11.D3D11_VIDEO_PROCESSOR_OUTPUT_RATE
title: D3D11_VIDEO_PROCESSOR_OUTPUT_RATE (d3d11.h)
description: Specifies the rate at which the video processor produces output frames from an input stream.
old-location: mf\d3d11_video_processor_output_rate.htm
tech.root: medfound
ms.assetid: C950E5B5-E50C-4750-83F3-38296EF2009F
ms.date: 12/05/2018
ms.keywords: D3D11_VIDEO_PROCESSOR_OUTPUT_RATE, D3D11_VIDEO_PROCESSOR_OUTPUT_RATE enumeration [Media Foundation], D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_CUSTOM, D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_HALF, D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_NORMAL, d3d11/D3D11_VIDEO_PROCESSOR_OUTPUT_RATE, d3d11/D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_CUSTOM, d3d11/D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_HALF, d3d11/D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_NORMAL, mf.d3d11_video_processor_output_rate
f1_keywords:
- d3d11/D3D11_VIDEO_PROCESSOR_OUTPUT_RATE
dev_langs:
- c++
req.header: d3d11.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2012 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- d3d11.h
api_name:
- D3D11_VIDEO_PROCESSOR_OUTPUT_RATE
targetos: Windows
req.typenames: D3D11_VIDEO_PROCESSOR_OUTPUT_RATE
req.redist: 
ms.custom: 19H1
---

# D3D11_VIDEO_PROCESSOR_OUTPUT_RATE enumeration


## -description


Specifies the rate at which the video processor produces output frames from an input stream.


## -enum-fields




### -field D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_NORMAL

The output is the normal frame rate.




### -field D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_HALF

The output is half the frame rate.




### -field D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_CUSTOM

The output is a custom frame rate.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/medfound/direct3d-11-video-enumerations">Direct3D 11 Video Enumerations</a>



<a href="https://docs.microsoft.com/windows/desktop/api/d3d11/nf-d3d11-id3d11videocontext-videoprocessorsetstreamoutputrate">ID3D11VideoContext::VideoProcessorSetStreamOutputRate</a>
 

 

