---
UID: NS:d3d11._D3D11_AES_CTR_IV
title: D3D11_AES_CTR_IV (d3d11.h)
description: Contains an initialization vector (IV) for 128-bit Advanced Encryption Standard CTR mode (AES-CTR) block cipher encryption.
old-location: mf\d3d11_aes_ctr_iv.htm
tech.root: medfound
ms.assetid: 2D1B24CA-6386-4406-9195-40913744C9CF
ms.date: 12/05/2018
ms.keywords: D3D11_AES_CTR_IV, D3D11_AES_CTR_IV structure [Media Foundation], d3d11/D3D11_AES_CTR_IV, mf.d3d11_aes_ctr_iv
f1_keywords:
- d3d11/D3D11_AES_CTR_IV
dev_langs:
- c++
req.header: d3d11.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2012 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- d3d11.h
api_name:
- D3D11_AES_CTR_IV
targetos: Windows
req.typenames: D3D11_AES_CTR_IV
req.redist: 
ms.custom: 19H1
---

# D3D11_AES_CTR_IV structure


## -description


Contains an initialization vector (IV) for 128-bit Advanced Encryption Standard CTR mode (AES-CTR) block cipher encryption.




## -struct-fields




### -field IV

The IV, in big-endian format.


### -field Count

The block count, in big-endian format.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/medfound/direct3d-11-video-structures">Direct3D 11 Video Structures</a>
 

 

