---
UID: NS:d3d11.D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT
title: D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT (d3d11.h)
description: Describes feature data GPU virtual address support, including maximum address bits per resource and per process.
old-location: direct3d11\d3d11_feature_data_gpu_virtual_address_support.htm
tech.root: direct3d11
ms.assetid: 662D9B07-755C-430D-84C6-B1E8876E26B5
ms.date: 12/05/2018
ms.keywords: D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT, D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT structure [Direct3D 11], d3d11/D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT, direct3d11.d3d11_feature_data_gpu_virtual_address_support
f1_keywords:
- d3d11/D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT
dev_langs:
- c++
req.header: d3d11.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- d3d11.h
api_name:
- D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT
targetos: Windows
req.typenames: D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT
req.redist: 
ms.custom: 19H1
---

# D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT structure


## -description


Describes feature data GPU virtual address support, including maximum address bits per resource and per process.
          


## -struct-fields




### -field MaxGPUVirtualAddressBitsPerResource

The maximum GPU virtual address bits per resource.
            


### -field MaxGPUVirtualAddressBitsPerProcess

The maximum GPU virtual address bits per process.
            


## -remarks



See <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ne-d3d11-d3d11_feature">D3D11_FEATURE</a>.
      




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d11/d3d11-graphics-reference-d3d11-core-structures">Core Structures</a>
 

 

