---
UID: NS:d3d11.D3D11_TEX1D_DSV
title: D3D11_TEX1D_DSV (d3d11.h)
description: Specifies the subresource from a 1D texture that is accessible to a depth-stencil view.
old-location: direct3d11\d3d11_tex1d_dsv.htm
tech.root: direct3d11
ms.assetid: dfdbad36-3cfc-4e24-9864-ffe1405030b2
ms.date: 12/05/2018
ms.keywords: 52fb74db-7253-5122-a349-5c58ded9ca7e, D3D11_TEX1D_DSV, D3D11_TEX1D_DSV structure [Direct3D 11], d3d11/D3D11_TEX1D_DSV, direct3d11.d3d11_tex1d_dsv
f1_keywords:
- d3d11/D3D11_TEX1D_DSV
dev_langs:
- c++
req.header: d3d11.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- D3D11.h
api_name:
- D3D11_TEX1D_DSV
targetos: Windows
req.typenames: D3D11_TEX1D_DSV
req.redist: 
ms.custom: 19H1
---

# D3D11_TEX1D_DSV structure


## -description


Specifies the subresource from a 1D texture that is accessible to a depth-stencil view.


## -struct-fields




### -field MipSlice

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">UINT</a></b>

The index of the first mipmap level to use.


## -remarks



This structure is one member of a depth-stencil-view description (see <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_depth_stencil_view_desc">D3D11_DEPTH_STENCIL_VIEW_DESC</a>).




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d11/d3d11-graphics-reference-resource-structures">Resource Structures</a>
 

 

