---
UID: NE:d3d11shadertracing.D3D11_TRACE_REGISTER_TYPE
title: D3D11_TRACE_REGISTER_TYPE (d3d11shadertracing.h)
description: Identifies a type of trace register.
old-location: direct3d11\d3d11_trace_register_type.htm
tech.root: direct3d11
ms.assetid: 94B0BA0B-94DB-4449-8E3B-EEB1F6B85FB5
ms.date: 12/05/2018
ms.keywords: D3D11_TRACE_CONSTANT_BUFFER, D3D11_TRACE_IMMEDIATE32, D3D11_TRACE_IMMEDIATE64, D3D11_TRACE_IMMEDIATE_CONSTANT_BUFFER, D3D11_TRACE_INDEXABLE_TEMP_REGISTER, D3D11_TRACE_INPUT_CONTROL_POINT_REGISTER, D3D11_TRACE_INPUT_COVERAGE_MASK_REGISTER, D3D11_TRACE_INPUT_CYCLE_COUNTER_REGISTER, D3D11_TRACE_INPUT_DOMAIN_POINT_REGISTER, D3D11_TRACE_INPUT_FORK_INSTANCE_ID_REGISTER, D3D11_TRACE_INPUT_GS_INSTANCE_ID_REGISTER, D3D11_TRACE_INPUT_JOIN_INSTANCE_ID_REGISTER, D3D11_TRACE_INPUT_PATCH_CONSTANT_REGISTER, D3D11_TRACE_INPUT_PRIMITIVE_ID_REGISTER, D3D11_TRACE_INPUT_REGISTER, D3D11_TRACE_INPUT_THREAD_GROUP_ID_REGISTER, D3D11_TRACE_INPUT_THREAD_ID_IN_GROUP_FLATTENED_REGISTER, D3D11_TRACE_INPUT_THREAD_ID_IN_GROUP_REGISTER, D3D11_TRACE_INPUT_THREAD_ID_REGISTER, D3D11_TRACE_INTERFACE_POINTER, D3D11_TRACE_OUTPUT_CONTROL_POINT_ID_REGISTER, D3D11_TRACE_OUTPUT_CONTROL_POINT_REGISTER, D3D11_TRACE_OUTPUT_COVERAGE_MASK, D3D11_TRACE_OUTPUT_DEPTH_GREATER_EQUAL_REGISTER, D3D11_TRACE_OUTPUT_DEPTH_LESS_EQUAL_REGISTER, D3D11_TRACE_OUTPUT_DEPTH_REGISTER, D3D11_TRACE_OUTPUT_NULL_REGISTER, D3D11_TRACE_OUTPUT_REGISTER, D3D11_TRACE_RASTERIZER, D3D11_TRACE_REGISTER_TYPE, D3D11_TRACE_REGISTER_TYPE enumeration [Direct3D 11], D3D11_TRACE_RESOURCE, D3D11_TRACE_SAMPLER, D3D11_TRACE_STREAM, D3D11_TRACE_TEMP_REGISTER, D3D11_TRACE_THIS_POINTER, D3D11_TRACE_THREAD_GROUP_SHARED_MEMORY, D3D11_TRACE_UNORDERED_ACCESS_VIEW, d3d11shadertracing/D3D11_TRACE_CONSTANT_BUFFER, d3d11shadertracing/D3D11_TRACE_IMMEDIATE32, d3d11shadertracing/D3D11_TRACE_IMMEDIATE64, d3d11shadertracing/D3D11_TRACE_IMMEDIATE_CONSTANT_BUFFER, d3d11shadertracing/D3D11_TRACE_INDEXABLE_TEMP_REGISTER, d3d11shadertracing/D3D11_TRACE_INPUT_CONTROL_POINT_REGISTER, d3d11shadertracing/D3D11_TRACE_INPUT_COVERAGE_MASK_REGISTER, d3d11shadertracing/D3D11_TRACE_INPUT_CYCLE_COUNTER_REGISTER, d3d11shadertracing/D3D11_TRACE_INPUT_DOMAIN_POINT_REGISTER, d3d11shadertracing/D3D11_TRACE_INPUT_FORK_INSTANCE_ID_REGISTER, d3d11shadertracing/D3D11_TRACE_INPUT_GS_INSTANCE_ID_REGISTER, d3d11shadertracing/D3D11_TRACE_INPUT_JOIN_INSTANCE_ID_REGISTER, d3d11shadertracing/D3D11_TRACE_INPUT_PATCH_CONSTANT_REGISTER, d3d11shadertracing/D3D11_TRACE_INPUT_PRIMITIVE_ID_REGISTER, d3d11shadertracing/D3D11_TRACE_INPUT_REGISTER, d3d11shadertracing/D3D11_TRACE_INPUT_THREAD_GROUP_ID_REGISTER, d3d11shadertracing/D3D11_TRACE_INPUT_THREAD_ID_IN_GROUP_FLATTENED_REGISTER, d3d11shadertracing/D3D11_TRACE_INPUT_THREAD_ID_IN_GROUP_REGISTER, d3d11shadertracing/D3D11_TRACE_INPUT_THREAD_ID_REGISTER, d3d11shadertracing/D3D11_TRACE_INTERFACE_POINTER, d3d11shadertracing/D3D11_TRACE_OUTPUT_CONTROL_POINT_ID_REGISTER, d3d11shadertracing/D3D11_TRACE_OUTPUT_CONTROL_POINT_REGISTER, d3d11shadertracing/D3D11_TRACE_OUTPUT_COVERAGE_MASK, d3d11shadertracing/D3D11_TRACE_OUTPUT_DEPTH_GREATER_EQUAL_REGISTER, d3d11shadertracing/D3D11_TRACE_OUTPUT_DEPTH_LESS_EQUAL_REGISTER, d3d11shadertracing/D3D11_TRACE_OUTPUT_DEPTH_REGISTER, d3d11shadertracing/D3D11_TRACE_OUTPUT_NULL_REGISTER, d3d11shadertracing/D3D11_TRACE_OUTPUT_REGISTER, d3d11shadertracing/D3D11_TRACE_RASTERIZER, d3d11shadertracing/D3D11_TRACE_REGISTER_TYPE, d3d11shadertracing/D3D11_TRACE_RESOURCE, d3d11shadertracing/D3D11_TRACE_SAMPLER, d3d11shadertracing/D3D11_TRACE_STREAM, d3d11shadertracing/D3D11_TRACE_TEMP_REGISTER, d3d11shadertracing/D3D11_TRACE_THIS_POINTER, d3d11shadertracing/D3D11_TRACE_THREAD_GROUP_SHARED_MEMORY, d3d11shadertracing/D3D11_TRACE_UNORDERED_ACCESS_VIEW, direct3d11.d3d11_trace_register_type
f1_keywords:
- d3d11shadertracing/D3D11_TRACE_REGISTER_TYPE
dev_langs:
- c++
req.header: d3d11shadertracing.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- D3D11ShaderTracing.h
api_name:
- D3D11_TRACE_REGISTER_TYPE
targetos: Windows
req.typenames: D3D11_TRACE_REGISTER_TYPE
req.redist: 
ms.custom: 19H1
---

# D3D11_TRACE_REGISTER_TYPE enumeration


## -description


Identifies a type of trace register.


## -enum-fields




### -field D3D11_TRACE_OUTPUT_NULL_REGISTER

Output <b>NULL</b> register.


### -field D3D11_TRACE_INPUT_REGISTER

Input register.


### -field D3D11_TRACE_INPUT_PRIMITIVE_ID_REGISTER

Input primitive ID register.


### -field D3D11_TRACE_IMMEDIATE_CONSTANT_BUFFER

Immediate constant buffer.


### -field D3D11_TRACE_TEMP_REGISTER

Temporary register.


### -field D3D11_TRACE_INDEXABLE_TEMP_REGISTER

Temporary register that can be indexed.


### -field D3D11_TRACE_OUTPUT_REGISTER

Output register.


### -field D3D11_TRACE_OUTPUT_DEPTH_REGISTER

Output oDepth register.


### -field D3D11_TRACE_CONSTANT_BUFFER

Constant buffer.


### -field D3D11_TRACE_IMMEDIATE32

Immediate32 register.


### -field D3D11_TRACE_SAMPLER

Sampler.


### -field D3D11_TRACE_RESOURCE

Resource.


### -field D3D11_TRACE_RASTERIZER

Rasterizer.


### -field D3D11_TRACE_OUTPUT_COVERAGE_MASK

Output coverage mask.


### -field D3D11_TRACE_STREAM

Stream.


### -field D3D11_TRACE_THIS_POINTER

This pointer.


### -field D3D11_TRACE_OUTPUT_CONTROL_POINT_ID_REGISTER

Output control point ID register (this is actually an input; it defines the output that the thread controls).


### -field D3D11_TRACE_INPUT_FORK_INSTANCE_ID_REGISTER

Input fork instance ID register.


### -field D3D11_TRACE_INPUT_JOIN_INSTANCE_ID_REGISTER

Input join instance ID register.


### -field D3D11_TRACE_INPUT_CONTROL_POINT_REGISTER

Input control point register.


### -field D3D11_TRACE_OUTPUT_CONTROL_POINT_REGISTER

Output control point register.


### -field D3D11_TRACE_INPUT_PATCH_CONSTANT_REGISTER

Input patch constant register.


### -field D3D11_TRACE_INPUT_DOMAIN_POINT_REGISTER

Input domain point register.


### -field D3D11_TRACE_UNORDERED_ACCESS_VIEW

Unordered-access view.


### -field D3D11_TRACE_THREAD_GROUP_SHARED_MEMORY

Thread group shared memory.


### -field D3D11_TRACE_INPUT_THREAD_ID_REGISTER

Input thread ID register.


### -field D3D11_TRACE_INPUT_THREAD_GROUP_ID_REGISTER

Thread group ID register.


### -field D3D11_TRACE_INPUT_THREAD_ID_IN_GROUP_REGISTER

Input thread ID in-group register.


### -field D3D11_TRACE_INPUT_COVERAGE_MASK_REGISTER

Input coverage mask register.


### -field D3D11_TRACE_INPUT_THREAD_ID_IN_GROUP_FLATTENED_REGISTER

Input thread ID in-group flattened register.


### -field D3D11_TRACE_INPUT_GS_INSTANCE_ID_REGISTER

Input geometry shader (GS) instance ID register.


### -field D3D11_TRACE_OUTPUT_DEPTH_GREATER_EQUAL_REGISTER

Output oDepth greater than or equal register.


### -field D3D11_TRACE_OUTPUT_DEPTH_LESS_EQUAL_REGISTER

Output oDepth less than or equal register.


### -field D3D11_TRACE_IMMEDIATE64

Immediate64 register.


### -field D3D11_TRACE_INPUT_CYCLE_COUNTER_REGISTER

Cycle counter register.


### -field D3D11_TRACE_INTERFACE_POINTER

Interface pointer.


## -remarks



<b>D3D11_TRACE_REGISTER_TYPE</b> identifies the type of trace register in a <a href="https://docs.microsoft.com/windows/desktop/api/d3d11shadertracing/ns-d3d11shadertracing-d3d11_trace_register">D3D11_TRACE_REGISTER</a> structure.

<div class="alert"><b>Note</b>  This API requires the Windows Software Development Kit (SDK) for Windows 8.</div>
<div> </div>



## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d11/d3d11-graphics-reference-shader-enums">Shader Enumerations</a>
 

 

