---
UID: NE:d3d12.D3D12_AXIS_SHADING_RATE
title: D3D12_AXIS_SHADING_RATE
description: Defines constants that specify the shading rate (for variable-rate shading, or VRS) along a horizontal or vertical axis.
ms.date: 05/20/2019
ms.keywords: D3D12_AXIS_SHADING_RATE
f1_keywords:
- d3d12/D3D12_AXIS_SHADING_RATE
dev_langs:
- c++
targetos: Windows
req.construct-type: enumeration
req.ddi-compliance: 
req.header: d3d12.h
req.include-header: 
req.kmdf-ver: 
req.max-support: 
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.target-type: 
req.typenames: 
req.umdf-ver: 
topic_type:
- apiref
api_type:
- HeaderDef
api_location:
- d3d12.h
api_name:
- D3D12_AXIS_SHADING_RATE
---

## -description

Defines constants that specify the shading rate (for variable-rate shading, or VRS) along a horizontal or vertical axis. For more info, see [Variable-rate shading (VRS)](/windows/desktop/direct3d12/vrs).

## -enum-fields

### -field D3D12_AXIS_SHADING_RATE_1X

Specifies a 1x shading rate for the axis.

### -field D3D12_AXIS_SHADING_RATE_2X

Specifies a 2x shading rate for the axis.

### -field D3D12_AXIS_SHADING_RATE_4X

Specifies a 4x shading rate for the axis.

## -remarks

## -see-also

[Variable-rate shading (VRS)](/windows/desktop/direct3d12/vrs)
