---
UID: NE:d3d12.D3D12_CONSERVATIVE_RASTERIZATION_MODE
title: D3D12_CONSERVATIVE_RASTERIZATION_MODE (d3d12.h)
description: Identifies whether conservative rasterization is on or off.
old-location: direct3d12\d3d12_conservative_rasterization_mode.htm
tech.root: direct3d12
ms.assetid: E0F033D5-8042-4C39-A35D-C8FE2A95C1D2
ms.date: 12/05/2018
ms.keywords: D3D12_CONSERVATIVE_RASTERIZATION_MODE, D3D12_CONSERVATIVE_RASTERIZATION_MODE enumeration, D3D12_CONSERVATIVE_RASTERIZATION_MODE_OFF, D3D12_CONSERVATIVE_RASTERIZATION_MODE_ON, d3d12/D3D12_CONSERVATIVE_RASTERIZATION_MODE, d3d12/D3D12_CONSERVATIVE_RASTERIZATION_MODE_OFF, d3d12/D3D12_CONSERVATIVE_RASTERIZATION_MODE_ON, direct3d12.d3d12_conservative_rasterization_mode
f1_keywords:
- d3d12/D3D12_CONSERVATIVE_RASTERIZATION_MODE
dev_langs:
- c++
req.header: d3d12.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- D3D12.h
api_name:
- D3D12_CONSERVATIVE_RASTERIZATION_MODE
targetos: Windows
req.typenames: D3D12_CONSERVATIVE_RASTERIZATION_MODE
req.redist: 
ms.custom: 19H1
---

# D3D12_CONSERVATIVE_RASTERIZATION_MODE enumeration


## -description


Identifies whether conservative rasterization is on or off.


## -enum-fields




### -field D3D12_CONSERVATIVE_RASTERIZATION_MODE_OFF

Conservative rasterization is off.


### -field D3D12_CONSERVATIVE_RASTERIZATION_MODE_ON

Conservative rasterization is on.


## -remarks



This enum is used by the <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ns-d3d12-d3d12_rasterizer_desc">D3D12_RASTERIZER_DESC</a> structure. 




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d12/conservative-rasterization">Conservative Rasterization</a>



<a href="https://docs.microsoft.com/windows/desktop/direct3d12/direct3d-12-enumerations">Core Enumerations</a>



<a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ne-d3d12-d3d12_conservative_rasterization_tier">D3D12_CONSERVATIVE_RASTERIZATION_TIER</a>
 

 

