---
UID: NE:d3d12.D3D12_DRED_VERSION
title: D3D12_DRED_VERSION
description: Defines constants that specify a version of Device Removed Extended Data (DRED), as used by the D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA structure.
ms.date: 02/06/2019
ms.keywords: D3D12_DRED_VERSION, D3D12_DRED_VERSION enumeration, D3D12_DRED_VERSION_1_0, D3D12_DRED_VERSION_1_1, d3d12/D3D12_DRED_VERSION, d3d12/D3D12_DRED_VERSION enumeration, d3d12/D3D12_DRED_VERSION_1_0, d3d12/D3D12_DRED_VERSION_1_1, direct3d12.d3d12_dred_version
f1_keywords:
- d3d12/D3D12_DRED_VERSION
dev_langs:
- c++
targetos: Windows
req.construct-type: enumeration
req.ddi-compliance: 
req.header: d3d12.h
req.include-header: 
req.kmdf-ver: 
req.max-support: 
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.target-type: 
req.typenames: D3D12_DRED_VERSION
req.umdf-ver: 
topic_type:
- apiref
api_type:
- HeaderDef
api_location:
- d3d12.h
api_name:
- D3D12_DRED_VERSION
ms.custom: 19H1
---

# D3D12_DRED_VERSION enumeration

## -description

Defines constants that specify a version of Device Removed Extended Data (DRED), as used by the [D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA structure](ns-d3d12-d3d12_versioned_device_removed_extended_data.md).

## -enum-fields

### -field D3D12_DRED_VERSION_1_0 (0x1)

Specifies DRED version 1.0.

### -field D3D12_DRED_VERSION_1_1 (0x2)

Specifies DRED version 1.1.

## -remarks

## -see-also

* [Core enumerations](/windows/desktop/direct3d12/direct3d-12-enumerations)
* [Use DRED to diagnose GPU faults](/windows/desktop/direct3d12/use-dred)
