---
UID: NE:d3d12.D3D12_FILTER
title: D3D12_FILTER (d3d12.h)
description: Specifies filtering options during texture sampling.
old-location: direct3d12\d3d12_filter.htm
tech.root: direct3d12
ms.assetid: 3755A722-34E5-415E-8760-93094D033E05
ms.date: 12/05/2018
ms.keywords: D3D12_FILTER, D3D12_FILTER enumeration, D3D12_FILTER_ANISOTROPIC, D3D12_FILTER_COMPARISON_ANISOTROPIC, D3D12_FILTER_COMPARISON_MIN_LINEAR_MAG_MIP_POINT, D3D12_FILTER_COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR, D3D12_FILTER_COMPARISON_MIN_MAG_LINEAR_MIP_POINT, D3D12_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR, D3D12_FILTER_COMPARISON_MIN_MAG_MIP_POINT, D3D12_FILTER_COMPARISON_MIN_MAG_POINT_MIP_LINEAR, D3D12_FILTER_COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT, D3D12_FILTER_COMPARISON_MIN_POINT_MAG_MIP_LINEAR, D3D12_FILTER_MAXIMUM_ANISOTROPIC, D3D12_FILTER_MAXIMUM_MIN_LINEAR_MAG_MIP_POINT, D3D12_FILTER_MAXIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR, D3D12_FILTER_MAXIMUM_MIN_MAG_LINEAR_MIP_POINT, D3D12_FILTER_MAXIMUM_MIN_MAG_MIP_LINEAR, D3D12_FILTER_MAXIMUM_MIN_MAG_MIP_POINT, D3D12_FILTER_MAXIMUM_MIN_MAG_POINT_MIP_LINEAR, D3D12_FILTER_MAXIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT, D3D12_FILTER_MAXIMUM_MIN_POINT_MAG_MIP_LINEAR, D3D12_FILTER_MINIMUM_ANISOTROPIC, D3D12_FILTER_MINIMUM_MIN_LINEAR_MAG_MIP_POINT, D3D12_FILTER_MINIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR, D3D12_FILTER_MINIMUM_MIN_MAG_LINEAR_MIP_POINT, D3D12_FILTER_MINIMUM_MIN_MAG_MIP_LINEAR, D3D12_FILTER_MINIMUM_MIN_MAG_MIP_POINT, D3D12_FILTER_MINIMUM_MIN_MAG_POINT_MIP_LINEAR, D3D12_FILTER_MINIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT, D3D12_FILTER_MINIMUM_MIN_POINT_MAG_MIP_LINEAR, D3D12_FILTER_MIN_LINEAR_MAG_MIP_POINT, D3D12_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR, D3D12_FILTER_MIN_MAG_LINEAR_MIP_POINT, D3D12_FILTER_MIN_MAG_MIP_LINEAR, D3D12_FILTER_MIN_MAG_MIP_POINT, D3D12_FILTER_MIN_MAG_POINT_MIP_LINEAR, D3D12_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT, D3D12_FILTER_MIN_POINT_MAG_MIP_LINEAR, d3d12/D3D12_FILTER, d3d12/D3D12_FILTER_ANISOTROPIC, d3d12/D3D12_FILTER_COMPARISON_ANISOTROPIC, d3d12/D3D12_FILTER_COMPARISON_MIN_LINEAR_MAG_MIP_POINT, d3d12/D3D12_FILTER_COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR, d3d12/D3D12_FILTER_COMPARISON_MIN_MAG_LINEAR_MIP_POINT, d3d12/D3D12_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR, d3d12/D3D12_FILTER_COMPARISON_MIN_MAG_MIP_POINT, d3d12/D3D12_FILTER_COMPARISON_MIN_MAG_POINT_MIP_LINEAR, d3d12/D3D12_FILTER_COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT, d3d12/D3D12_FILTER_COMPARISON_MIN_POINT_MAG_MIP_LINEAR, d3d12/D3D12_FILTER_MAXIMUM_ANISOTROPIC, d3d12/D3D12_FILTER_MAXIMUM_MIN_LINEAR_MAG_MIP_POINT, d3d12/D3D12_FILTER_MAXIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR, d3d12/D3D12_FILTER_MAXIMUM_MIN_MAG_LINEAR_MIP_POINT, d3d12/D3D12_FILTER_MAXIMUM_MIN_MAG_MIP_LINEAR, d3d12/D3D12_FILTER_MAXIMUM_MIN_MAG_MIP_POINT, d3d12/D3D12_FILTER_MAXIMUM_MIN_MAG_POINT_MIP_LINEAR, d3d12/D3D12_FILTER_MAXIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT, d3d12/D3D12_FILTER_MAXIMUM_MIN_POINT_MAG_MIP_LINEAR, d3d12/D3D12_FILTER_MINIMUM_ANISOTROPIC, d3d12/D3D12_FILTER_MINIMUM_MIN_LINEAR_MAG_MIP_POINT, d3d12/D3D12_FILTER_MINIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR, d3d12/D3D12_FILTER_MINIMUM_MIN_MAG_LINEAR_MIP_POINT, d3d12/D3D12_FILTER_MINIMUM_MIN_MAG_MIP_LINEAR, d3d12/D3D12_FILTER_MINIMUM_MIN_MAG_MIP_POINT, d3d12/D3D12_FILTER_MINIMUM_MIN_MAG_POINT_MIP_LINEAR, d3d12/D3D12_FILTER_MINIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT, d3d12/D3D12_FILTER_MINIMUM_MIN_POINT_MAG_MIP_LINEAR, d3d12/D3D12_FILTER_MIN_LINEAR_MAG_MIP_POINT, d3d12/D3D12_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR, d3d12/D3D12_FILTER_MIN_MAG_LINEAR_MIP_POINT, d3d12/D3D12_FILTER_MIN_MAG_MIP_LINEAR, d3d12/D3D12_FILTER_MIN_MAG_MIP_POINT, d3d12/D3D12_FILTER_MIN_MAG_POINT_MIP_LINEAR, d3d12/D3D12_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT, d3d12/D3D12_FILTER_MIN_POINT_MAG_MIP_LINEAR, direct3d12.d3d12_filter
f1_keywords:
- d3d12/D3D12_FILTER
dev_langs:
- c++
req.header: d3d12.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- D3D12.h
api_name:
- D3D12_FILTER
targetos: Windows
req.typenames: D3D12_FILTER
req.redist: 
ms.custom: 19H1
---

# D3D12_FILTER enumeration


## -description


Specifies filtering options during texture sampling.


## -enum-fields




### -field D3D12_FILTER_MIN_MAG_MIP_POINT

Use point sampling for minification, magnification, and mip-level sampling.


### -field D3D12_FILTER_MIN_MAG_POINT_MIP_LINEAR

Use point sampling for minification and magnification; use linear interpolation for mip-level sampling.


### -field D3D12_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT

Use point sampling for minification; use linear interpolation for magnification; use point sampling for mip-level sampling.


### -field D3D12_FILTER_MIN_POINT_MAG_MIP_LINEAR

Use point sampling for minification; use linear interpolation for magnification and mip-level sampling.


### -field D3D12_FILTER_MIN_LINEAR_MAG_MIP_POINT

Use linear interpolation for minification; use point sampling for magnification and mip-level sampling.


### -field D3D12_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR

Use linear interpolation for minification; use point sampling for magnification; use linear interpolation for mip-level sampling.


### -field D3D12_FILTER_MIN_MAG_LINEAR_MIP_POINT

Use linear interpolation for minification and magnification; use point sampling for mip-level sampling.


### -field D3D12_FILTER_MIN_MAG_MIP_LINEAR

Use linear interpolation for minification, magnification, and mip-level sampling.


### -field D3D12_FILTER_ANISOTROPIC

Use anisotropic interpolation for minification, magnification, and mip-level sampling.


### -field D3D12_FILTER_COMPARISON_MIN_MAG_MIP_POINT

Use point sampling for minification, magnification, and mip-level sampling. Compare the result to the comparison value.


### -field D3D12_FILTER_COMPARISON_MIN_MAG_POINT_MIP_LINEAR

Use point sampling for minification and magnification; use linear interpolation for mip-level sampling. Compare the result to the comparison value.


### -field D3D12_FILTER_COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT

Use point sampling for minification; use linear interpolation for magnification; use point sampling for mip-level sampling. Compare the result to the comparison value.


### -field D3D12_FILTER_COMPARISON_MIN_POINT_MAG_MIP_LINEAR

Use point sampling for minification; use linear interpolation for magnification and mip-level sampling. Compare the result to the comparison value.


### -field D3D12_FILTER_COMPARISON_MIN_LINEAR_MAG_MIP_POINT

Use linear interpolation for minification; use point sampling for magnification and mip-level sampling. Compare the result to the comparison value.


### -field D3D12_FILTER_COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR

Use linear interpolation for minification; use point sampling for magnification; use linear interpolation for mip-level sampling. Compare the result to the comparison value.


### -field D3D12_FILTER_COMPARISON_MIN_MAG_LINEAR_MIP_POINT

Use linear interpolation for minification and magnification; use point sampling for mip-level sampling. Compare the result to the comparison value.


### -field D3D12_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR

Use linear interpolation for minification, magnification, and mip-level sampling. Compare the result to the comparison value.


### -field D3D12_FILTER_COMPARISON_ANISOTROPIC

Use anisotropic interpolation for minification, magnification, and mip-level sampling. Compare the result to the comparison value.


### -field D3D12_FILTER_MINIMUM_MIN_MAG_MIP_POINT

Fetch the same set of texels as <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ne-d3d12-d3d12_filter">D3D12_FILTER_MIN_MAG_MIP_POINT</a> and instead of filtering them return the minimum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the minimum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D12_FILTER_MINIMUM_MIN_MAG_POINT_MIP_LINEAR

Fetch the same set of texels as <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ne-d3d12-d3d12_filter">D3D12_FILTER_MIN_MAG_POINT_MIP_LINEAR</a> and instead of filtering them return the minimum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the minimum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D12_FILTER_MINIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT

Fetch the same set of texels as <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ne-d3d12-d3d12_filter">D3D12_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT</a> and instead of filtering them return the minimum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the minimum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D12_FILTER_MINIMUM_MIN_POINT_MAG_MIP_LINEAR

Fetch the same set of texels as <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ne-d3d12-d3d12_filter">D3D12_FILTER_MIN_POINT_MAG_MIP_LINEAR</a> and instead of filtering them return the minimum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the minimum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D12_FILTER_MINIMUM_MIN_LINEAR_MAG_MIP_POINT

Fetch the same set of texels as <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ne-d3d12-d3d12_filter">D3D12_FILTER_MIN_LINEAR_MAG_MIP_POINT</a> and instead of filtering them return the minimum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the minimum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D12_FILTER_MINIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR

Fetch the same set of texels as <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ne-d3d12-d3d12_filter">D3D12_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR</a> and instead of filtering them return the minimum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the minimum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D12_FILTER_MINIMUM_MIN_MAG_LINEAR_MIP_POINT

Fetch the same set of texels as <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ne-d3d12-d3d12_filter">D3D12_FILTER_MIN_MAG_LINEAR_MIP_POINT</a> and instead of filtering them return the minimum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the minimum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D12_FILTER_MINIMUM_MIN_MAG_MIP_LINEAR

Fetch the same set of texels as <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ne-d3d12-d3d12_filter">D3D12_FILTER_MIN_MAG_MIP_LINEAR</a> and instead of filtering them return the minimum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the minimum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D12_FILTER_MINIMUM_ANISOTROPIC

Fetch the same set of texels as <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ne-d3d12-d3d12_filter">D3D12_FILTER_ANISOTROPIC</a> and instead of filtering them return the minimum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the minimum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D12_FILTER_MAXIMUM_MIN_MAG_MIP_POINT

Fetch the same set of texels as <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ne-d3d12-d3d12_filter">D3D12_FILTER_MIN_MAG_MIP_POINT</a> and instead of filtering them return the maximum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the maximum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D12_FILTER_MAXIMUM_MIN_MAG_POINT_MIP_LINEAR

Fetch the same set of texels as <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ne-d3d12-d3d12_filter">D3D12_FILTER_MIN_MAG_POINT_MIP_LINEAR</a> and instead of filtering them return the maximum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the maximum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D12_FILTER_MAXIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT

Fetch the same set of texels as <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ne-d3d12-d3d12_filter">D3D12_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT</a> and instead of filtering them return the maximum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the maximum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D12_FILTER_MAXIMUM_MIN_POINT_MAG_MIP_LINEAR

Fetch the same set of texels as <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ne-d3d12-d3d12_filter">D3D12_FILTER_MIN_POINT_MAG_MIP_LINEAR</a> and instead of filtering them return the maximum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the maximum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D12_FILTER_MAXIMUM_MIN_LINEAR_MAG_MIP_POINT

Fetch the same set of texels as <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ne-d3d12-d3d12_filter">D3D12_FILTER_MIN_LINEAR_MAG_MIP_POINT</a> and instead of filtering them return the maximum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the maximum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D12_FILTER_MAXIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR

Fetch the same set of texels as <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ne-d3d12-d3d12_filter">D3D12_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR</a> and instead of filtering them return the maximum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the maximum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D12_FILTER_MAXIMUM_MIN_MAG_LINEAR_MIP_POINT

Fetch the same set of texels as <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ne-d3d12-d3d12_filter">D3D12_FILTER_MIN_MAG_LINEAR_MIP_POINT</a> and instead of filtering them return the maximum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the maximum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D12_FILTER_MAXIMUM_MIN_MAG_MIP_LINEAR

Fetch the same set of texels as <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ne-d3d12-d3d12_filter">D3D12_FILTER_MIN_MAG_MIP_LINEAR</a> and instead of filtering them return the maximum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the maximum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


### -field D3D12_FILTER_MAXIMUM_ANISOTROPIC

Fetch the same set of texels as <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ne-d3d12-d3d12_filter">D3D12_FILTER_ANISOTROPIC</a> and instead of filtering them return the maximum of the texels.  Texels that are weighted 0 during filtering aren't counted towards the maximum.  You can query support for this filter type from the <b>MinMaxFiltering</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/ns-d3d11-d3d11_feature_data_d3d11_options1">D3D11_FEATURE_DATA_D3D11_OPTIONS1</a> structure.


## -remarks



This enum is used by the <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ns-d3d12-d3d12_sampler_desc">D3D12_SAMPLER_DESC</a> structure.

<div class="alert"><b>Note</b>  If you use different filter types for min versus mag filter, undefined behavior occurs in certain cases where the choice between whether magnification or minification happens is ambiguous.  To prevent this undefined behavior, use filter modes that use similar filter operations for both min and mag (or use anisotropic filtering, which avoids the issue as well).</div>
<div> </div>
During texture sampling, one or more texels are read and combined (this is calling filtering) to produce a single value. Point sampling reads a single texel while linear sampling reads two texels (endpoints) and linearly interpolates a third value between the endpoints.

Microsoft High Level Shader Language (HLSL) texture-sampling functions also support comparison filtering during texture sampling. Comparison filtering compares each sampled texel against a comparison value. The boolean result is blended the same way that normal texture filtering is blended.

You can use HLSL intrinsic texture-sampling functions that implement texture filtering only or companion functions that use texture filtering with comparison filtering.

Also note the following defines:

<pre class="syntax" xml:space="preserve"><code>#define	D3D12_FILTER_REDUCTION_TYPE_MASK	( 0x3 )

#define	D3D12_FILTER_REDUCTION_TYPE_SHIFT	( 7 )

#define	D3D12_FILTER_TYPE_MASK	( 0x3 )

#define	D3D12_MIN_FILTER_SHIFT	( 4 )

#define	D3D12_MAG_FILTER_SHIFT	( 2 )

#define	D3D12_MIP_FILTER_SHIFT	( 0 )

#define	D3D12_ANISOTROPIC_FILTERING_BIT	( 0x40 )

#define D3D12_ENCODE_BASIC_FILTER( min, mag, mip, reduction )                                                     \
                                   ( ( D3D12_FILTER ) (                                                           \
                                   ( ( ( min ) &amp; D3D12_FILTER_TYPE_MASK ) &lt;&lt; D3D12_MIN_FILTER_SHIFT ) |           \
                                   ( ( ( mag ) &amp; D3D12_FILTER_TYPE_MASK ) &lt;&lt; D3D12_MAG_FILTER_SHIFT ) |           \
                                   ( ( ( mip ) &amp; D3D12_FILTER_TYPE_MASK ) &lt;&lt; D3D12_MIP_FILTER_SHIFT ) |           \
                                   ( ( ( reduction ) &amp; D3D12_FILTER_REDUCTION_TYPE_MASK ) &lt;&lt; D3D12_FILTER_REDUCTION_TYPE_SHIFT ) ) ) 
#define D3D12_ENCODE_ANISOTROPIC_FILTER( reduction )                                                  \
                                         ( ( D3D12_FILTER ) (                                         \
                                         D3D12_ANISOTROPIC_FILTERING_BIT |                            \
                                         D3D12_ENCODE_BASIC_FILTER( D3D12_FILTER_TYPE_LINEAR,         \
                                                                    D3D12_FILTER_TYPE_LINEAR,         \
                                                                    D3D12_FILTER_TYPE_LINEAR,         \
                                                                    reduction ) ) )                     
#define D3D12_DECODE_MIN_FILTER( D3D12Filter )                                                              \
                                 ( ( D3D12_FILTER_TYPE )                                                    \
                                 ( ( ( D3D12Filter ) &gt;&gt; D3D12_MIN_FILTER_SHIFT ) &amp; D3D12_FILTER_TYPE_MASK ) ) 
#define D3D12_DECODE_MAG_FILTER( D3D12Filter )                                                              \
                                 ( ( D3D12_FILTER_TYPE )                                                    \
                                 ( ( ( D3D12Filter ) &gt;&gt; D3D12_MAG_FILTER_SHIFT ) &amp; D3D12_FILTER_TYPE_MASK ) ) 
#define D3D12_DECODE_MIP_FILTER( D3D12Filter )                                                              \
                                 ( ( D3D12_FILTER_TYPE )                                                    \
                                 ( ( ( D3D12Filter ) &gt;&gt; D3D12_MIP_FILTER_SHIFT ) &amp; D3D12_FILTER_TYPE_MASK ) ) 
#define D3D12_DECODE_FILTER_REDUCTION( D3D12Filter )                                                        \
                                 ( ( D3D12_FILTER_REDUCTION_TYPE )                                                      \
                                 ( ( ( D3D12Filter ) &gt;&gt; D3D12_FILTER_REDUCTION_TYPE_SHIFT ) &amp; D3D12_FILTER_REDUCTION_TYPE_MASK ) ) 
#define D3D12_DECODE_IS_COMPARISON_FILTER( D3D12Filter )                                                    \
                                 ( D3D12_DECODE_FILTER_REDUCTION( D3D12Filter ) == D3D12_FILTER_REDUCTION_TYPE_COMPARISON ) 
#define D3D12_DECODE_IS_ANISOTROPIC_FILTER( D3D12Filter )                                               \
                            ( ( ( D3D12Filter ) &amp; D3D12_ANISOTROPIC_FILTERING_BIT ) &amp;&amp;                  \
                            ( D3D12_FILTER_TYPE_LINEAR == D3D12_DECODE_MIN_FILTER( D3D12Filter ) ) &amp;&amp;   \
                            ( D3D12_FILTER_TYPE_LINEAR == D3D12_DECODE_MAG_FILTER( D3D12Filter ) ) &amp;&amp;   \
                            ( D3D12_FILTER_TYPE_LINEAR == D3D12_DECODE_MIP_FILTER( D3D12Filter ) ) )    

</code></pre>
<table>
<tr>
<th>Texture Sampling Function</th>
<th>Texture Sampling Function with Comparison Filtering</th>
</tr>
<tr>
<td>
<a href="https://docs.microsoft.com/windows/desktop/direct3dhlsl/dx-graphics-hlsl-to-sample">Sample</a>
</td>
<td>
<a href="https://docs.microsoft.com/windows/desktop/direct3dhlsl/dx-graphics-hlsl-to-samplecmp">SampleCmp</a> or <a href="https://docs.microsoft.com/windows/desktop/direct3dhlsl/dx-graphics-hlsl-to-samplecmplevelzero">SampleCmpLevelZero</a>
</td>
</tr>
</table>
 

Comparison filters only work with textures that have the following formats: <a href="https://docs.microsoft.com/windows/desktop/api/dxgiformat/ne-dxgiformat-dxgi_format">DXGI_FORMAT_R32_FLOAT_X8X24_TYPELESS</a>, <a href="https://docs.microsoft.com/windows/desktop/api/dxgiformat/ne-dxgiformat-dxgi_format">DXGI_FORMAT_R32_FLOAT</a>, <a href="https://docs.microsoft.com/windows/desktop/api/dxgiformat/ne-dxgiformat-dxgi_format">DXGI_FORMAT_R24_UNORM_X8_TYPELESS</a>, <a href="https://docs.microsoft.com/windows/desktop/api/dxgiformat/ne-dxgiformat-dxgi_format">DXGI_FORMAT_R16_UNORM</a>.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d12/direct3d-12-enumerations">Core Enumerations</a>



<a href="https://docs.microsoft.com/windows/desktop/direct3d12/descriptors">Descriptors</a>
 

 

