---
UID: NE:d3d12.D3D12_PIPELINE_STATE_SUBOBJECT_TYPE
title: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE (d3d12.h)
description: Specifies the type of a sub-object in a pipeline state stream description.
old-location: direct3d12\d3d12_pipeline_state_subobject_type.htm
tech.root: direct3d12
ms.assetid: A066F574-8D8F-467C-98C1-21FE619FD901
ms.date: 12/05/2018
ms.keywords: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE enumeration, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_BLEND, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_CACHED_PSO, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_CS, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL1, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL_FORMAT, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DS, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_FLAGS, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_GS, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_HS, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_IB_STRIP_CUT_VALUE, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_INPUT_LAYOUT, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_MAX_VALID, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_NODE_MASK, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_PRIMITIVE_TOPOLOGY, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_PS, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_RASTERIZER, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_RENDER_TARGET_FORMATS, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_ROOT_SIGNATURE, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_SAMPLE_DESC, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_SAMPLE_MASK, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_STREAM_OUTPUT, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_VIEW_INSTANCING, D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_VS, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_BLEND, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_CACHED_PSO, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_CS, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL1, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL_FORMAT, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DS, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_FLAGS, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_GS, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_HS, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_IB_STRIP_CUT_VALUE, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_INPUT_LAYOUT, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_MAX_VALID, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_NODE_MASK, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_PRIMITIVE_TOPOLOGY, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_PS, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_RASTERIZER, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_RENDER_TARGET_FORMATS, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_ROOT_SIGNATURE, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_SAMPLE_DESC, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_SAMPLE_MASK, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_STREAM_OUTPUT, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_VIEW_INSTANCING, d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_VS, direct3d12.d3d12_pipeline_state_subobject_type
f1_keywords:
- d3d12/D3D12_PIPELINE_STATE_SUBOBJECT_TYPE
dev_langs:
- c++
req.header: d3d12.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- d3d12.h
api_name:
- D3D12_PIPELINE_STATE_SUBOBJECT_TYPE
targetos: Windows
req.typenames: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE
req.redist: 
ms.custom: 19H1
---

# D3D12_PIPELINE_STATE_SUBOBJECT_TYPE enumeration


## -description


Specifies the type of a sub-object in a pipeline state stream description.


## -enum-fields




### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_ROOT_SIGNATURE

Indicates a root signature subobject type.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_VS

Indicates a vertex shader subobject type.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_PS

Indicates a pixel shader subobject type.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DS

Indicates a domain shader subobject type.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_HS

Indicates a hull shader subobject type.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_GS

Indicates a geometry shader subobject type.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_CS

Indicates a compute shader subobject type.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_STREAM_OUTPUT

Indicates a stream-output subobject type.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_BLEND

Indicates a blend subobject type.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_SAMPLE_MASK

Indicates a sample mask subobject type.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_RASTERIZER

Indicates indicates a rasterizer subobject type.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL

Indicates a depth stencil subobject type.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_INPUT_LAYOUT

Indicates an input layout subobject type.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_IB_STRIP_CUT_VALUE

Indicates an index buffer strip cut value subobject type.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_PRIMITIVE_TOPOLOGY

Indicates a primitive topology subobject type.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_RENDER_TARGET_FORMATS

Indicates a render target formats subobject type. This subobject type corresponds to the D3D12_RT_FORMAT_ARRAY structure, which wraps an array of render target formats along with a count of the array elements.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL_FORMAT

Indicates a depth stencil format subobject.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_SAMPLE_DESC

Indicates a sample description subobject type.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_NODE_MASK

Indicates a node mask subobject type.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_CACHED_PSO

Indicates a cached pipeline state object subobject type.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_FLAGS

Indicates a flags subobject type.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL1

Indicates an expanded depth stencil subobject type. This expansion of the depth stencil subobject supports optional depth bounds checking.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_VIEW_INSTANCING

Indicates a view instancing subobject type.


### -field D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_MAX_VALID

A sentinal value that marks the exclusive upper-bound of valid values this enumeration represents.


## -remarks



This enum is used in the creation of pipeline state objects using the ID3D12Device1::CreatePipelineState method. The CreatePipelineState method takes a D3D12_PIPELINE_STATE_STREAM_DESC as one of its parameters, this structure in turn describes a bytestream made up of alternating D3D12_PIPELINE_STATE_SUBOBJECT_TYPE enumeration values and their corresponding subobject description structs. This bytestream description can be made a concrete type by defining a structure that has the same alternating pattern of alternating D3D12_PIPELINE_STATE_SUBOBJECT_TYPE enumeration values and their corresponding subobject description structs as members.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d12/direct3d-12-enumerations">Core Enumerations</a>
 

 

