---
UID: NE:d3d12.D3D12_RESOURCE_BINDING_TIER
title: D3D12_RESOURCE_BINDING_TIER (d3d12.h)
description: Identifies the tier of resource binding being used.
old-location: direct3d12\d3d12_resource_binding_tier.htm
tech.root: direct3d12
ms.assetid: D09EB3C3-9FE6-416C-91C5-E04C869C757D
ms.date: 12/05/2018
ms.keywords: D3D12_RESOURCE_BINDING_TIER, D3D12_RESOURCE_BINDING_TIER enumeration, D3D12_RESOURCE_BINDING_TIER_1, D3D12_RESOURCE_BINDING_TIER_2, D3D12_RESOURCE_BINDING_TIER_3, d3d12/D3D12_RESOURCE_BINDING_TIER, d3d12/D3D12_RESOURCE_BINDING_TIER_1, d3d12/D3D12_RESOURCE_BINDING_TIER_2, d3d12/D3D12_RESOURCE_BINDING_TIER_3, direct3d12.d3d12_resource_binding_tier
f1_keywords:
- d3d12/D3D12_RESOURCE_BINDING_TIER
dev_langs:
- c++
req.header: d3d12.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- D3D12.h
api_name:
- D3D12_RESOURCE_BINDING_TIER
targetos: Windows
req.typenames: D3D12_RESOURCE_BINDING_TIER
req.redist: 
ms.custom: 19H1
---

# D3D12_RESOURCE_BINDING_TIER enumeration


## -description


Identifies the tier of resource binding being used.
        


## -enum-fields




### -field D3D12_RESOURCE_BINDING_TIER_1

Tier 1.
            See <a href="https://docs.microsoft.com/windows/desktop/direct3d12/hardware-support">Hardware Tiers</a>.
          


### -field D3D12_RESOURCE_BINDING_TIER_2

Tier 2.
            See <a href="https://docs.microsoft.com/windows/desktop/direct3d12/hardware-support">Hardware Tiers</a>.
          


### -field D3D12_RESOURCE_BINDING_TIER_3

Tier 3.
            See <a href="https://docs.microsoft.com/windows/desktop/direct3d12/hardware-support">Hardware Tiers</a>.
          


## -remarks



This enum is used by the <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/ns-d3d12-d3d12_feature_data_d3d12_options">D3D12_FEATURE_DATA_D3D12_OPTIONS</a> structure.
      




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d12/direct3d-12-enumerations">Core Enumerations</a>



<a href="https://docs.microsoft.com/windows/desktop/direct3d12/hardware-support">Hardware Tiers</a>
 

 

