---
UID: NF:d3d12.ID3D12GraphicsCommandList1.OMSetDepthBounds
title: ID3D12GraphicsCommandList1::OMSetDepthBounds (d3d12.h)
description: This method enables you to change the depth bounds dynamically.
old-location: direct3d12\id3d12graphicscommandlist1_omsetdepthbounds.htm
tech.root: direct3d12
ms.assetid: 065DBAD3-F4B6-4C94-BA0E-821A46E0B2EE
ms.date: 12/05/2018
ms.keywords: ID3D12GraphicsCommandList1 interface,OMSetDepthBounds method, ID3D12GraphicsCommandList1.OMSetDepthBounds, ID3D12GraphicsCommandList1::OMSetDepthBounds, OMSetDepthBounds, OMSetDepthBounds method, OMSetDepthBounds method,ID3D12GraphicsCommandList1 interface, d3d12/ID3D12GraphicsCommandList1::OMSetDepthBounds, direct3d12.id3d12graphicscommandlist1_omsetdepthbounds
f1_keywords:
- d3d12/ID3D12GraphicsCommandList1.OMSetDepthBounds
dev_langs:
- c++
req.header: d3d12.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: D3d12.lib
req.dll: D3d12.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- d3d12.dll
api_name:
- ID3D12GraphicsCommandList1.OMSetDepthBounds
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# ID3D12GraphicsCommandList1::OMSetDepthBounds

## -description

This method enables you to change the depth bounds dynamically.

## -parameters

### -param Min [in]

Type: <b>FLOAT</b>

<a href="https://docs.microsoft.com/visualstudio/code-quality/annotating-function-parameters-and-return-values?view=vs-2015">SAL</a>: <code>_In_</code>

Specifies the minimum depth bounds. The default value is 0. NaN values silently convert to 0.

### -param Max [in]

Type: <b>FLOAT</b>

<a href="https://docs.microsoft.com/visualstudio/code-quality/annotating-function-parameters-and-return-values?view=vs-2015">SAL</a>: <code>_In_</code>

Specifies the maximum depth bounds. The default value is 1. NaN values silently convert to 0.

## -returns

This method does not return a value.

## -remarks

Depth-bounds testing allows pixels and samples to be discarded if the currently-stored depth value is outside the range specified by <i>Min</i> and <i>Max</i>, inclusive. If the currently-stored depth value of the pixel or sample is inside this range, then the depth-bounds test passes and it is rendered; otherwise, the depth-bounds test fails and the pixel or sample is discarded. Note that the depth-bounds test considers the currently-stored depth value, not the depth value generated by the executing pixel shader.

To use depth-bounds testing, the application must use the new <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/nf-d3d12-id3d12device2-createpipelinestate">CreatePipelineState</a> method to enable depth-bounds testing on the PSO and then can use this command list method to change the depth-bounds dynamically.

OMSetDepthBounds is an optional feature. Use the <a href="https://docs.microsoft.com/windows/desktop/api/d3d12/nf-d3d12-id3d12device-checkfeaturesupport">CheckFeatureSupport</a> method to determine whether or not this feature is supported by the user-mode driver. Support for this feature is reported through the [D3D12_FEATURE_D3D12_OPTIONS1](/windows/win32/api/d3d12/ne-d3d12-d3d12_feature) structure.

## -see-also

<a href="https://docs.microsoft.com/windows/desktop/api/d3d12/nn-d3d12-id3d12graphicscommandlist1">ID3D12GraphicsCommandList1</a>
