---
UID: NS:d3d12shader._D3D12_SHADER_TYPE_DESC
title: D3D12_SHADER_TYPE_DESC (d3d12shader.h)
description: Describes a shader-variable type.
old-location: direct3d12\d3d12_shader_type_desc.htm
tech.root: direct3d12
ms.assetid: B0AF7987-B25B-4496-9B8F-1D9C16DF5E50
ms.date: 12/05/2018
ms.keywords: D3D12_SHADER_TYPE_DESC, D3D12_SHADER_TYPE_DESC structure, d3d12shader/D3D12_SHADER_TYPE_DESC, direct3d12.d3d12_shader_type_desc
f1_keywords:
- d3d12shader/D3D12_SHADER_TYPE_DESC
dev_langs:
- c++
req.header: d3d12shader.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- d3d12shader.h
api_name:
- D3D12_SHADER_TYPE_DESC
targetos: Windows
req.typenames: D3D12_SHADER_TYPE_DESC
req.redist: 
ms.custom: 19H1
---

# D3D12_SHADER_TYPE_DESC structure


## -description


Describes a shader-variable type.
        


## -struct-fields




### -field Class

A <a href="https://docs.microsoft.com/windows/desktop/api/d3dcommon/ne-d3dcommon-d3d_shader_variable_class">D3D_SHADER_VARIABLE_CLASS</a>-typed value that identifies the variable class as one of scalar, vector, matrix, object, and so on.
          


### -field Type

A <a href="https://docs.microsoft.com/windows/desktop/api/d3dcommon/ne-d3dcommon-d3d_shader_variable_type">D3D_SHADER_VARIABLE_TYPE</a>-typed value that identifies the variable type.
          


### -field Rows

Number of rows in a matrix. Otherwise a numeric type returns 1, any other type returns 0.
          


### -field Columns

Number of columns in a matrix. Otherwise a numeric type returns 1, any other type returns 0.
          


### -field Elements

Number of elements in an array; otherwise 0.
          


### -field Members

Number of members in the structure; otherwise 0.
          


### -field Offset

Offset, in bytes, between the start of the parent structure and this variable. Can be 0 if not a structure member.
          


### -field Name

Name of the shader-variable type. This member can be <b>NULL</b> if it isn't used. This member supports dynamic shader linkage interface types, which have names. For more info about dynamic shader linkage, see <a href="https://docs.microsoft.com/windows/desktop/direct3dhlsl/overviews-direct3d-11-hlsl-dynamic-linking">Dynamic Linking</a>.
          


## -remarks



Get a shader-variable-type description by calling <a href="https://docs.microsoft.com/windows/desktop/api/d3d12shader/nf-d3d12shader-id3d12shaderreflectiontype-getdesc">ID3D12ShaderReflectionType::GetDesc</a>.
      




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d12/d3d12-graphics-reference-shader-structures">Shader Structures</a>
 

 

