---
UID: NE:d3dcommon.D3D_NAME
title: D3D_NAME (d3dcommon.h)
description: Values that identify shader parameters that use system-value semantics.
old-location: direct3d11\d3d_name.htm
tech.root: direct3d11
ms.assetid: 16675331-36cf-4086-a753-6d80ee934ace
ms.date: 12/05/2018
ms.keywords: D3D10_NAME_CLIP_DISTANCE, D3D10_NAME_COVERAGE, D3D10_NAME_CULL_DISTANCE, D3D10_NAME_DEPTH, D3D10_NAME_INSTANCE_ID, D3D10_NAME_IS_FRONT_FACE, D3D10_NAME_POSITION, D3D10_NAME_PRIMITIVE_ID, D3D10_NAME_RENDER_TARGET_ARRAY_INDEX, D3D10_NAME_SAMPLE_INDEX, D3D10_NAME_TARGET, D3D10_NAME_UNDEFINED, D3D10_NAME_VERTEX_ID, D3D10_NAME_VIEWPORT_ARRAY_INDEX, D3D11_NAME_DEPTH_GREATER_EQUAL, D3D11_NAME_DEPTH_LESS_EQUAL, D3D11_NAME_FINAL_LINE_DENSITY_TESSFACTOR, D3D11_NAME_FINAL_LINE_DETAIL_TESSFACTOR, D3D11_NAME_FINAL_QUAD_EDGE_TESSFACTOR, D3D11_NAME_FINAL_QUAD_INSIDE_TESSFACTOR, D3D11_NAME_FINAL_TRI_EDGE_TESSFACTOR, D3D11_NAME_FINAL_TRI_INSIDE_TESSFACTOR, D3D11_NAME_INNER_COVERAGE, D3D11_NAME_STENCIL_REF, D3D12_NAME_BARYCENTRICS, D3D_NAME, D3D_NAME enumeration [Direct3D 11], D3D_NAME_BARYCENTRICS, D3D_NAME_CLIP_DISTANCE, D3D_NAME_COVERAGE, D3D_NAME_CULL_DISTANCE, D3D_NAME_DEPTH, D3D_NAME_DEPTH_GREATER_EQUAL, D3D_NAME_DEPTH_LESS_EQUAL, D3D_NAME_FINAL_LINE_DENSITY_TESSFACTOR, D3D_NAME_FINAL_LINE_DETAIL_TESSFACTOR, D3D_NAME_FINAL_QUAD_EDGE_TESSFACTOR, D3D_NAME_FINAL_QUAD_INSIDE_TESSFACTOR, D3D_NAME_FINAL_TRI_EDGE_TESSFACTOR, D3D_NAME_FINAL_TRI_INSIDE_TESSFACTOR, D3D_NAME_INNER_COVERAGE, D3D_NAME_INSTANCE_ID, D3D_NAME_IS_FRONT_FACE, D3D_NAME_POSITION, D3D_NAME_PRIMITIVE_ID, D3D_NAME_RENDER_TARGET_ARRAY_INDEX, D3D_NAME_SAMPLE_INDEX, D3D_NAME_STENCIL_REF, D3D_NAME_TARGET, D3D_NAME_UNDEFINED, D3D_NAME_VERTEX_ID, D3D_NAME_VIEWPORT_ARRAY_INDEX, d3dcommon/D3D10_NAME_CLIP_DISTANCE, d3dcommon/D3D10_NAME_COVERAGE, d3dcommon/D3D10_NAME_CULL_DISTANCE, d3dcommon/D3D10_NAME_DEPTH, d3dcommon/D3D10_NAME_INSTANCE_ID, d3dcommon/D3D10_NAME_IS_FRONT_FACE, d3dcommon/D3D10_NAME_POSITION, d3dcommon/D3D10_NAME_PRIMITIVE_ID, d3dcommon/D3D10_NAME_RENDER_TARGET_ARRAY_INDEX, d3dcommon/D3D10_NAME_SAMPLE_INDEX, d3dcommon/D3D10_NAME_TARGET, d3dcommon/D3D10_NAME_UNDEFINED, d3dcommon/D3D10_NAME_VERTEX_ID, d3dcommon/D3D10_NAME_VIEWPORT_ARRAY_INDEX, d3dcommon/D3D11_NAME_DEPTH_GREATER_EQUAL, d3dcommon/D3D11_NAME_DEPTH_LESS_EQUAL, d3dcommon/D3D11_NAME_FINAL_LINE_DENSITY_TESSFACTOR, d3dcommon/D3D11_NAME_FINAL_LINE_DETAIL_TESSFACTOR, d3dcommon/D3D11_NAME_FINAL_QUAD_EDGE_TESSFACTOR, d3dcommon/D3D11_NAME_FINAL_QUAD_INSIDE_TESSFACTOR, d3dcommon/D3D11_NAME_FINAL_TRI_EDGE_TESSFACTOR, d3dcommon/D3D11_NAME_FINAL_TRI_INSIDE_TESSFACTOR, d3dcommon/D3D11_NAME_INNER_COVERAGE, d3dcommon/D3D11_NAME_STENCIL_REF, d3dcommon/D3D12_NAME_BARYCENTRICS, d3dcommon/D3D_NAME, d3dcommon/D3D_NAME_BARYCENTRICS, d3dcommon/D3D_NAME_CLIP_DISTANCE, d3dcommon/D3D_NAME_COVERAGE, d3dcommon/D3D_NAME_CULL_DISTANCE, d3dcommon/D3D_NAME_DEPTH, d3dcommon/D3D_NAME_DEPTH_GREATER_EQUAL, d3dcommon/D3D_NAME_DEPTH_LESS_EQUAL, d3dcommon/D3D_NAME_FINAL_LINE_DENSITY_TESSFACTOR, d3dcommon/D3D_NAME_FINAL_LINE_DETAIL_TESSFACTOR, d3dcommon/D3D_NAME_FINAL_QUAD_EDGE_TESSFACTOR, d3dcommon/D3D_NAME_FINAL_QUAD_INSIDE_TESSFACTOR, d3dcommon/D3D_NAME_FINAL_TRI_EDGE_TESSFACTOR, d3dcommon/D3D_NAME_FINAL_TRI_INSIDE_TESSFACTOR, d3dcommon/D3D_NAME_INNER_COVERAGE, d3dcommon/D3D_NAME_INSTANCE_ID, d3dcommon/D3D_NAME_IS_FRONT_FACE, d3dcommon/D3D_NAME_POSITION, d3dcommon/D3D_NAME_PRIMITIVE_ID, d3dcommon/D3D_NAME_RENDER_TARGET_ARRAY_INDEX, d3dcommon/D3D_NAME_SAMPLE_INDEX, d3dcommon/D3D_NAME_STENCIL_REF, d3dcommon/D3D_NAME_TARGET, d3dcommon/D3D_NAME_UNDEFINED, d3dcommon/D3D_NAME_VERTEX_ID, d3dcommon/D3D_NAME_VIEWPORT_ARRAY_INDEX, direct3d11.d3d_name
f1_keywords:
- d3dcommon/D3D_NAME
dev_langs:
- c++
req.header: d3dcommon.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- D3DCommon.h
api_name:
- D3D_NAME
targetos: Windows
req.typenames: D3D_NAME
req.redist: 
ms.custom: 19H1
---

# D3D_NAME enumeration


## -description


Values that identify shader parameters that use system-value semantics.


## -enum-fields




### -field D3D_NAME_UNDEFINED

This parameter does not use a predefined system-value semantic.


### -field D3D_NAME_POSITION

This parameter contains position data.


### -field D3D_NAME_CLIP_DISTANCE

This parameter contains clip-distance data.


### -field D3D_NAME_CULL_DISTANCE

This parameter contains cull-distance data.


### -field D3D_NAME_RENDER_TARGET_ARRAY_INDEX

This parameter contains a render-target-array index.


### -field D3D_NAME_VIEWPORT_ARRAY_INDEX

This parameter contains a viewport-array index.


### -field D3D_NAME_VERTEX_ID

This parameter contains a vertex ID.


### -field D3D_NAME_PRIMITIVE_ID

This parameter contains a primitive ID.


### -field D3D_NAME_INSTANCE_ID

This parameter contains an instance ID.


### -field D3D_NAME_IS_FRONT_FACE

This parameter contains data that identifies whether or not the primitive faces the camera.


### -field D3D_NAME_SAMPLE_INDEX

This parameter contains a sampler-array index.


### -field D3D_NAME_FINAL_QUAD_EDGE_TESSFACTOR

This parameter contains one of four tessellation factors that correspond to the amount of parts that a quad patch is broken into along the given edge. This flag is used to tessellate a quad patch.


### -field D3D_NAME_FINAL_QUAD_INSIDE_TESSFACTOR

This parameter contains one of two tessellation factors that correspond to the amount of parts that a quad patch is broken into vertically and horizontally within the patch. This flag is used to tessellate a quad patch.


### -field D3D_NAME_FINAL_TRI_EDGE_TESSFACTOR

This parameter contains one of three tessellation factors that correspond to the amount of parts that a tri patch is broken into along the given edge. This flag is used to tessellate a tri patch.


### -field D3D_NAME_FINAL_TRI_INSIDE_TESSFACTOR

This parameter contains the tessellation factor that corresponds to the amount of parts that a tri patch is broken into within the patch. This flag is used to tessellate a tri patch.


### -field D3D_NAME_FINAL_LINE_DETAIL_TESSFACTOR

This parameter contains the tessellation factor that corresponds to the number of lines broken into within the patch. This flag is used to tessellate an isolines patch.


### -field D3D_NAME_FINAL_LINE_DENSITY_TESSFACTOR

This parameter contains the tessellation factor that corresponds to the number of lines that are created within the patch. This flag is used to tessellate an isolines patch.


### -field D3D_NAME_BARYCENTRICS

This parameter contains barycentric coordinate data.


### -field D3D_NAME_TARGET

This parameter contains render-target data.


### -field D3D_NAME_DEPTH

This parameter contains depth data.


### -field D3D_NAME_COVERAGE

This parameter contains alpha-coverage data.


### -field D3D_NAME_DEPTH_GREATER_EQUAL

This parameter signifies that the value is greater than or equal to a reference value. This flag is used to specify conservative depth for a pixel shader.


### -field D3D_NAME_DEPTH_LESS_EQUAL

This parameter signifies that the value is less than or equal to a reference value. This flag is used to specify conservative depth for a pixel shader.


### -field D3D_NAME_STENCIL_REF

This parameter contains a stencil reference.
            See <a href="https://docs.microsoft.com/windows/desktop/direct3d11/shader-specified-stencil-reference-value">Shader Specified Stencil Reference Value</a>.
          


### -field D3D_NAME_INNER_COVERAGE

This parameter contains inner input coverage data.
            See <a href="https://docs.microsoft.com/windows/desktop/direct3d11/conservative-rasterization">Conservative Rasterization</a>.
          


### -field D3D10_NAME_UNDEFINED

This parameter does not use a predefined system-value semantic.


### -field D3D10_NAME_POSITION

This parameter contains position data.


### -field D3D10_NAME_CLIP_DISTANCE

This parameter contains clip-distance data.


### -field D3D10_NAME_CULL_DISTANCE

This parameter contains cull-distance data.


### -field D3D10_NAME_RENDER_TARGET_ARRAY_INDEX

This parameter contains a render-target-array index.


### -field D3D10_NAME_VIEWPORT_ARRAY_INDEX

This parameter contains a viewport-array index.


### -field D3D10_NAME_VERTEX_ID

This parameter contains a vertex ID.


### -field D3D10_NAME_PRIMITIVE_ID

This parameter contains a primitive ID.


### -field D3D10_NAME_INSTANCE_ID

This parameter contains a instance ID.


### -field D3D10_NAME_IS_FRONT_FACE

This parameter contains data that identifies whether or not the primitive faces the camera.


### -field D3D10_NAME_SAMPLE_INDEX

This parameter contains a sampler-array index.


### -field D3D10_NAME_TARGET

This parameter contains render-target data.


### -field D3D10_NAME_DEPTH

This parameter contains depth data.


### -field D3D10_NAME_COVERAGE

This parameter contains alpha-coverage data.


### -field D3D11_NAME_FINAL_QUAD_EDGE_TESSFACTOR

This parameter contains one of four tessellation factors that correspond to the amount of parts that a quad patch is broken into along the given edge. This flag is used to tessellate a quad patch.


### -field D3D11_NAME_FINAL_QUAD_INSIDE_TESSFACTOR

This parameter contains one of two tessellation factors that correspond to the amount of parts that a quad patch is broken into vertically and horizontally within the patch. This flag is used to tessellate a quad patch.


### -field D3D11_NAME_FINAL_TRI_EDGE_TESSFACTOR

This parameter contains one of three tessellation factors that correspond to the amount of parts that a tri patch is broken into along the given edge. This flag is used to tessellate a tri patch.


### -field D3D11_NAME_FINAL_TRI_INSIDE_TESSFACTOR

This parameter contains the tessellation factor that corresponds to the amount of parts that a tri patch is broken into within the patch. This flag is used to tessellate a tri patch.


### -field D3D11_NAME_FINAL_LINE_DETAIL_TESSFACTOR

This parameter contains the tessellation factor that corresponds to the amount of lines broken into within the patch. This flag is used to tessellate an isolines patch.


### -field D3D11_NAME_FINAL_LINE_DENSITY_TESSFACTOR

This parameter contains the tessellation factor that corresponds to the amount of lines that are created within the patch. This flag is used to tessellate an isolines patch.


### -field D3D11_NAME_DEPTH_GREATER_EQUAL

This parameter signifies that the value is greater than or equal to a reference value. This flag is used to specify conservative depth for a pixel shader.


### -field D3D11_NAME_DEPTH_LESS_EQUAL

This parameter signifies that the value is less than or equal to a reference value. This flag is used to specify conservative depth for a pixel shader.


### -field D3D11_NAME_STENCIL_REF

This parameter contains a stencil reference.
            See <a href="https://docs.microsoft.com/windows/desktop/direct3d11/shader-specified-stencil-reference-value">Shader Specified Stencil Reference Value</a>.
          


### -field D3D11_NAME_INNER_COVERAGE

This parameter contains inner input coverage data.
            See <a href="https://docs.microsoft.com/windows/desktop/direct3d11/conservative-rasterization">Conservative Rasterization</a>.
          


### -field D3D12_NAME_BARYCENTRICS

This parameter contains barycentric coordinate data.
          


## -remarks



The <b>D3D_NAME</b> values identify shader parameters that have <a href="https://docs.microsoft.com/windows/win32/api/d3d11shader/ns-d3d11shader-d3d11_signature_parameter_desc">predefined system-value</a> semantics. These values are used in a shader-signature description. For more information about shader-signature description, see <a href="https://docs.microsoft.com/windows/desktop/api/d3d11shader/ns-d3d11shader-d3d11_signature_parameter_desc">D3D11_SIGNATURE_PARAMETER_DESC</a>.
        




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d11/d3d11-graphics-reference-d3d11-common-enumerations">Common Version Enumerations</a>



<a href="https://docs.microsoft.com/windows/win32/api/d3d11shader/ns-d3d11shader-d3d11_signature_parameter_desc">D3D11_SIGNATURE_PARAMETER_DESC</a>
 

 

