---
UID: NE:d3dcommon.D3D_PRIMITIVE
title: D3D_PRIMITIVE (d3dcommon.h)
description: Indicates how the pipeline interprets geometry or hull shader input primitives.
old-location: direct3d11\d3d11_primitive.htm
tech.root: direct3d11
ms.assetid: 9e1b4d5a-c1d1-4535-b68e-b81253ef430a
ms.date: 12/05/2018
ms.keywords: 99cc5cf0-144a-fb34-6910-4f605a726d2c, D3D11_PRIMITIVE, D3D11_PRIMITIVE enumeration [Direct3D 11], D3D11_PRIMITIVE_10_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_11_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_12_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_13_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_14_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_15_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_16_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_17_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_18_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_19_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_1_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_20_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_21_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_22_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_23_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_24_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_25_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_26_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_27_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_28_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_29_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_2_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_30_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_31_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_32_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_3_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_4_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_5_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_6_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_7_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_8_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_9_CONTROL_POINT_PATCH, D3D11_PRIMITIVE_LINE, D3D11_PRIMITIVE_LINE_ADJ, D3D11_PRIMITIVE_POINT, D3D11_PRIMITIVE_TRIANGLE, D3D11_PRIMITIVE_TRIANGLE_ADJ, D3D11_PRIMITIVE_UNDEFINED, D3D_PRIMITIVE, d3d11/D3D11_PRIMITIVE, d3d11/D3D11_PRIMITIVE_10_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_11_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_12_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_13_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_14_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_15_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_16_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_17_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_18_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_19_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_1_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_20_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_21_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_22_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_23_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_24_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_25_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_26_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_27_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_28_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_29_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_2_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_30_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_31_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_32_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_3_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_4_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_5_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_6_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_7_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_8_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_9_CONTROL_POINT_PATCH, d3d11/D3D11_PRIMITIVE_LINE, d3d11/D3D11_PRIMITIVE_LINE_ADJ, d3d11/D3D11_PRIMITIVE_POINT, d3d11/D3D11_PRIMITIVE_TRIANGLE, d3d11/D3D11_PRIMITIVE_TRIANGLE_ADJ, d3d11/D3D11_PRIMITIVE_UNDEFINED, d3dcommon/D3D11_PRIMITIVE, d3dcommon/D3D11_PRIMITIVE_10_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_11_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_12_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_13_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_14_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_15_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_16_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_17_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_18_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_19_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_1_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_20_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_21_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_22_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_23_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_24_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_25_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_26_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_27_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_28_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_29_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_2_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_30_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_31_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_32_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_3_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_4_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_5_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_6_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_7_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_8_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_9_CONTROL_POINT_PATCH, d3dcommon/D3D11_PRIMITIVE_LINE, d3dcommon/D3D11_PRIMITIVE_LINE_ADJ, d3dcommon/D3D11_PRIMITIVE_POINT, d3dcommon/D3D11_PRIMITIVE_TRIANGLE, d3dcommon/D3D11_PRIMITIVE_TRIANGLE_ADJ, d3dcommon/D3D11_PRIMITIVE_UNDEFINED, direct3d11.d3d11_primitive
f1_keywords:
- d3dcommon/D3D11_PRIMITIVE
dev_langs:
- c++
req.header: d3dcommon.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- d3d11.h
- d3dcommon.h
api_name:
- D3D11_PRIMITIVE
targetos: Windows
req.typenames: D3D_PRIMITIVE
req.redist: 
ms.custom: 19H1
---

# D3D_PRIMITIVE enumeration


## -description


Indicates how the pipeline interprets geometry or hull shader input primitives.
      


## -enum-fields




### -field D3D_PRIMITIVE_UNDEFINED


### -field D3D_PRIMITIVE_POINT


### -field D3D_PRIMITIVE_LINE


### -field D3D_PRIMITIVE_TRIANGLE


### -field D3D_PRIMITIVE_LINE_ADJ


### -field D3D_PRIMITIVE_TRIANGLE_ADJ


### -field D3D_PRIMITIVE_1_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_2_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_3_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_4_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_5_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_6_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_7_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_8_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_9_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_10_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_11_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_12_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_13_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_14_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_15_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_16_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_17_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_18_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_19_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_20_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_21_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_22_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_23_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_24_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_25_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_26_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_27_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_28_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_29_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_30_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_31_CONTROL_POINT_PATCH


### -field D3D_PRIMITIVE_32_CONTROL_POINT_PATCH


### -field D3D10_PRIMITIVE_UNDEFINED


### -field D3D10_PRIMITIVE_POINT


### -field D3D10_PRIMITIVE_LINE


### -field D3D10_PRIMITIVE_TRIANGLE


### -field D3D10_PRIMITIVE_LINE_ADJ


### -field D3D10_PRIMITIVE_TRIANGLE_ADJ


### -field D3D11_PRIMITIVE_UNDEFINED

The shader has not been initialized with an input primitive type.
          


### -field D3D11_PRIMITIVE_POINT

Interpret the input primitive as a point.
          


### -field D3D11_PRIMITIVE_LINE

Interpret the input primitive as a line.
          


### -field D3D11_PRIMITIVE_TRIANGLE

Interpret the input primitive as a triangle.
          


### -field D3D11_PRIMITIVE_LINE_ADJ

Interpret the input primitive as a line with adjacency data.
          


### -field D3D11_PRIMITIVE_TRIANGLE_ADJ

Interpret the input primitive as a triangle with adjacency data.
          


### -field D3D11_PRIMITIVE_1_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_2_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_3_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_4_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_5_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_6_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_7_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_8_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_9_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_10_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_11_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_12_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_13_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_14_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_15_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_16_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_17_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_18_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_19_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_20_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_21_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_22_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_23_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_24_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_25_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_26_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_27_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_28_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_29_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_30_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_31_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


### -field D3D11_PRIMITIVE_32_CONTROL_POINT_PATCH

Interpret the input primitive as a control point patch.
          


## -remarks



The <a href="https://docs.microsoft.com/windows/desktop/api/d3d11shader/nf-d3d11shader-id3d11shaderreflection-getgsinputprimitive">ID3D11ShaderReflection::GetGSInputPrimitive</a> method returns a
          <b>D3D11_PRIMITIVE</b>-typed value.
        

The <b>D3D11_PRIMITIVE</b> enumeration is type defined in the D3D11.h header file as a
          <a href="https://docs.microsoft.com/windows/desktop/api/d3dcommon/ne-d3dcommon-d3d_primitive">D3D_PRIMITIVE</a> enumeration, which is fully defined in the D3DCommon.h header file.
        


```
typedef D3D_PRIMITIVE D3D11_PRIMITIVE;
```





## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d11/d3d11-graphics-reference-d3d11-core-enums">Core Enumerations</a>
 

 

