---
UID: NE:d3dcommon.D3D_PRIMITIVE_TOPOLOGY
title: D3D_PRIMITIVE_TOPOLOGY (d3dcommon.h)
description: Values that indicate how the pipeline interprets vertex data that is bound to the input-assembler stage. These primitive topology values determine how the vertex data is rendered on screen.
old-location: direct3d11\d3d_primitive_topology.htm
tech.root: direct3d11
ms.assetid: b4becdcc-cc19-4d5a-940b-b232ebedce68
ms.date: 12/05/2018
ms.keywords: D3D10_PRIMITIVE_TOPOLOGY_LINELIST, D3D10_PRIMITIVE_TOPOLOGY_LINELIST_ADJ, D3D10_PRIMITIVE_TOPOLOGY_LINESTRIP, D3D10_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ, D3D10_PRIMITIVE_TOPOLOGY_POINTLIST, D3D10_PRIMITIVE_TOPOLOGY_TRIANGLELIST, D3D10_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ, D3D10_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP, D3D10_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ, D3D10_PRIMITIVE_TOPOLOGY_UNDEFINED, D3D11_PRIMITIVE_TOPOLOGY_10_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_11_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_12_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_13_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_14_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_15_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_16_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_17_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_18_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_19_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_1_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_20_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_21_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_22_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_23_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_24_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_25_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_26_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_27_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_28_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_29_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_2_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_30_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_31_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_32_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_3_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_4_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_5_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_6_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_7_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_8_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_9_CONTROL_POINT_PATCHLIST, D3D11_PRIMITIVE_TOPOLOGY_LINELIST, D3D11_PRIMITIVE_TOPOLOGY_LINELIST_ADJ, D3D11_PRIMITIVE_TOPOLOGY_LINESTRIP, D3D11_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ, D3D11_PRIMITIVE_TOPOLOGY_POINTLIST, D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST, D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ, D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP, D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ, D3D11_PRIMITIVE_TOPOLOGY_UNDEFINED, D3D_PRIMITIVE_TOPOLOGY, D3D_PRIMITIVE_TOPOLOGY enumeration [Direct3D 11], D3D_PRIMITIVE_TOPOLOGY_10_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_11_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_12_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_13_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_14_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_15_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_16_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_17_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_18_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_19_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_1_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_20_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_21_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_22_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_23_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_24_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_25_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_26_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_27_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_28_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_29_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_2_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_30_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_31_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_32_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_3_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_4_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_5_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_6_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_7_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_8_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_9_CONTROL_POINT_PATCHLIST, D3D_PRIMITIVE_TOPOLOGY_LINELIST, D3D_PRIMITIVE_TOPOLOGY_LINELIST_ADJ, D3D_PRIMITIVE_TOPOLOGY_LINESTRIP, D3D_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ, D3D_PRIMITIVE_TOPOLOGY_POINTLIST, D3D_PRIMITIVE_TOPOLOGY_TRIANGLELIST, D3D_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ, D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP, D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ, D3D_PRIMITIVE_TOPOLOGY_UNDEFINED, d3dcommon/D3D10_PRIMITIVE_TOPOLOGY_LINELIST, d3dcommon/D3D10_PRIMITIVE_TOPOLOGY_LINELIST_ADJ, d3dcommon/D3D10_PRIMITIVE_TOPOLOGY_LINESTRIP, d3dcommon/D3D10_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ, d3dcommon/D3D10_PRIMITIVE_TOPOLOGY_POINTLIST, d3dcommon/D3D10_PRIMITIVE_TOPOLOGY_TRIANGLELIST, d3dcommon/D3D10_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ, d3dcommon/D3D10_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP, d3dcommon/D3D10_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ, d3dcommon/D3D10_PRIMITIVE_TOPOLOGY_UNDEFINED, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_10_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_11_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_12_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_13_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_14_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_15_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_16_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_17_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_18_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_19_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_1_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_20_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_21_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_22_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_23_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_24_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_25_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_26_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_27_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_28_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_29_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_2_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_30_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_31_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_32_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_3_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_4_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_5_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_6_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_7_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_8_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_9_CONTROL_POINT_PATCHLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_LINELIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_LINELIST_ADJ, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_LINESTRIP, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_POINTLIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ, d3dcommon/D3D11_PRIMITIVE_TOPOLOGY_UNDEFINED, d3dcommon/D3D_PRIMITIVE_TOPOLOGY, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_10_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_11_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_12_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_13_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_14_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_15_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_16_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_17_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_18_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_19_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_1_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_20_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_21_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_22_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_23_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_24_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_25_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_26_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_27_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_28_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_29_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_2_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_30_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_31_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_32_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_3_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_4_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_5_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_6_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_7_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_8_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_9_CONTROL_POINT_PATCHLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_LINELIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_LINELIST_ADJ, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_LINESTRIP, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_POINTLIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_TRIANGLELIST, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ, d3dcommon/D3D_PRIMITIVE_TOPOLOGY_UNDEFINED, direct3d11.d3d_primitive_topology
f1_keywords:
- d3dcommon/D3D_PRIMITIVE_TOPOLOGY
dev_langs:
- c++
req.header: d3dcommon.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- D3DCommon.h
api_name:
- D3D_PRIMITIVE_TOPOLOGY
targetos: Windows
req.typenames: D3D_PRIMITIVE_TOPOLOGY
req.redist: 
ms.custom: 19H1
---

# D3D_PRIMITIVE_TOPOLOGY enumeration


## -description


Values that indicate how the pipeline interprets vertex data that is bound to the <a href="https://docs.microsoft.com/windows/desktop/direct3d11/d3d10-graphics-programming-guide-input-assembler-stage">input-assembler stage</a>. These <a href="https://docs.microsoft.com/windows/desktop/direct3d11/d3d10-graphics-programming-guide-primitive-topologies">primitive topology values</a> determine how the vertex data is rendered on screen.


## -enum-fields




### -field D3D_PRIMITIVE_TOPOLOGY_UNDEFINED

The IA stage has not been initialized with a primitive topology. The IA stage will not function properly unless a primitive topology is defined.


### -field D3D_PRIMITIVE_TOPOLOGY_POINTLIST

Interpret the vertex data as a list of points.


### -field D3D_PRIMITIVE_TOPOLOGY_LINELIST

Interpret the vertex data as a list of lines.


### -field D3D_PRIMITIVE_TOPOLOGY_LINESTRIP

Interpret the vertex data as a line strip.


### -field D3D_PRIMITIVE_TOPOLOGY_TRIANGLELIST

Interpret the vertex data as a list of triangles.


### -field D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP

Interpret the vertex data as a triangle strip.


### -field D3D_PRIMITIVE_TOPOLOGY_LINELIST_ADJ

Interpret the vertex data as a list of lines with adjacency data.


### -field D3D_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ

Interpret the vertex data as a line strip with adjacency data.


### -field D3D_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ

Interpret the vertex data as a list of triangles with adjacency data.


### -field D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ

Interpret the vertex data as a triangle strip with adjacency data.


### -field D3D_PRIMITIVE_TOPOLOGY_1_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_2_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_3_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_4_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_5_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_6_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_7_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_8_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_9_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_10_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_11_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_12_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_13_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_14_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_15_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_16_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_17_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_18_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_19_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_20_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_21_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_22_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_23_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_24_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_25_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_26_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_27_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_28_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_29_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_30_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_31_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D_PRIMITIVE_TOPOLOGY_32_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D10_PRIMITIVE_TOPOLOGY_UNDEFINED

The IA stage has not been initialized with a primitive topology. The IA stage will not function properly unless a primitive topology is defined.


### -field D3D10_PRIMITIVE_TOPOLOGY_POINTLIST

Interpret the vertex data as a list of points.


### -field D3D10_PRIMITIVE_TOPOLOGY_LINELIST

Interpret the vertex data as a list of lines.


### -field D3D10_PRIMITIVE_TOPOLOGY_LINESTRIP

Interpret the vertex data as a line strip.


### -field D3D10_PRIMITIVE_TOPOLOGY_TRIANGLELIST

Interpret the vertex data as a list of triangles.


### -field D3D10_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP

Interpret the vertex data as a triangle strip.


### -field D3D10_PRIMITIVE_TOPOLOGY_LINELIST_ADJ

Interpret the vertex data as a list of lines with adjacency data.


### -field D3D10_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ

Interpret the vertex data as a line strip with adjacency data.


### -field D3D10_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ

Interpret the vertex data as a list of triangles with adjacency data.


### -field D3D10_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ

Interpret the vertex data as a triangle strip with adjacency data.


### -field D3D11_PRIMITIVE_TOPOLOGY_UNDEFINED

The IA stage has not been initialized with a primitive topology. The IA stage will not function properly unless a primitive topology is defined.


### -field D3D11_PRIMITIVE_TOPOLOGY_POINTLIST

Interpret the vertex data as a list of points.


### -field D3D11_PRIMITIVE_TOPOLOGY_LINELIST

Interpret the vertex data as a list of lines.


### -field D3D11_PRIMITIVE_TOPOLOGY_LINESTRIP

Interpret the vertex data as a line strip.


### -field D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST

Interpret the vertex data as a list of triangles.


### -field D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP

Interpret the vertex data as a triangle strip.


### -field D3D11_PRIMITIVE_TOPOLOGY_LINELIST_ADJ

Interpret the vertex data as a list of lines with adjacency data.


### -field D3D11_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ

Interpret the vertex data as a line strip with adjacency data.


### -field D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ

Interpret the vertex data as a list of triangles with adjacency data.


### -field D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ

Interpret the vertex data as a triangle strip with adjacency data.


### -field D3D11_PRIMITIVE_TOPOLOGY_1_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_2_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_3_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_4_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_5_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_6_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_7_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_8_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_9_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_10_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_11_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_12_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_13_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_14_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_15_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_16_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_17_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_18_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_19_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_20_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_21_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_22_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_23_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_24_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_25_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_26_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_27_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_28_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_29_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_30_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_31_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


### -field D3D11_PRIMITIVE_TOPOLOGY_32_CONTROL_POINT_PATCHLIST

Interpret the vertex data as a patch list.


## -remarks



Use the  <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/nf-d3d11-id3d11devicecontext-iasetprimitivetopology">ID3D11DeviceContext::IASetPrimitiveTopology</a> method and a value from <b>D3D_PRIMITIVE_TOPOLOGY</b> to bind a primitive topology to the input-assembler stage. Use the  <a href="https://docs.microsoft.com/windows/desktop/api/d3d11/nf-d3d11-id3d11devicecontext-iagetprimitivetopology">ID3D11DeviceContext::IAGetPrimitiveTopology</a> method to retrieve the primitive topology for the input-assembler stage.

The following diagram shows the various primitive types for a geometry shader object.

<img alt="Illustration of the various primitive types for a geometry shader object" border="" src="./images/D3D11_GSInputs1.png"/>



## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d11/d3d11-graphics-reference-d3d11-common-enumerations">Common Version Enumerations</a>
 

 

