---
UID: NE:d3dcommon._D3D_SHADER_INPUT_FLAGS
title: D3D_SHADER_INPUT_FLAGS (d3dcommon.h)
description: Values that identify shader-input options.
old-location: direct3d11\d3d_shader_input_flags.htm
tech.root: direct3d11
ms.assetid: 3c79331e-73c0-42d7-9948-6ac2671a4ab5
ms.date: 12/05/2018
ms.keywords: D3D10_SIF_COMPARISON_SAMPLER, D3D10_SIF_TEXTURE_COMPONENTS, D3D10_SIF_TEXTURE_COMPONENT_0, D3D10_SIF_TEXTURE_COMPONENT_1, D3D10_SIF_USERPACKED, D3D_SHADER_INPUT_FLAGS, D3D_SHADER_INPUT_FLAGS enumeration [Direct3D 11], D3D_SIF_COMPARISON_SAMPLER, D3D_SIF_FORCE_DWORD, D3D_SIF_TEXTURE_COMPONENTS, D3D_SIF_TEXTURE_COMPONENT_0, D3D_SIF_TEXTURE_COMPONENT_1, D3D_SIF_UNUSED, D3D_SIF_USERPACKED, d3dcommon/D3D10_SIF_COMPARISON_SAMPLER, d3dcommon/D3D10_SIF_TEXTURE_COMPONENTS, d3dcommon/D3D10_SIF_TEXTURE_COMPONENT_0, d3dcommon/D3D10_SIF_TEXTURE_COMPONENT_1, d3dcommon/D3D10_SIF_USERPACKED, d3dcommon/D3D_SHADER_INPUT_FLAGS, d3dcommon/D3D_SIF_COMPARISON_SAMPLER, d3dcommon/D3D_SIF_FORCE_DWORD, d3dcommon/D3D_SIF_TEXTURE_COMPONENTS, d3dcommon/D3D_SIF_TEXTURE_COMPONENT_0, d3dcommon/D3D_SIF_TEXTURE_COMPONENT_1, d3dcommon/D3D_SIF_UNUSED, d3dcommon/D3D_SIF_USERPACKED, direct3d11.d3d_shader_input_flags
f1_keywords:
- d3dcommon/D3D_SHADER_INPUT_FLAGS
dev_langs:
- c++
req.header: d3dcommon.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- D3DCommon.h
api_name:
- D3D_SHADER_INPUT_FLAGS
targetos: Windows
req.typenames: D3D_SHADER_INPUT_FLAGS
req.redist: 
ms.custom: 19H1
---

# D3D_SHADER_INPUT_FLAGS enumeration


## -description


Values that identify shader-input options.


## -enum-fields




### -field D3D_SIF_USERPACKED

Assign a shader input to a register based on the register assignment in the HLSL code (instead of letting the compiler choose the register).
          


### -field D3D_SIF_COMPARISON_SAMPLER

Use a comparison sampler, which uses the <a href="https://docs.microsoft.com/windows/desktop/direct3dhlsl/dx-graphics-hlsl-to-samplecmp">SampleCmp (DirectX HLSL Texture Object)</a> and <a href="https://docs.microsoft.com/windows/desktop/direct3dhlsl/dx-graphics-hlsl-to-samplecmplevelzero">SampleCmpLevelZero (DirectX HLSL Texture Object)</a> sampling functions.
          


### -field D3D_SIF_TEXTURE_COMPONENT_0

A 2-bit value for encoding texture components.
          


### -field D3D_SIF_TEXTURE_COMPONENT_1

A 2-bit value for encoding texture components.
          


### -field D3D_SIF_TEXTURE_COMPONENTS

A 2-bit value for encoding texture components.
          


### -field D3D_SIF_UNUSED

This value is reserved.
          


### -field D3D10_SIF_USERPACKED

Assign a shader input to a register based on the register assignment in the HLSL code (instead of letting the compiler choose the register).
          


### -field D3D10_SIF_COMPARISON_SAMPLER

Use a comparison sampler, which uses the <a href="https://docs.microsoft.com/windows/desktop/direct3dhlsl/dx-graphics-hlsl-to-samplecmp">SampleCmp (DirectX HLSL Texture Object)</a> and <a href="https://docs.microsoft.com/windows/desktop/direct3dhlsl/dx-graphics-hlsl-to-samplecmplevelzero">SampleCmpLevelZero (DirectX HLSL Texture Object)</a> sampling functions.
          


### -field D3D10_SIF_TEXTURE_COMPONENT_0

A 2-bit value for encoding texture components.
          


### -field D3D10_SIF_TEXTURE_COMPONENT_1

A 2-bit value for encoding texture components.
          


### -field D3D10_SIF_TEXTURE_COMPONENTS

A 2-bit value for encoding texture components.
          


### -field D3D_SIF_FORCE_DWORD

Forces the enumeration to compile to 32 bits.
            This value is not used directly by titles.
          


## -remarks



<b>D3D_SHADER_INPUT_FLAGS</b>-typed values are specified in
          the <b>uFlags</b> member of the <a href="https://docs.microsoft.com/windows/win32/api/d3d11shader/ns-d3d11shader-d3d11_shader_input_bind_desc">D3D11_SHADER_INPUT_BIND_DESC</a> structure.
        




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d11/d3d11-graphics-reference-d3d11-common-enumerations">Common Version Enumerations</a>
 

 

