---
UID: NE:d3dcommon._D3D_SHADER_INPUT_TYPE
title: D3D_SHADER_INPUT_TYPE (d3dcommon.h)
description: Values that identify resource types that can be bound to a shader and that are reflected as part of the resource description for the shader.
old-location: direct3d11\d3d_shader_input_type.htm
tech.root: direct3d11
ms.assetid: c6106f9e-420d-43e1-92ba-bc3a6e544e7d
ms.date: 12/05/2018
ms.keywords: D3D10_SIT_CBUFFER, D3D10_SIT_SAMPLER, D3D10_SIT_TBUFFER, D3D10_SIT_TEXTURE, D3D11_SIT_BYTEADDRESS, D3D11_SIT_STRUCTURED, D3D11_SIT_UAV_APPEND_STRUCTURED, D3D11_SIT_UAV_CONSUME_STRUCTURED, D3D11_SIT_UAV_RWBYTEADDRESS, D3D11_SIT_UAV_RWSTRUCTURED, D3D11_SIT_UAV_RWSTRUCTURED_WITH_COUNTER, D3D11_SIT_UAV_RWTYPED, D3D_SHADER_INPUT_TYPE, D3D_SHADER_INPUT_TYPE enumeration [Direct3D 11], D3D_SIT_BYTEADDRESS, D3D_SIT_CBUFFER, D3D_SIT_SAMPLER, D3D_SIT_STRUCTURED, D3D_SIT_TBUFFER, D3D_SIT_TEXTURE, D3D_SIT_UAV_APPEND_STRUCTURED, D3D_SIT_UAV_CONSUME_STRUCTURED, D3D_SIT_UAV_RWBYTEADDRESS, D3D_SIT_UAV_RWSTRUCTURED, D3D_SIT_UAV_RWSTRUCTURED_WITH_COUNTER, D3D_SIT_UAV_RWTYPED, d3dcommon/D3D10_SIT_CBUFFER, d3dcommon/D3D10_SIT_SAMPLER, d3dcommon/D3D10_SIT_TBUFFER, d3dcommon/D3D10_SIT_TEXTURE, d3dcommon/D3D11_SIT_BYTEADDRESS, d3dcommon/D3D11_SIT_STRUCTURED, d3dcommon/D3D11_SIT_UAV_APPEND_STRUCTURED, d3dcommon/D3D11_SIT_UAV_CONSUME_STRUCTURED, d3dcommon/D3D11_SIT_UAV_RWBYTEADDRESS, d3dcommon/D3D11_SIT_UAV_RWSTRUCTURED, d3dcommon/D3D11_SIT_UAV_RWSTRUCTURED_WITH_COUNTER, d3dcommon/D3D11_SIT_UAV_RWTYPED, d3dcommon/D3D_SHADER_INPUT_TYPE, d3dcommon/D3D_SIT_BYTEADDRESS, d3dcommon/D3D_SIT_CBUFFER, d3dcommon/D3D_SIT_SAMPLER, d3dcommon/D3D_SIT_STRUCTURED, d3dcommon/D3D_SIT_TBUFFER, d3dcommon/D3D_SIT_TEXTURE, d3dcommon/D3D_SIT_UAV_APPEND_STRUCTURED, d3dcommon/D3D_SIT_UAV_CONSUME_STRUCTURED, d3dcommon/D3D_SIT_UAV_RWBYTEADDRESS, d3dcommon/D3D_SIT_UAV_RWSTRUCTURED, d3dcommon/D3D_SIT_UAV_RWSTRUCTURED_WITH_COUNTER, d3dcommon/D3D_SIT_UAV_RWTYPED, direct3d11.d3d_shader_input_type
f1_keywords:
- d3dcommon/D3D_SHADER_INPUT_TYPE
dev_langs:
- c++
req.header: d3dcommon.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- D3DCommon.h
api_name:
- D3D_SHADER_INPUT_TYPE
targetos: Windows
req.typenames: D3D_SHADER_INPUT_TYPE
req.redist: 
ms.custom: 19H1
---

# D3D_SHADER_INPUT_TYPE enumeration


## -description


Values that identify resource types that can be bound to a shader and that are reflected as part of the resource description for the shader.


## -enum-fields




### -field D3D_SIT_CBUFFER

The shader resource is a constant buffer.


### -field D3D_SIT_TBUFFER

The shader resource is a texture buffer.


### -field D3D_SIT_TEXTURE

The shader resource is a texture.


### -field D3D_SIT_SAMPLER

The shader resource is a sampler.


### -field D3D_SIT_UAV_RWTYPED

The shader resource is a read-and-write buffer.


### -field D3D_SIT_STRUCTURED

The shader resource is a structured buffer.

For more information about structured buffer, see the <b>Remarks</b> section.


### -field D3D_SIT_UAV_RWSTRUCTURED

The shader resource is a read-and-write structured buffer.


### -field D3D_SIT_BYTEADDRESS

The shader resource is a byte-address buffer.


### -field D3D_SIT_UAV_RWBYTEADDRESS

The shader resource is a read-and-write byte-address buffer.


### -field D3D_SIT_UAV_APPEND_STRUCTURED

The shader resource is an append-structured buffer.


### -field D3D_SIT_UAV_CONSUME_STRUCTURED

The shader resource is a consume-structured buffer.


### -field D3D_SIT_UAV_RWSTRUCTURED_WITH_COUNTER

The shader resource is a read-and-write structured buffer that uses the built-in counter to append or consume.


### -field D3D10_SIT_CBUFFER

The shader resource is a constant buffer.


### -field D3D10_SIT_TBUFFER

The shader resource is a texture buffer.


### -field D3D10_SIT_TEXTURE

The shader resource is a texture.


### -field D3D10_SIT_SAMPLER

The shader resource is a sampler.


### -field D3D11_SIT_UAV_RWTYPED

The shader resource is a read-and-write buffer.


### -field D3D11_SIT_STRUCTURED

The shader resource is a structured buffer.

For more information about structured buffer, see the <b>Remarks</b> section.


### -field D3D11_SIT_UAV_RWSTRUCTURED

The shader resource is a read-and-write structured buffer.


### -field D3D11_SIT_BYTEADDRESS

The shader resource is a byte-address buffer.


### -field D3D11_SIT_UAV_RWBYTEADDRESS

The shader resource is a read-and-write byte-address buffer.


### -field D3D11_SIT_UAV_APPEND_STRUCTURED

The shader resource is an append-structured buffer.


### -field D3D11_SIT_UAV_CONSUME_STRUCTURED

The shader resource is a consume-structured buffer.


### -field D3D11_SIT_UAV_RWSTRUCTURED_WITH_COUNTER

The shader resource is a read-and-write structured buffer that uses the built-in counter to append or consume.


## -remarks



<b>D3D_SHADER_INPUT_TYPE</b>-typed values are specified in the <b>Type</b> member of the <a href="https://docs.microsoft.com/windows/win32/api/d3d11shader/ns-d3d11shader-d3d11_shader_input_bind_desc">D3D11_SHADER_INPUT_BIND_DESC</a> structure.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d11/d3d11-graphics-reference-d3d11-common-enumerations">Common Version Enumerations</a>
 

 

