---
UID: NE:d3dcommon._D3D_SHADER_VARIABLE_TYPE
title: D3D_SHADER_VARIABLE_TYPE (d3dcommon.h)
description: Values that identify various data, texture, and buffer types that can be assigned to a shader variable.
old-location: direct3d11\d3d_shader_variable_type.htm
tech.root: direct3d11
ms.assetid: ef07a68c-d944-4dbb-8cb1-c50403c6c8e8
ms.date: 12/05/2018
ms.keywords: D3D10_SVT_BLEND, D3D10_SVT_BOOL, D3D10_SVT_BUFFER, D3D10_SVT_CBUFFER, D3D10_SVT_DEPTHSTENCIL, D3D10_SVT_DEPTHSTENCILVIEW, D3D10_SVT_FLOAT, D3D10_SVT_GEOMETRYSHADER, D3D10_SVT_INT, D3D10_SVT_PIXELFRAGMENT, D3D10_SVT_PIXELSHADER, D3D10_SVT_RASTERIZER, D3D10_SVT_RENDERTARGETVIEW, D3D10_SVT_SAMPLER, D3D10_SVT_SAMPLER1D, D3D10_SVT_SAMPLER2D, D3D10_SVT_SAMPLER3D, D3D10_SVT_SAMPLERCUBE, D3D10_SVT_STRING, D3D10_SVT_TBUFFER, D3D10_SVT_TEXTURE, D3D10_SVT_TEXTURE1D, D3D10_SVT_TEXTURE1DARRAY, D3D10_SVT_TEXTURE2D, D3D10_SVT_TEXTURE2DARRAY, D3D10_SVT_TEXTURE2DMS, D3D10_SVT_TEXTURE2DMSARRAY, D3D10_SVT_TEXTURE3D, D3D10_SVT_TEXTURECUBE, D3D10_SVT_TEXTURECUBEARRAY, D3D10_SVT_UINT, D3D10_SVT_UINT8, D3D10_SVT_VERTEXFRAGMENT, D3D10_SVT_VERTEXSHADER, D3D10_SVT_VOID, D3D11_SVT_APPEND_STRUCTURED_BUFFER, D3D11_SVT_BYTEADDRESS_BUFFER, D3D11_SVT_COMPUTESHADER, D3D11_SVT_CONSUME_STRUCTURED_BUFFER, D3D11_SVT_DOMAINSHADER, D3D11_SVT_DOUBLE, D3D11_SVT_HULLSHADER, D3D11_SVT_INTERFACE_POINTER, D3D11_SVT_RWBUFFER, D3D11_SVT_RWBYTEADDRESS_BUFFER, D3D11_SVT_RWSTRUCTURED_BUFFER, D3D11_SVT_RWTEXTURE1D, D3D11_SVT_RWTEXTURE1DARRAY, D3D11_SVT_RWTEXTURE2D, D3D11_SVT_RWTEXTURE2DARRAY, D3D11_SVT_RWTEXTURE3D, D3D11_SVT_STRUCTURED_BUFFER, D3D_SHADER_VARIABLE_TYPE, D3D_SHADER_VARIABLE_TYPE enumeration [Direct3D 11], D3D_SVT_APPEND_STRUCTURED_BUFFER, D3D_SVT_BLEND, D3D_SVT_BOOL, D3D_SVT_BUFFER, D3D_SVT_BYTEADDRESS_BUFFER, D3D_SVT_CBUFFER, D3D_SVT_COMPUTESHADER, D3D_SVT_CONSUME_STRUCTURED_BUFFER, D3D_SVT_DEPTHSTENCIL, D3D_SVT_DEPTHSTENCILVIEW, D3D_SVT_DOMAINSHADER, D3D_SVT_DOUBLE, D3D_SVT_FLOAT, D3D_SVT_FORCE_DWORD, D3D_SVT_GEOMETRYSHADER, D3D_SVT_HULLSHADER, D3D_SVT_INT, D3D_SVT_INTERFACE_POINTER, D3D_SVT_MIN10FLOAT, D3D_SVT_MIN12INT, D3D_SVT_MIN16FLOAT, D3D_SVT_MIN16INT, D3D_SVT_MIN16UINT, D3D_SVT_MIN8FLOAT, D3D_SVT_PIXELFRAGMENT, D3D_SVT_PIXELSHADER, D3D_SVT_RASTERIZER, D3D_SVT_RENDERTARGETVIEW, D3D_SVT_RWBUFFER, D3D_SVT_RWBYTEADDRESS_BUFFER, D3D_SVT_RWSTRUCTURED_BUFFER, D3D_SVT_RWTEXTURE1D, D3D_SVT_RWTEXTURE1DARRAY, D3D_SVT_RWTEXTURE2D, D3D_SVT_RWTEXTURE2DARRAY, D3D_SVT_RWTEXTURE3D, D3D_SVT_SAMPLER, D3D_SVT_SAMPLER1D, D3D_SVT_SAMPLER2D, D3D_SVT_SAMPLER3D, D3D_SVT_SAMPLERCUBE, D3D_SVT_STRING, D3D_SVT_STRUCTURED_BUFFER, D3D_SVT_TBUFFER, D3D_SVT_TEXTURE, D3D_SVT_TEXTURE1D, D3D_SVT_TEXTURE1DARRAY, D3D_SVT_TEXTURE2D, D3D_SVT_TEXTURE2DARRAY, D3D_SVT_TEXTURE2DMS, D3D_SVT_TEXTURE2DMSARRAY, D3D_SVT_TEXTURE3D, D3D_SVT_TEXTURECUBE, D3D_SVT_TEXTURECUBEARRAY, D3D_SVT_UINT, D3D_SVT_UINT8, D3D_SVT_VERTEXFRAGMENT, D3D_SVT_VERTEXSHADER, D3D_SVT_VOID, d3dcommon/D3D10_SVT_BLEND, d3dcommon/D3D10_SVT_BOOL, d3dcommon/D3D10_SVT_BUFFER, d3dcommon/D3D10_SVT_CBUFFER, d3dcommon/D3D10_SVT_DEPTHSTENCIL, d3dcommon/D3D10_SVT_DEPTHSTENCILVIEW, d3dcommon/D3D10_SVT_FLOAT, d3dcommon/D3D10_SVT_GEOMETRYSHADER, d3dcommon/D3D10_SVT_INT, d3dcommon/D3D10_SVT_PIXELFRAGMENT, d3dcommon/D3D10_SVT_PIXELSHADER, d3dcommon/D3D10_SVT_RASTERIZER, d3dcommon/D3D10_SVT_RENDERTARGETVIEW, d3dcommon/D3D10_SVT_SAMPLER, d3dcommon/D3D10_SVT_SAMPLER1D, d3dcommon/D3D10_SVT_SAMPLER2D, d3dcommon/D3D10_SVT_SAMPLER3D, d3dcommon/D3D10_SVT_SAMPLERCUBE, d3dcommon/D3D10_SVT_STRING, d3dcommon/D3D10_SVT_TBUFFER, d3dcommon/D3D10_SVT_TEXTURE, d3dcommon/D3D10_SVT_TEXTURE1D, d3dcommon/D3D10_SVT_TEXTURE1DARRAY, d3dcommon/D3D10_SVT_TEXTURE2D, d3dcommon/D3D10_SVT_TEXTURE2DARRAY, d3dcommon/D3D10_SVT_TEXTURE2DMS, d3dcommon/D3D10_SVT_TEXTURE2DMSARRAY, d3dcommon/D3D10_SVT_TEXTURE3D, d3dcommon/D3D10_SVT_TEXTURECUBE, d3dcommon/D3D10_SVT_TEXTURECUBEARRAY, d3dcommon/D3D10_SVT_UINT, d3dcommon/D3D10_SVT_UINT8, d3dcommon/D3D10_SVT_VERTEXFRAGMENT, d3dcommon/D3D10_SVT_VERTEXSHADER, d3dcommon/D3D10_SVT_VOID, d3dcommon/D3D11_SVT_APPEND_STRUCTURED_BUFFER, d3dcommon/D3D11_SVT_BYTEADDRESS_BUFFER, d3dcommon/D3D11_SVT_COMPUTESHADER, d3dcommon/D3D11_SVT_CONSUME_STRUCTURED_BUFFER, d3dcommon/D3D11_SVT_DOMAINSHADER, d3dcommon/D3D11_SVT_DOUBLE, d3dcommon/D3D11_SVT_HULLSHADER, d3dcommon/D3D11_SVT_INTERFACE_POINTER, d3dcommon/D3D11_SVT_RWBUFFER, d3dcommon/D3D11_SVT_RWBYTEADDRESS_BUFFER, d3dcommon/D3D11_SVT_RWSTRUCTURED_BUFFER, d3dcommon/D3D11_SVT_RWTEXTURE1D, d3dcommon/D3D11_SVT_RWTEXTURE1DARRAY, d3dcommon/D3D11_SVT_RWTEXTURE2D, d3dcommon/D3D11_SVT_RWTEXTURE2DARRAY, d3dcommon/D3D11_SVT_RWTEXTURE3D, d3dcommon/D3D11_SVT_STRUCTURED_BUFFER, d3dcommon/D3D_SHADER_VARIABLE_TYPE, d3dcommon/D3D_SVT_APPEND_STRUCTURED_BUFFER, d3dcommon/D3D_SVT_BLEND, d3dcommon/D3D_SVT_BOOL, d3dcommon/D3D_SVT_BUFFER, d3dcommon/D3D_SVT_BYTEADDRESS_BUFFER, d3dcommon/D3D_SVT_CBUFFER, d3dcommon/D3D_SVT_COMPUTESHADER, d3dcommon/D3D_SVT_CONSUME_STRUCTURED_BUFFER, d3dcommon/D3D_SVT_DEPTHSTENCIL, d3dcommon/D3D_SVT_DEPTHSTENCILVIEW, d3dcommon/D3D_SVT_DOMAINSHADER, d3dcommon/D3D_SVT_DOUBLE, d3dcommon/D3D_SVT_FLOAT, d3dcommon/D3D_SVT_FORCE_DWORD, d3dcommon/D3D_SVT_GEOMETRYSHADER, d3dcommon/D3D_SVT_HULLSHADER, d3dcommon/D3D_SVT_INT, d3dcommon/D3D_SVT_INTERFACE_POINTER, d3dcommon/D3D_SVT_MIN10FLOAT, d3dcommon/D3D_SVT_MIN12INT, d3dcommon/D3D_SVT_MIN16FLOAT, d3dcommon/D3D_SVT_MIN16INT, d3dcommon/D3D_SVT_MIN16UINT, d3dcommon/D3D_SVT_MIN8FLOAT, d3dcommon/D3D_SVT_PIXELFRAGMENT, d3dcommon/D3D_SVT_PIXELSHADER, d3dcommon/D3D_SVT_RASTERIZER, d3dcommon/D3D_SVT_RENDERTARGETVIEW, d3dcommon/D3D_SVT_RWBUFFER, d3dcommon/D3D_SVT_RWBYTEADDRESS_BUFFER, d3dcommon/D3D_SVT_RWSTRUCTURED_BUFFER, d3dcommon/D3D_SVT_RWTEXTURE1D, d3dcommon/D3D_SVT_RWTEXTURE1DARRAY, d3dcommon/D3D_SVT_RWTEXTURE2D, d3dcommon/D3D_SVT_RWTEXTURE2DARRAY, d3dcommon/D3D_SVT_RWTEXTURE3D, d3dcommon/D3D_SVT_SAMPLER, d3dcommon/D3D_SVT_SAMPLER1D, d3dcommon/D3D_SVT_SAMPLER2D, d3dcommon/D3D_SVT_SAMPLER3D, d3dcommon/D3D_SVT_SAMPLERCUBE, d3dcommon/D3D_SVT_STRING, d3dcommon/D3D_SVT_STRUCTURED_BUFFER, d3dcommon/D3D_SVT_TBUFFER, d3dcommon/D3D_SVT_TEXTURE, d3dcommon/D3D_SVT_TEXTURE1D, d3dcommon/D3D_SVT_TEXTURE1DARRAY, d3dcommon/D3D_SVT_TEXTURE2D, d3dcommon/D3D_SVT_TEXTURE2DARRAY, d3dcommon/D3D_SVT_TEXTURE2DMS, d3dcommon/D3D_SVT_TEXTURE2DMSARRAY, d3dcommon/D3D_SVT_TEXTURE3D, d3dcommon/D3D_SVT_TEXTURECUBE, d3dcommon/D3D_SVT_TEXTURECUBEARRAY, d3dcommon/D3D_SVT_UINT, d3dcommon/D3D_SVT_UINT8, d3dcommon/D3D_SVT_VERTEXFRAGMENT, d3dcommon/D3D_SVT_VERTEXSHADER, d3dcommon/D3D_SVT_VOID, direct3d11.d3d_shader_variable_type
f1_keywords:
- d3dcommon/D3D_SHADER_VARIABLE_TYPE
dev_langs:
- c++
req.header: d3dcommon.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- D3DCommon.h
api_name:
- D3D_SHADER_VARIABLE_TYPE
targetos: Windows
req.typenames: D3D_SHADER_VARIABLE_TYPE
req.redist: 
ms.custom: 19H1
---

# D3D_SHADER_VARIABLE_TYPE enumeration


## -description


Values that identify various data, texture, and buffer types that can be assigned to a shader variable.


## -enum-fields




### -field D3D_SVT_VOID

The variable is a void pointer.


### -field D3D_SVT_BOOL

The variable is a boolean.


### -field D3D_SVT_INT

The variable is an integer.


### -field D3D_SVT_FLOAT

The variable is a floating-point number.


### -field D3D_SVT_STRING

The variable is a string.


### -field D3D_SVT_TEXTURE

The variable is a texture.


### -field D3D_SVT_TEXTURE1D

The variable is a 1D texture.


### -field D3D_SVT_TEXTURE2D

The variable is a 2D texture.


### -field D3D_SVT_TEXTURE3D

The variable is a 3D texture.


### -field D3D_SVT_TEXTURECUBE

The variable is a texture cube.


### -field D3D_SVT_SAMPLER

The variable is a sampler.


### -field D3D_SVT_SAMPLER1D

The variable is a 1D sampler.
          


### -field D3D_SVT_SAMPLER2D

The variable is a 2D sampler.
          


### -field D3D_SVT_SAMPLER3D

The variable is a 3D sampler.
          


### -field D3D_SVT_SAMPLERCUBE

The variable is a cube sampler.
          


### -field D3D_SVT_PIXELSHADER

The variable is a pixel shader.


### -field D3D_SVT_VERTEXSHADER

The variable is a vertex shader.


### -field D3D_SVT_PIXELFRAGMENT

The variable is a pixel fragment.
          


### -field D3D_SVT_VERTEXFRAGMENT

The variable is a vertex fragment.
          


### -field D3D_SVT_UINT

The variable is an unsigned integer.


### -field D3D_SVT_UINT8

The variable is an 8-bit unsigned integer.


### -field D3D_SVT_GEOMETRYSHADER

The variable is a geometry shader.


### -field D3D_SVT_RASTERIZER

The variable is a rasterizer-state object.


### -field D3D_SVT_DEPTHSTENCIL

The variable is a depth-stencil-state object.


### -field D3D_SVT_BLEND

The variable is a blend-state object.


### -field D3D_SVT_BUFFER

The variable is a buffer.


### -field D3D_SVT_CBUFFER

The variable is a constant buffer.


### -field D3D_SVT_TBUFFER

The variable is a texture buffer.


### -field D3D_SVT_TEXTURE1DARRAY

The variable is a 1D-texture array.


### -field D3D_SVT_TEXTURE2DARRAY

The variable is a 2D-texture array.


### -field D3D_SVT_RENDERTARGETVIEW

The variable is a render-target view.


### -field D3D_SVT_DEPTHSTENCILVIEW

The variable is a depth-stencil view.


### -field D3D_SVT_TEXTURE2DMS

The variable is a 2D-multisampled texture.


### -field D3D_SVT_TEXTURE2DMSARRAY

The variable is a 2D-multisampled-texture array.


### -field D3D_SVT_TEXTURECUBEARRAY

The variable is a texture-cube array.


### -field D3D_SVT_HULLSHADER

The variable holds a compiled hull-shader binary.


### -field D3D_SVT_DOMAINSHADER

The variable holds a compiled domain-shader binary.


### -field D3D_SVT_INTERFACE_POINTER

The variable is an interface.


### -field D3D_SVT_COMPUTESHADER

The variable holds a compiled compute-shader binary.


### -field D3D_SVT_DOUBLE

The variable is a double precision (64-bit) floating-point number.


### -field D3D_SVT_RWTEXTURE1D

The variable is a 1D read-and-write texture.


### -field D3D_SVT_RWTEXTURE1DARRAY

The variable is an array of 1D read-and-write textures.


### -field D3D_SVT_RWTEXTURE2D

The variable is a 2D read-and-write texture.


### -field D3D_SVT_RWTEXTURE2DARRAY

The variable is an array of 2D read-and-write textures.


### -field D3D_SVT_RWTEXTURE3D

The variable is a 3D read-and-write texture.


### -field D3D_SVT_RWBUFFER

The variable is a read-and-write buffer.


### -field D3D_SVT_BYTEADDRESS_BUFFER

The variable is a byte-address buffer.


### -field D3D_SVT_RWBYTEADDRESS_BUFFER

The variable is a read-and-write byte-address buffer.


### -field D3D_SVT_STRUCTURED_BUFFER

The variable is a structured buffer. 

For more information about structured buffer, see the <b>Remarks</b> section.
            


### -field D3D_SVT_RWSTRUCTURED_BUFFER

The variable is a read-and-write structured buffer.


### -field D3D_SVT_APPEND_STRUCTURED_BUFFER

The variable is an append structured buffer.


### -field D3D_SVT_CONSUME_STRUCTURED_BUFFER

The variable is a consume structured buffer.


### -field D3D_SVT_MIN8FLOAT

The variable is an 8-byte FLOAT.
          


### -field D3D_SVT_MIN10FLOAT

The variable is a 10-byte FLOAT.
          


### -field D3D_SVT_MIN16FLOAT

The variable is a 16-byte FLOAT.
          


### -field D3D_SVT_MIN12INT

The variable is a 12-byte INT.
          


### -field D3D_SVT_MIN16INT

The variable is a 16-byte INT.
          


### -field D3D_SVT_MIN16UINT

The variable is a 16-byte INT.
          


### -field D3D10_SVT_VOID

The variable is a void pointer.


### -field D3D10_SVT_BOOL

The variable is a boolean.


### -field D3D10_SVT_INT

The variable is an integer.


### -field D3D10_SVT_FLOAT

The variable is a floating-point number.


### -field D3D10_SVT_STRING

The variable is a string.


### -field D3D10_SVT_TEXTURE

The variable is a texture.


### -field D3D10_SVT_TEXTURE1D

The variable is a 1D texture.


### -field D3D10_SVT_TEXTURE2D

The variable is a 2D texture.


### -field D3D10_SVT_TEXTURE3D

The variable is a 3D texture.


### -field D3D10_SVT_TEXTURECUBE

The variable is a texture cube.


### -field D3D10_SVT_SAMPLER

The variable is a sampler.


### -field D3D10_SVT_SAMPLER1D

The variable is a 1D sampler.
          


### -field D3D10_SVT_SAMPLER2D

The variable is a 2D sampler.
          


### -field D3D10_SVT_SAMPLER3D

The variable is a 3D sampler.
          


### -field D3D10_SVT_SAMPLERCUBE

The variable is a cube sampler.
          


### -field D3D10_SVT_PIXELSHADER

The variable is a pixel shader.


### -field D3D10_SVT_VERTEXSHADER

The variable is a vertex shader.


### -field D3D10_SVT_PIXELFRAGMENT

The variable is a pixel fragment.
          


### -field D3D10_SVT_VERTEXFRAGMENT

The variable is a vertex fragment.
          


### -field D3D10_SVT_UINT

The variable is an unsigned integer.


### -field D3D10_SVT_UINT8

The variable is an 8-bit unsigned integer.


### -field D3D10_SVT_GEOMETRYSHADER

The variable is a geometry shader.


### -field D3D10_SVT_RASTERIZER

The variable is a rasterizer-state object.


### -field D3D10_SVT_DEPTHSTENCIL

The variable is a depth-stencil-state object.


### -field D3D10_SVT_BLEND

The variable is a blend-state object.


### -field D3D10_SVT_BUFFER

The variable is a buffer.


### -field D3D10_SVT_CBUFFER

The variable is a constant buffer.


### -field D3D10_SVT_TBUFFER

The variable is a texture buffer.


### -field D3D10_SVT_TEXTURE1DARRAY

The variable is a 1D-texture array.


### -field D3D10_SVT_TEXTURE2DARRAY

The variable is a 2D-texture array.


### -field D3D10_SVT_RENDERTARGETVIEW

The variable is a render-target view.


### -field D3D10_SVT_DEPTHSTENCILVIEW

The variable is a depth-stencil view.


### -field D3D10_SVT_TEXTURE2DMS

The variable is a 2D-multisampled texture.


### -field D3D10_SVT_TEXTURE2DMSARRAY

The variable is a 2D-multisampled-texture array.


### -field D3D10_SVT_TEXTURECUBEARRAY

The variable is a texture-cube array.


### -field D3D11_SVT_HULLSHADER

The variable holds a compiled hull-shader binary.


### -field D3D11_SVT_DOMAINSHADER

The variable holds a compiled domain-shader binary.


### -field D3D11_SVT_INTERFACE_POINTER

The variable is an interface.


### -field D3D11_SVT_COMPUTESHADER

The variable holds a compiled compute-shader binary.


### -field D3D11_SVT_DOUBLE

The variable is a double precision (64-bit) floating-point number.


### -field D3D11_SVT_RWTEXTURE1D

The variable is a 1D read-and-write texture.


### -field D3D11_SVT_RWTEXTURE1DARRAY

The variable is an array of 1D read-and-write textures.


### -field D3D11_SVT_RWTEXTURE2D

The variable is a 2D read-and-write texture.


### -field D3D11_SVT_RWTEXTURE2DARRAY

The variable is an array of 2D read-and-write textures.


### -field D3D11_SVT_RWTEXTURE3D

The variable is a 3D read-and-write texture.


### -field D3D11_SVT_RWBUFFER

The variable is a read-and-write buffer.


### -field D3D11_SVT_BYTEADDRESS_BUFFER

The variable is a byte-address buffer.


### -field D3D11_SVT_RWBYTEADDRESS_BUFFER

The variable is a read and write byte-address buffer.


### -field D3D11_SVT_STRUCTURED_BUFFER

The variable is a structured buffer. 


### -field D3D11_SVT_RWSTRUCTURED_BUFFER

The variable is a read-and-write structured buffer.


### -field D3D11_SVT_APPEND_STRUCTURED_BUFFER

The variable is an append structured buffer.


### -field D3D11_SVT_CONSUME_STRUCTURED_BUFFER

The variable is a consume structured buffer.


### -field D3D_SVT_FORCE_DWORD

This value is not used by a programmer; it exists to force the enumeration to compile to 32 bits.


## -remarks



A call to the
          <a href="https://docs.microsoft.com/windows/desktop/api/d3d11shader/nf-d3d11shader-id3d11shaderreflectiontype-getdesc">ID3D11ShaderReflectionType::GetDesc</a>method returns a
          <b>D3D_SHADER_VARIABLE_TYPE</b>value in the <b>Type</b> member of a
          <a href="https://docs.microsoft.com/windows/desktop/api/d3d11shader/ns-d3d11shader-d3d11_shader_type_desc">D3D11_SHADER_TYPE_DESC</a> structure.
        

The types in a structured buffer describe the structure of the elements in the buffer.
          The layout of these types generally match their C++ struct counterparts.
          The following examples show structured buffers:
        


```
struct mystruct {float4 val; uint ind;}; RWStructuredBuffer<mystruct> rwbuf;
                                         RWStructuredBuffer<float3> rwbuf2;
```





## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3d11/d3d11-graphics-reference-d3d11-common-enumerations">Common Version Enumerations</a>
 

 

