---
UID: NE:d3dcompiler.D3D_BLOB_PART
title: D3D_BLOB_PART (d3dcompiler.h)
description: Values that identify parts of the content of an arbitrary length data buffer.
old-location: direct3dhlsl\d3d_blob_part.htm
tech.root: direct3dhlsl
ms.assetid: 333bc68a-0412-48e7-ac28-69ec5eea9ce8
ms.date: 12/05/2018
ms.keywords: D3D_BLOB_ALL_SIGNATURE_BLOB, D3D_BLOB_DEBUG_INFO, D3D_BLOB_DEBUG_NAME, D3D_BLOB_INPUT_AND_OUTPUT_SIGNATURE_BLOB, D3D_BLOB_INPUT_SIGNATURE_BLOB, D3D_BLOB_LEGACY_SHADER, D3D_BLOB_OUTPUT_SIGNATURE_BLOB, D3D_BLOB_PART, D3D_BLOB_PART enumeration [HLSL], D3D_BLOB_PATCH_CONSTANT_SIGNATURE_BLOB, D3D_BLOB_PDB, D3D_BLOB_PRIVATE_DATA, D3D_BLOB_ROOT_SIGNATURE, D3D_BLOB_TEST_ALTERNATE_SHADER, D3D_BLOB_TEST_COMPILE_DETAILS, D3D_BLOB_TEST_COMPILE_PERF, D3D_BLOB_TEST_COMPILE_REPORT, D3D_BLOB_XNA_PREPASS_SHADER, D3D_BLOB_XNA_SHADER, d3dcompiler/D3D_BLOB_ALL_SIGNATURE_BLOB, d3dcompiler/D3D_BLOB_DEBUG_INFO, d3dcompiler/D3D_BLOB_DEBUG_NAME, d3dcompiler/D3D_BLOB_INPUT_AND_OUTPUT_SIGNATURE_BLOB, d3dcompiler/D3D_BLOB_INPUT_SIGNATURE_BLOB, d3dcompiler/D3D_BLOB_LEGACY_SHADER, d3dcompiler/D3D_BLOB_OUTPUT_SIGNATURE_BLOB, d3dcompiler/D3D_BLOB_PART, d3dcompiler/D3D_BLOB_PATCH_CONSTANT_SIGNATURE_BLOB, d3dcompiler/D3D_BLOB_PDB, d3dcompiler/D3D_BLOB_PRIVATE_DATA, d3dcompiler/D3D_BLOB_ROOT_SIGNATURE, d3dcompiler/D3D_BLOB_TEST_ALTERNATE_SHADER, d3dcompiler/D3D_BLOB_TEST_COMPILE_DETAILS, d3dcompiler/D3D_BLOB_TEST_COMPILE_PERF, d3dcompiler/D3D_BLOB_TEST_COMPILE_REPORT, d3dcompiler/D3D_BLOB_XNA_PREPASS_SHADER, d3dcompiler/D3D_BLOB_XNA_SHADER, direct3dhlsl.d3d_blob_part
f1_keywords:
- d3dcompiler/D3D_BLOB_PART
dev_langs:
- c++
req.header: d3dcompiler.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- D3Dcompiler.h
api_name:
- D3D_BLOB_PART
targetos: Windows
req.typenames: D3D_BLOB_PART
req.redist: 
ms.custom: 19H1
---

# D3D_BLOB_PART enumeration


## -description


Values that identify parts of the content of an arbitrary length data buffer.


## -enum-fields




### -field D3D_BLOB_INPUT_SIGNATURE_BLOB

The blob part is an input signature.


### -field D3D_BLOB_OUTPUT_SIGNATURE_BLOB

The blob part is an output signature.


### -field D3D_BLOB_INPUT_AND_OUTPUT_SIGNATURE_BLOB

The blob part is an input and output signature.


### -field D3D_BLOB_PATCH_CONSTANT_SIGNATURE_BLOB

The blob part is a patch constant signature.


### -field D3D_BLOB_ALL_SIGNATURE_BLOB

The blob part is all signature.


### -field D3D_BLOB_DEBUG_INFO

The blob part is debug information.


### -field D3D_BLOB_LEGACY_SHADER

The blob part is a legacy shader.


### -field D3D_BLOB_XNA_PREPASS_SHADER

The blob part is an XNA prepass shader.


### -field D3D_BLOB_XNA_SHADER

The blob part is an XNA shader.


### -field D3D_BLOB_PDB

The blob part is program database (PDB) information.

<div class="alert"><b>Note</b>  This value is supported by the D3dcompiler_44.dll or later version of the file.</div>
<div> </div>

### -field D3D_BLOB_PRIVATE_DATA

The blob part is private data.

<div class="alert"><b>Note</b>  This value is supported by the D3dcompiler_44.dll or later version of the file.</div>
<div> </div>

### -field D3D_BLOB_ROOT_SIGNATURE

The blob part is a root signature. Refer to <a href="https://docs.microsoft.com/windows/desktop/direct3d12/specifying-root-signatures-in-hlsl">Specifying Root Signatures in HLSL</a> for more information on using Direct3D12 with HLSL.

<div class="alert"><b>Note</b>  This value is supported by the D3dcompiler_47.dll or later version of the file.</div>
<div> </div>

### -field D3D_BLOB_DEBUG_NAME

The blob part is the debug name of the shader. If the application does not specify the debug name itself, an auto-generated name matching the PDB file of the shader is provided instead.

<div class="alert"><b>Note</b>  This value is supported by the D3dcompiler_47.dll as available on the Windows 10 Fall Creators Update and its SDK, or later version of the file.</div>
<div> </div>

### -field D3D_BLOB_TEST_ALTERNATE_SHADER

The blob part is a test alternate shader.

<div class="alert"><b>Note</b>  This value identifies a test part and is only produced by special compiler versions. Therefore, this part type is typically not present in shaders.</div>
<div> </div>

### -field D3D_BLOB_TEST_COMPILE_DETAILS

The blob part is test compilation details.

<div class="alert"><b>Note</b>  This value identifies a test part and is only produced by special compiler versions. Therefore, this part type is typically not present in shaders.</div>
<div> </div>

### -field D3D_BLOB_TEST_COMPILE_PERF

The blob part is test compilation performance.

<div class="alert"><b>Note</b>  This value identifies a test part and is only produced by special compiler versions. Therefore, this part type is typically not present in shaders.</div>
<div> </div>

### -field D3D_BLOB_TEST_COMPILE_REPORT

The blob part is a test compilation report.

<div class="alert"><b>Note</b>  This value identifies a test part and is only produced by special compiler versions. Therefore, this part type is typically not present in shaders.</div>
<div> </div>
<div class="alert"><b>Note</b>  This value is supported by the D3dcompiler_44.dll or later version of the file.</div>
<div> </div>

## -remarks



These values are passed to the <a href="https://docs.microsoft.com/windows/desktop/direct3dhlsl/d3dgetblobpart">D3DGetBlobPart</a> or  <a href="https://docs.microsoft.com/windows/desktop/direct3dhlsl/d3dsetblobpart">D3DSetBlobPart</a> function.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/direct3dhlsl/dx-graphics-d3dcompiler-reference-enums">Enumerations</a>
 

 

