---
UID: NC:dbghelp.PENUMDIRTREE_CALLBACKW
title: PENUMDIRTREE_CALLBACKW (dbghelp.h)
description: An application-defined callback function used with the EnumDirTree function. It is called every time a match is found.
old-location: base\enumdirtreeproc.htm
tech.root: Debug
ms.assetid: eae41b83-bba5-4656-9a5c-b6ef56845954
ms.date: 12/05/2018
ms.keywords: EnumDirTreeProc, EnumDirTreeProc callback, EnumDirTreeProc callback function, PENUMDIRTREE_CALLBACK, PENUMDIRTREE_CALLBACKW, _win32_enumdirtreeproc, base.enumdirtreeproc, dbghelp/EnumDirTreeProc
f1_keywords:
- dbghelp/EnumDirTreeProc
dev_langs:
- c++
req.header: dbghelp.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- UserDefined
api_location:
- DbgHelp.h
api_name:
- EnumDirTreeProc
targetos: Windows
req.typenames: 
req.redist: DbgHelp.dll 6.0 or later
ms.custom: 19H1
---

# PENUMDIRTREE_CALLBACKW callback function


## -description


An application-defined callback function used with the 
<a href="https://docs.microsoft.com/windows/desktop/api/dbghelp/nf-dbghelp-enumdirtree">EnumDirTree</a> function. It is called every time a match is found.

The <b>PENUMDIRTREE_CALLBACK</b> and <b>PENUMDIRTREE_CALLBACKW</b> types define a pointer to this callback function. 
<i>EnumDirTreeProc</i> is a placeholder for the application-defined function name.


## -parameters




### -param FilePath [in]

A pointer to a buffer that receives the full path of the file that is found.


### -param CallerData [in, optional]

A user-defined value specified in 
<a href="https://docs.microsoft.com/windows/desktop/api/dbghelp/nf-dbghelp-enumdirtree">EnumDirTree</a>, or <b>NULL</b>. Typically, this parameter is used by an application to pass a pointer to a data structure that enables the callback function to establish some context.


## -returns



To continue enumeration, the callback function must return <b>FALSE</b>.

To stop enumeration, the callback function must return <b>TRUE</b>.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/Debug/dbghelp-functions">DbgHelp Functions</a>



<a href="https://docs.microsoft.com/windows/desktop/api/dbghelp/nf-dbghelp-enumdirtree">EnumDirTree</a>
 

 

