---
UID: NC:dbghelp.PSYM_ENUMERATESYMBOLS_CALLBACKW
title: PSYM_ENUMERATESYMBOLS_CALLBACKW (dbghelp.h)
description: An application-defined callback function used with the SymEnumSymbols, SymEnumTypes, and SymEnumTypesByName functions.
old-location: base\symenumsymbolsproc.htm
tech.root: Debug
ms.assetid: c9f9aad8-754d-4ec8-92a3-8cf1929b9d8a
ms.date: 12/05/2018
ms.keywords: PSYM_ENUMERATESYMBOLS_CALLBACK, PSYM_ENUMERATESYMBOLS_CALLBACKW, PSYM_ENUMERATESYMBOLS_CALLBACKW callback function, SymEnumSymbolsProc, SymEnumSymbolsProc callback, SymEnumSymbolsProc callback function, _win32_symenumsymbolsproc, base.symenumsymbolsproc, dbghelp/PSYM_ENUMERATESYMBOLS_CALLBACK, dbghelp/PSYM_ENUMERATESYMBOLS_CALLBACKW, dbghelp/SymEnumSymbolsProc
f1_keywords:
- dbghelp/SymEnumSymbolsProc
dev_langs:
- c++
req.header: dbghelp.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: PSYM_ENUMERATESYMBOLS_CALLBACKW (Unicode) and PSYM_ENUMERATESYMBOLS_CALLBACK (ANSI)
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- UserDefined
api_location:
- DbgHelp.h
api_name:
- SymEnumSymbolsProc
- PSYM_ENUMERATESYMBOLS_CALLBACK
- PSYM_ENUMERATESYMBOLS_CALLBACKW
targetos: Windows
req.typenames: 
req.redist: DbgHelp.dll 5.1 or later
ms.custom: 19H1
---

# PSYM_ENUMERATESYMBOLS_CALLBACKW callback function


## -description


An application-defined callback function used with the 
    <a href="https://docs.microsoft.com/windows/desktop/api/dbghelp/nf-dbghelp-symenumsymbols">SymEnumSymbols</a>, 
    <a href="https://docs.microsoft.com/windows/desktop/api/dbghelp/nf-dbghelp-symenumtypes">SymEnumTypes</a>, and 
    <a href="https://docs.microsoft.com/windows/desktop/api/dbghelp/nf-dbghelp-symenumtypesbyname">SymEnumTypesByName</a> functions.

The <b>PSYM_ENUMERATESYMBOLS_CALLBACK</b> and 
    <b>PSYM_ENUMERATESYMBOLS_CALLBACKW</b> types define a pointer to this callback function. 
    <b>SymEnumSymbolsProc</b> is a placeholder for the 
    application-defined function name.


## -parameters




### -param pSymInfo [in]

A pointer to a <a href="https://docs.microsoft.com/windows/desktop/api/dbghelp/ns-dbghelp-symbol_info">SYMBOL_INFO</a> structure that 
      provides information about the symbol.


### -param SymbolSize [in]

The size of the symbol, in bytes. The size is calculated and is actually a guess. In some cases, this value 
      can be zero.


### -param UserContext [in, optional]

The user-defined value passed from the 
      <a href="https://docs.microsoft.com/windows/desktop/api/dbghelp/nf-dbghelp-symenumsymbols">SymEnumSymbols</a> or 
      <a href="https://docs.microsoft.com/windows/desktop/api/dbghelp/nf-dbghelp-symenumtypes">SymEnumTypes</a> function, or 
      <b>NULL</b>. This parameter is typically used by an application to pass a pointer to a data 
      structure that provides context information for the callback function.


## -returns



If the function returns <b>TRUE</b>, the enumeration will continue.

If the function returns <b>FALSE</b>, the enumeration will stop.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/Debug/dbghelp-functions">DbgHelp Functions</a>



<a href="https://docs.microsoft.com/windows/desktop/api/dbghelp/ns-dbghelp-symbol_info">SYMBOL_INFO</a>



<a href="https://docs.microsoft.com/windows/desktop/api/dbghelp/nf-dbghelp-symenumsymbols">SymEnumSymbols</a>



<a href="https://docs.microsoft.com/windows/desktop/api/dbghelp/nf-dbghelp-symenumtypes">SymEnumTypes</a>



<a href="https://docs.microsoft.com/windows/desktop/api/dbghelp/nf-dbghelp-symenumtypesbyname">SymEnumTypesByName</a>
 

 

