---
UID: NE:dbghelp._IMAGEHLP_SYMBOL_TYPE_INFO
title: IMAGEHLP_SYMBOL_TYPE_INFO (dbghelp.h)
description: Identifies the type of symbol information to be retrieved.
old-location: base\imagehlp_symbol_type_info.htm
tech.root: Debug
ms.assetid: 1b21c8dc-240f-4202-bd61-8f9dae0d053a
ms.date: 12/05/2018
ms.keywords: IMAGEHLP_SYMBOL_TYPE_INFO, IMAGEHLP_SYMBOL_TYPE_INFO enumeration, TI_FINDCHILDREN, TI_GET_ADDRESS, TI_GET_ADDRESSOFFSET, TI_GET_ARRAYINDEXTYPEID, TI_GET_BASETYPE, TI_GET_BITPOSITION, TI_GET_CALLING_CONVENTION, TI_GET_CHILDRENCOUNT, TI_GET_CLASSPARENTID, TI_GET_COUNT, TI_GET_DATAKIND, TI_GET_INDIRECTVIRTUALBASECLASS, TI_GET_IS_REFERENCE, TI_GET_LENGTH, TI_GET_LEXICALPARENT, TI_GET_NESTED, TI_GET_OFFSET, TI_GET_SYMINDEX, TI_GET_SYMNAME, TI_GET_SYMTAG, TI_GET_THISADJUST, TI_GET_TYPE, TI_GET_TYPEID, TI_GET_UDTKIND, TI_GET_VALUE, TI_GET_VIRTUALBASECLASS, TI_GET_VIRTUALBASEDISPINDEX, TI_GET_VIRTUALBASEOFFSET, TI_GET_VIRTUALBASEPOINTEROFFSET, TI_GET_VIRTUALTABLESHAPEID, TI_GTIEX_REQS_VALID, TI_IS_CLOSE_EQUIV_TO, TI_IS_EQUIV_TO, base.imagehlp_symbol_type_info, dbghelp/IMAGEHLP_SYMBOL_TYPE_INFO, dbghelp/TI_FINDCHILDREN, dbghelp/TI_GET_ADDRESS, dbghelp/TI_GET_ADDRESSOFFSET, dbghelp/TI_GET_ARRAYINDEXTYPEID, dbghelp/TI_GET_BASETYPE, dbghelp/TI_GET_BITPOSITION, dbghelp/TI_GET_CALLING_CONVENTION, dbghelp/TI_GET_CHILDRENCOUNT, dbghelp/TI_GET_CLASSPARENTID, dbghelp/TI_GET_COUNT, dbghelp/TI_GET_DATAKIND, dbghelp/TI_GET_INDIRECTVIRTUALBASECLASS, dbghelp/TI_GET_IS_REFERENCE, dbghelp/TI_GET_LENGTH, dbghelp/TI_GET_LEXICALPARENT, dbghelp/TI_GET_NESTED, dbghelp/TI_GET_OFFSET, dbghelp/TI_GET_SYMINDEX, dbghelp/TI_GET_SYMNAME, dbghelp/TI_GET_SYMTAG, dbghelp/TI_GET_THISADJUST, dbghelp/TI_GET_TYPE, dbghelp/TI_GET_TYPEID, dbghelp/TI_GET_UDTKIND, dbghelp/TI_GET_VALUE, dbghelp/TI_GET_VIRTUALBASECLASS, dbghelp/TI_GET_VIRTUALBASEDISPINDEX, dbghelp/TI_GET_VIRTUALBASEOFFSET, dbghelp/TI_GET_VIRTUALBASEPOINTEROFFSET, dbghelp/TI_GET_VIRTUALTABLESHAPEID, dbghelp/TI_GTIEX_REQS_VALID, dbghelp/TI_IS_CLOSE_EQUIV_TO, dbghelp/TI_IS_EQUIV_TO
f1_keywords:
- dbghelp/IMAGEHLP_SYMBOL_TYPE_INFO
dev_langs:
- c++
req.header: dbghelp.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- DbgHelp.h
api_name:
- IMAGEHLP_SYMBOL_TYPE_INFO
targetos: Windows
req.typenames: IMAGEHLP_SYMBOL_TYPE_INFO
req.redist: DbgHelp.dll 5.1 or later
ms.custom: 19H1
---

# IMAGEHLP_SYMBOL_TYPE_INFO enumeration


## -description


Identifies the type of symbol information to be retrieved.


## -enum-fields




### -field TI_GET_SYMTAG

The symbol tag.

The data type is <b>DWORD*</b>.


### -field TI_GET_SYMNAME

The symbol name.

The data type is <b>WCHAR**</b>. The caller must free the buffer.


### -field TI_GET_LENGTH

The length of the type.

The data type is <b>ULONG64*</b>.


### -field TI_GET_TYPE

The type.

The data type is <b>DWORD*</b>.


### -field TI_GET_TYPEID

The type index.

The data type is <b>DWORD*</b>.


### -field TI_GET_BASETYPE

The base type for the type index.

The data type is <b>DWORD*</b>.


### -field TI_GET_ARRAYINDEXTYPEID

The type index for index of an array type.

The data type is <b>DWORD*</b>.


### -field TI_FINDCHILDREN

The type index of all children.

The data type  is a pointer to a 
<a href="https://docs.microsoft.com/windows/desktop/api/dbghelp/ns-dbghelp-ti_findchildren_params">TI_FINDCHILDREN_PARAMS</a> structure. The <b>Count</b> member should be initialized with the number of children.


### -field TI_GET_DATAKIND

The data kind.

The data type is <b>DWORD*</b>.


### -field TI_GET_ADDRESSOFFSET

The address offset.

The data type is <b>DWORD*</b>.


### -field TI_GET_OFFSET

The offset of the type in the parent. Members can use this to get their offset in a structure.

The data type is <b>DWORD*</b>.


### -field TI_GET_VALUE

The value of a constant or enumeration value.

The data type is <b>VARIANT*</b>.


### -field TI_GET_COUNT

The count of array elements.

The data type is <b>DWORD*</b>.


### -field TI_GET_CHILDRENCOUNT

The number of children.

The data type is <b>DWORD*</b>.


### -field TI_GET_BITPOSITION

The bit position of a bitfield.

The data type is <b>DWORD*</b>.


### -field TI_GET_VIRTUALBASECLASS

A value that indicates whether the base class is virtually inherited.

The data type is <b>BOOL</b>.


### -field TI_GET_VIRTUALTABLESHAPEID

The symbol interface of the type of virtual table, for a user-defined type.


### -field TI_GET_VIRTUALBASEPOINTEROFFSET

The offset of the virtual base pointer.

The data type is <b>DWORD*</b>.


### -field TI_GET_CLASSPARENTID

The type index of the class parent.

The data type is <b>DWORD*</b>.


### -field TI_GET_NESTED

A value that indicates whether the type index is nested.

The data type is <b>DWORD*</b>.


### -field TI_GET_SYMINDEX

The symbol index for a type.

The data type is <b>DWORD*</b>.


### -field TI_GET_LEXICALPARENT

The lexical parent of the type.

The data type is <b>DWORD*</b>.


### -field TI_GET_ADDRESS

The index address.

The data type is <b>ULONG64*</b>.


### -field TI_GET_THISADJUST

The offset from the <b>this</b> pointer to its actual value.

The data type is <b>DWORD*</b>.


### -field TI_GET_UDTKIND

The UDT kind.

The data type is <b>DWORD*</b>.


### -field TI_IS_EQUIV_TO

The equivalency of two types.

The data type is <b>DWORD*</b>. The value is S_OK is the two types are equivalent, and S_FALSE otherwise.


### -field TI_GET_CALLING_CONVENTION

The calling convention.

The data type is <b>DWORD</b>. The following are the valid values:


### -field TI_IS_CLOSE_EQUIV_TO

The equivalency of two symbols. This is not guaranteed to be accurate.

The data type is <b>DWORD*</b>. The value is S_OK is the two types are equivalent, and S_FALSE otherwise.


### -field TI_GTIEX_REQS_VALID

The element where the valid request bitfield should be stored.

The data type is <b>ULONG64*</b>.

This value is only used with the <a href="https://docs.microsoft.com/windows/desktop/api/dbghelp/nf-dbghelp-symgettypeinfoex">SymGetTypeInfoEx</a> function.


### -field TI_GET_VIRTUALBASEOFFSET

The offset in the virtual function table of a virtual function.

The data type is <b>DWORD</b>.


### -field TI_GET_VIRTUALBASEDISPINDEX

The index into the virtual base displacement table.

The data type is <b>DWORD</b>.


### -field TI_GET_IS_REFERENCE

Indicates whether a pointer type is a reference.

The data type is <b>Boolean</b>.


### -field TI_GET_INDIRECTVIRTUALBASECLASS

Indicates whether the user-defined data type is an indirect virtual base.

The data type is <b>BOOL</b>.

<b>DbgHelp 6.6 and earlier:  </b>This value is not supported.


### -field TI_GET_VIRTUALBASETABLETYPE


### -field IMAGEHLP_SYMBOL_TYPE_INFO_MAX




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/dbghelp/nf-dbghelp-symgettypeinfo">SymGetTypeInfo</a>



<a href="https://docs.microsoft.com/windows/desktop/api/dbghelp/nf-dbghelp-symgettypeinfoex">SymGetTypeInfoEx</a>
 

 

