---
UID: NF:dbghelp.SymSrvStoreSupplementW
title: SymSrvStoreSupplementW function (dbghelp.h)
description: Stores a file in the specified supplement to a symbol store. The file is typically associated with a file in the symbol server.
old-location: base\symsrvstoresupplement.htm
tech.root: Debug
ms.assetid: 579bd9ff-cb23-426b-8188-6897d83ada28
ms.date: 12/05/2018
ms.keywords: SymSrvStoreSupplement, SymSrvStoreSupplement function, SymSrvStoreSupplementW, base.symsrvstoresupplement, dbghelp/SymSrvStoreSupplement, dbghelp/SymSrvStoreSupplementW
f1_keywords:
- dbghelp/SymSrvStoreSupplement
dev_langs:
- c++
req.header: dbghelp.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: SymSrvStoreSupplementW (Unicode) and SymSrvStoreSupplement (ANSI)
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Dbghelp.lib
req.dll: Dbghelp.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Dbghelp.dll
api_name:
- SymSrvStoreSupplement
- SymSrvStoreSupplement
- SymSrvStoreSupplementW
targetos: Windows
req.typenames: 
req.redist: DbgHelp.dll 6.3 or later
ms.custom: 19H1
---

# SymSrvStoreSupplementW function


## -description


Stores a file in the specified supplement to a symbol store. The file is typically associated with a file in the symbol server.


## -parameters




### -param hProcess [in]

A handle to a process. This handle must have been previously passed to the 
<a href="https://docs.microsoft.com/windows/desktop/api/dbghelp/nf-dbghelp-syminitialize">SymInitialize</a> function.


#### - SymPath [in, optional]

The path to the symbol store.


### -param Node [in]

The symbol file associated with the supplemental file.


### -param File [in]

The name of the file.


### -param Flags [in]

If this parameter is <b>SYMSTOREOPT_COMPRESS</b>, the file is compressed in the symbol store. Currently, there are no other supported values.


## -returns



If the function succeeds, the return value is the fully qualified path for the supplemental file.
						

If the function fails, the return value is <b>NULL</b>. To retrieve extended error information, call 
<a href="https://docs.microsoft.com/windows/desktop/api/errhandlingapi/nf-errhandlingapi-getlasterror">GetLastError</a>.




## -remarks



An important use for this function is to store delta files. For more information, see <a href="https://docs.microsoft.com/windows/desktop/api/dbghelp/nf-dbghelp-symsrvdeltaname">SymSrvDeltaName</a>.

This function returns a pointer to a buffer that may be reused by another function. Therefore, be sure to copy the data returned to another buffer immediately.

The symbol server stores supplemental files with the same extension in a common directory. For example, Sup1.xml would be stored in the following directory: <i>SymPath</i>\supplement\<i>Node</i>\xml.

The administrator of a store can prevent users from writing supplemental files by creating a read-only file in the root of the store named Supplement. Alternatively, the administrator can create the supplement directory and use ACLs to control access.

All DbgHelp functions, such as this one, are single threaded. Therefore, calls from more than one thread to this function will likely result in unexpected behavior or memory corruption. To avoid this, you must synchronize all concurrent calls from more than one thread to this function.

To call the Unicode version of this function, define DBGHELP_TRANSLATE_TCHAR.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/Debug/dbghelp-functions">DbgHelp Functions</a>



<a href="https://docs.microsoft.com/windows/desktop/api/dbghelp/nf-dbghelp-symsrvgetsupplement">SymSrvGetSupplement</a>
 

 

