---
UID: NS:dcommon.D2D_RECT_F
title: D2D_RECT_F (dcommon.h)
description: Represents a rectangle defined by the coordinates of the upper-left corner (left, top) and the coordinates of the lower-right corner (right, bottom).
old-location: direct2d\D2D_RECT_F.htm
tech.root: Direct2D
ms.assetid: 84bd7ab0-f273-46f8-b261-86cd1d7f3868
ms.date: 12/05/2018
ms.keywords: D2D1_RECT_F, D2D_RECT_F, D2D_RECT_F structure [Direct2D], dcommon/D2D_RECT_F, direct2d.D2D_RECT_F
f1_keywords:
- dcommon/D2D_RECT_F
dev_langs:
- c++
req.header: dcommon.h
req.include-header: D2d1.h
req.target-type: Windows
req.target-min-winverclnt: Windows 7, Windows Vista with SP2 and Platform Update for Windows Vista [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2008 R2, Windows Server 2008 with SP2 and Platform Update for Windows Server 2008 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- dcommon.h
api_name:
- D2D_RECT_F
targetos: Windows
req.typenames: D2D_RECT_F
req.redist: 
ms.custom: 19H1
---

# D2D_RECT_F structure


## -description


Represents a rectangle defined by the coordinates of the upper-left corner (left, top) and the coordinates of the lower-right corner (right, bottom).




## -struct-fields




### -field left

Type: <b>FLOAT</b>

The x-coordinate of the upper-left corner of the rectangle.


### -field top

Type: <b>FLOAT</b>

The y-coordinate of the upper-left corner of the rectangle. 


### -field right

Type: <b>FLOAT</b>

The x-coordinate of the lower-right corner of the rectangle. 


### -field bottom

Type: <b>FLOAT</b>

The y-coordinate of the lower-right corner of the rectangle. 


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/Direct2D/d2d1-rect-f">D2D1_RECT_F</a>
 

 

