---
UID: NS:dcommon.D2D_RECT_U
title: D2D_RECT_U (dcommon.h)
description: Represents a rectangle defined by the upper-left corner pair of coordinates (left,top) and the lower-right corner pair of coordinates (right, bottom). These coordinates are expressed as a 32-bit integer values.
old-location: direct2d\D2D_RECT_U.htm
tech.root: Direct2D
ms.assetid: 7eeec8ac-ba56-4e80-b980-813a3e958e09
ms.date: 12/05/2018
ms.keywords: D2D1_RECT_U, D2D_RECT_U, D2D_RECT_U structure [Direct2D], dcommon/D2D_RECT_U, direct2d.D2D_RECT_U
f1_keywords:
- dcommon/D2D_RECT_U
dev_langs:
- c++
req.header: dcommon.h
req.include-header: D2d1.h
req.target-type: Windows
req.target-min-winverclnt: Windows 7, Windows Vista with SP2 and Platform Update for Windows Vista [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2008 R2, Windows Server 2008 with SP2 and Platform Update for Windows Server 2008 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- dcommon.h
api_name:
- D2D_RECT_U
targetos: Windows
req.typenames: D2D_RECT_U
req.redist: 
ms.custom: 19H1
---

# D2D_RECT_U structure


## -description


Represents a rectangle defined by the upper-left corner  pair of coordinates (left,top) and the lower-right corner pair of coordinates (right, bottom). These coordinates are expressed as a 32-bit integer values.


## -struct-fields




### -field left

Type: <b>UINT32</b>

The x-coordinate of the upper-left corner of the rectangle.


### -field top

Type: <b>UINT32</b>

The y-coordinate of the upper-left corner of the rectangle. 


### -field right

Type: <b>UINT32</b>

The x-coordinate of the lower-right corner of the rectangle. 


### -field bottom

Type: <b>UINT32</b>

The y-coordinate of the lower-right corner of the rectangle. 

