---
UID: NS:ddkmapi._DDGETFIELDNUMIN
title: DDGETFIELDNUMIN (ddkmapi.h)
description: The DDGETFIELDNUMIN structure contains the Microsoft DirectDraw and video port extensions (VPE) object handle information.
old-location: display\ddgetfieldnumin.htm
tech.root: display
ms.assetid: d0f8d7d0-6af6-44d1-8f18-d77ce6502b3f
ms.date: 12/05/2018
ms.keywords: '*LPDDGETFIELDNUMIN, DDGETFIELDNUMIN, DDGETFIELDNUMIN structure [Display Devices], LPDDGETFIELDNUMIN, LPDDGETFIELDNUMIN structure pointer [Display Devices], ddkmapi/DDGETFIELDNUMIN, ddkmapi/LPDDGETFIELDNUMIN, ddstrcts_d975a952-2893-44cf-a7cb-57b3dd3b633c.xml, display.ddgetfieldnumin'
f1_keywords:
- ddkmapi/DDGETFIELDNUMIN
dev_langs:
- c++
req.header: ddkmapi.h
req.include-header: Ddkmapi.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- ddkmapi.h
api_name:
- DDGETFIELDNUMIN
targetos: Windows
req.typenames: DDGETFIELDNUMIN, *LPDDGETFIELDNUMIN
req.redist: 
ms.custom: 19H1
---

# DDGETFIELDNUMIN structure


## -description


The DDGETFIELDNUMIN structure contains the Microsoft DirectDraw and <a href="https://docs.microsoft.com/windows-hardware/drivers/">video port extensions (VPE)</a> object handle information. 


## -struct-fields




### -field hDirectDraw

Specifies the DirectDraw handle.


### -field hVideoPort

Specifies the VPE object handle.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/hardware/drivers/ff550686(v=vs.85)">DD_DXAPI_GET_VP_FIELD_NUMBER</a>



<a href="https://docs.microsoft.com/windows-hardware/drivers/ddi/content/dxapi/nf-dxapi-dxapi">DxApi</a>
 

 

